/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.install.JavaRuntimeWizard;
import com.spacekiller.infection.swing.InstanceCustomizer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;

public class JavaRuntimeWizardPanel
extends JPanel {
    private static final long serialVersionUID = -8444239697562533091L;
    private static final Logger logger = Logger.getLogger(JavaRuntimeWizardPanel.class.getName());
    private InstanceCustomizer infectionInstanceCustomizer;
    private JavaRuntimeWizard javaRuntimeWizard;
    private String[] optimizedJvmOptions;
    private boolean approvedOptions;
    private JButton btnTestBestOptions;
    private JButton btnApply;
    private JButton btnCancel;
    private JTextPane textPaneResults;

    public JavaRuntimeWizardPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelActions = new JPanel();
        GridBagConstraints gbc_panelActions = new GridBagConstraints();
        gbc_panelActions.weightx = 1.0;
        gbc_panelActions.insets = new Insets(4, 4, 5, 4);
        gbc_panelActions.fill = 1;
        gbc_panelActions.gridx = 0;
        gbc_panelActions.gridy = 0;
        this.add((Component)panelActions, gbc_panelActions);
        GridBagLayout gbl_panelActions = new GridBagLayout();
        gbl_panelActions.columnWidths = new int[]{0, 0};
        gbl_panelActions.rowHeights = new int[]{0, 0};
        gbl_panelActions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelActions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelActions.setLayout(gbl_panelActions);
        this.btnTestBestOptions = new JButton("Test Java-Options...");
        this.btnTestBestOptions.setToolTipText("Test recommended Java-Options...");
        this.btnTestBestOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaRuntimeWizardPanel.this.actionStartTestBestJavaOptions();
            }
        });
        this.btnTestBestOptions.setMargin(new Insets(2, 4, 2, 4));
        GridBagConstraints gbc_btnTestBestOptions = new GridBagConstraints();
        gbc_btnTestBestOptions.gridx = 0;
        gbc_btnTestBestOptions.gridy = 0;
        panelActions.add((Component)this.btnTestBestOptions, gbc_btnTestBestOptions);
        JPanel panelResults = new JPanel();
        GridBagConstraints gbc_panelResults = new GridBagConstraints();
        gbc_panelResults.insets = new Insets(4, 4, 5, 4);
        gbc_panelResults.weighty = 1.0;
        gbc_panelResults.weightx = 1.0;
        gbc_panelResults.fill = 1;
        gbc_panelResults.gridx = 0;
        gbc_panelResults.gridy = 1;
        this.add((Component)panelResults, gbc_panelResults);
        GridBagLayout gbl_panelResults = new GridBagLayout();
        gbl_panelResults.columnWidths = new int[]{0, 0};
        gbl_panelResults.rowHeights = new int[]{0, 0, 0};
        gbl_panelResults.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelResults.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelResults.setLayout(gbl_panelResults);
        JLabel lblNewLabel = new JLabel("Test Results:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 0);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        panelResults.add((Component)lblNewLabel, gbc_lblNewLabel);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        panelResults.add((Component)scrollPane, gbc_scrollPane);
        this.textPaneResults = new JTextPane();
        this.textPaneResults.setEditable(false);
        scrollPane.setViewportView(this.textPaneResults);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 2;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.btnApply = new JButton("Apply");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaRuntimeWizardPanel.this.actionApply();
            }
        });
        GridBagConstraints gbc_btnApply = new GridBagConstraints();
        gbc_btnApply.insets = new Insets(0, 0, 0, 5);
        gbc_btnApply.gridx = 0;
        gbc_btnApply.gridy = 0;
        panel.add((Component)this.btnApply, gbc_btnApply);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaRuntimeWizardPanel.this.actionCancel();
            }
        });
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.gridx = 1;
        gbc_btnCancel.gridy = 0;
        panel.add((Component)this.btnCancel, gbc_btnCancel);
        this.initJavaRuntimeWizardPanel();
    }

    protected void initJavaRuntimeWizardPanel() {
        this.setPreferredSize(new Dimension(650, 450));
        this.checkEnable();
        String helpInfo = "Note: Please click the 'Test'-Button above to start the test.";
        this.getTextPaneResults().setText(helpInfo);
    }

    protected void checkEnable() {
        boolean enableApplyButton = false;
        if (this.optimizedJvmOptions != null) {
            enableApplyButton = true;
        }
        this.getBtnApply().setEnabled(enableApplyButton);
    }

    protected JButton getBtnTestBestOptions() {
        return this.btnTestBestOptions;
    }

    public InstanceCustomizer getInfectionInstanceCustomizer() {
        return this.infectionInstanceCustomizer;
    }

    public void setInfectionInstanceCustomizer(InstanceCustomizer infectionInstanceCustomizer) {
        this.infectionInstanceCustomizer = infectionInstanceCustomizer;
    }

    public JavaRuntimeWizard getJavaRuntimeWizard() {
        return this.javaRuntimeWizard;
    }

    public void setJavaRuntimeWizard(JavaRuntimeWizard javaRuntimeWizard) {
        this.javaRuntimeWizard = javaRuntimeWizard;
    }

    protected String[] showJavaRuntimeWizardDialog(Component parent) {
        String title = "Java Runtime Wizard";
        Dialog dialog = null;
        Window owner = SwingUtilities.getWindowAncestor(parent);
        if (owner != null) {
            if (owner instanceof Frame) {
                dialog = new JDialog((Frame)owner);
            }
            if (owner instanceof Dialog) {
                dialog = new JDialog((Dialog)owner);
            }
        }
        if (dialog == null) {
            dialog = new JDialog();
        }
        dialog.setModal(true);
        dialog.setTitle(title);
        ((JDialog)dialog).setContentPane(this);
        dialog.pack();
        Infection.centerWindow(dialog);
        dialog.setVisible(true);
        if (!this.isApprovedOptions()) {
            return null;
        }
        return this.getOptimizedJvmOptions();
    }

    protected void actionStartTestBestJavaOptions() {
        try {
            this.setOptimizedJvmOptions(null);
            this.checkEnable();
            StyledDocument styledDocument = this.getTextPaneResults().getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaRuntimeWizardPanel.this.testBestJavaOptions();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            };
            String threadName = "JavaRuntimeWizard";
            Thread thread = new Thread(runnable, threadName);
            thread.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void testBestJavaOptions() {
        JavaRuntimeWizard javaRuntimeWizard = this.getJavaRuntimeWizard();
        if (javaRuntimeWizard == null) {
            return;
        }
        InstanceCustomizer instanceCustomizer = this.getInfectionInstanceCustomizer();
        if (instanceCustomizer == null) {
            return;
        }
        JTextPane resultTextPane = this.getTextPaneResults();
        final String[] optimizedJvmOptions = javaRuntimeWizard.computeOptimizedJvmOptions(instanceCustomizer, resultTextPane);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (optimizedJvmOptions != null) {
                    JavaRuntimeWizardPanel.this.setOptimizedJvmOptions(optimizedJvmOptions);
                }
                JavaRuntimeWizardPanel.this.checkEnable();
            }
        });
    }

    public String[] getOptimizedJvmOptions() {
        return this.optimizedJvmOptions;
    }

    public void setOptimizedJvmOptions(String[] optimizedJvmOptions) {
        this.optimizedJvmOptions = optimizedJvmOptions;
    }

    protected JButton getBtnApply() {
        return this.btnApply;
    }

    protected JButton getBtnCancel() {
        return this.btnCancel;
    }

    protected JTextPane getTextPaneResults() {
        return this.textPaneResults;
    }

    protected void actionApply() {
        this.setApprovedOptions(true);
        this.closeDialog();
    }

    protected void actionCancel() {
        this.setApprovedOptions(false);
        this.closeDialog();
    }

    private void closeDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.dispose();
        }
    }

    protected boolean isApprovedOptions() {
        return this.approvedOptions;
    }

    protected void setApprovedOptions(boolean approvedOptions) {
        this.approvedOptions = approvedOptions;
    }
}

