/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.swing;

import com.spacekiller.project.swing.ProjectNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ProjectTreeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7531408706869738567L;
    public static final int COL_EXPAND = 0;
    public static final int COL_SELECT = 1;
    public static final int COL_GROUP_ID = 2;
    public static final int COL_PROJECT_ID = 3;
    public static final int COL_VERSION = 4;
    public static final int COL_TITLE = 5;
    public static final int COL_TIME = 6;
    public static final int COLUMN_COUNT = 7;
    protected List<ProjectNode> nodeList = new ArrayList<ProjectNode>();

    @Override
    public int getRowCount() {
        return this.nodeList.size();
    }

    public ProjectNode getTreeNode(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(rowIndex);
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProjectNode node = this.getTreeNode(rowIndex);
        if (node == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return node.isExpanded();
            }
            case 1: {
                return node.isSelected();
            }
            case 2: {
                return node.getGroupId();
            }
            case 3: {
                return node.getProjectId();
            }
            case 4: {
                return node.getVersion();
            }
            case 5: {
                return node.getTitle();
            }
            case 6: {
                return node.getTime();
            }
        }
        return null;
    }
}

