/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.AbstractCollisionGroup;
import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElement;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.CollisionActor;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionDetector;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.DefaultCollisionDetector;
import com.spacekiller.game2d.DefaultEngine;
import com.spacekiller.game2d.DefaultScene;
import com.spacekiller.game2d.DefaultSurface;
import com.spacekiller.game2d.DefaultSurfaceRumbler;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementListener;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.EndOfSceneException;
import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.RumbleStopAction;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.Scene;
import com.spacekiller.game2d.Sensor;
import com.spacekiller.game2d.SensorListener;
import com.spacekiller.game2d.Speed2D;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.Timer;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Asteroid;
import com.spacekiller.spacekiller.Cockpit;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.EndSensor;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.Gadget;
import com.spacekiller.spacekiller.GadgetManager;
import com.spacekiller.spacekiller.GadgetType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.SpeedListener;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.weapons.Bullet;
import com.spacekiller.spacekiller.weapons.Emp;
import com.spacekiller.spacekiller.weapons.Laser;
import com.spacekiller.spacekiller.weapons.LaserGun;
import java.awt.DisplayMode;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.Clip;

public abstract class AbstractLevel
extends DefaultScene
implements Level {
    private Object designer;
    protected int orientation = 1;
    private Engine engine;
    private Surface surface;
    protected CollisionDetector detector;
    protected ElementView elementView;
    protected ElementModel elementModel;
    protected View gameOverView;
    private double scrollSpeedX = 0.2;
    private double scrollSpeedY = 0.0;
    private List scrollListeners = new ArrayList();
    private Cockpit cockpit;
    private Set ships = new HashSet(256);
    private Set bullets = new HashSet(256);
    private CollisionGroup playerShipCollisionGroup;
    private CollisionGroup playerBulletCollisionGroup;
    private CollisionGroup enemyCollisionGroup;
    private CollisionGroup enemyBulletCollisionGroup;
    private Ship lastBoss;
    private DefaultSurfaceRumbler surfaceRumbler;
    private Timer timer;
    private boolean completed;
    private Speed2D tempSpeed = new Speed2D.Double();
    private DisplayMode sourceDisplayMode;
    private DisplayMode targetDisplayMode;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private List playerShips = new ArrayList();

    public AbstractLevel() {
        this.setDetector((CollisionDetector)new DefaultCollisionDetector());
        this.setSourceDisplayMode(new DisplayMode(1280, 1024, 32, 75));
    }

    @Override
    public Object getDesigner() {
        return this.designer;
    }

    protected void setDesigner(Object object) {
        this.designer = object;
    }

    @Override
    public void addShip(Ship ship) {
        if (!this.ships.contains((Object)ship)) {
            this.ships.add(ship);
            this.elementModel.add((Element)ship);
        }
    }

    @Override
    public int getShipCount() {
        return this.ships.size();
    }

    @Override
    public void removeShip(Ship ship) {
        if (this.ships.contains((Object)ship)) {
            this.ships.remove((Object)ship);
            this.elementModel.remove((Element)ship);
        }
    }

    @Override
    public Iterator getShips() {
        return this.ships.iterator();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int i) {
        this.orientation = i;
    }

    @Override
    public void addBullet(Bullet b) {
        if (!this.bullets.contains((Object)b)) {
            this.bullets.add(b);
            this.elementModel.add((Element)b);
        }
    }

    @Override
    public void removeBullet(Bullet b) {
        if (this.bullets.contains((Object)b)) {
            this.bullets.remove((Object)b);
            this.elementModel.remove((Element)b);
        }
    }

    public void initialize() throws Exception {
        this.setCompleted(false);
        this.setTimer(new Timer((Scene)this));
        HashSet<CollisionGroup> playerBulletsEnemyGroups = new HashSet<CollisionGroup>();
        this.playerBulletCollisionGroup = new PlayerBulletCollisionGroup(this, this.detector, playerBulletsEnemyGroups);
        HashSet<CollisionGroup> playerShipEnemyGroups = new HashSet<CollisionGroup>();
        this.playerShipCollisionGroup = new PlayerShipCollisionGroup(this, this.detector, playerShipEnemyGroups);
        HashSet<CollisionGroup> enemyEnemyGroups = new HashSet<CollisionGroup>();
        this.enemyCollisionGroup = new EnemyCollisionGroup(this, this.detector, enemyEnemyGroups);
        HashSet<CollisionGroup> enemyBulletsEnemyGroups = new HashSet<CollisionGroup>();
        this.enemyBulletCollisionGroup = new EnemyBulletCollisionGroup(this, this.detector, enemyBulletsEnemyGroups);
        playerShipEnemyGroups.add(this.enemyCollisionGroup);
        playerBulletsEnemyGroups.add(this.enemyCollisionGroup);
        enemyEnemyGroups.add(this.playerShipCollisionGroup);
        enemyBulletsEnemyGroups.add(this.playerShipCollisionGroup);
    }

    protected ElementModel readModel(InputStream in) throws Exception {
        return (ElementModel)this.getPersistenceManager().readModel(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementModel readModel(File file) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        try {
            ElementModel elementModel = this.readModel(fin);
            return elementModel;
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementModel readModel(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            ElementModel elementModel = this.readModel(in);
            return elementModel;
        }
        finally {
            in.close();
        }
    }

    @Override
    public Surface getSurface() {
        return this.surface;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        if (surface != null && surface instanceof DefaultSurface) {
            this.setSurfaceRumbler(new DefaultSurfaceRumbler((DefaultSurface)surface, 10, 100));
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Override
    public ElementModel getElementModel() {
        return this.elementModel;
    }

    protected void setElementModel(ElementModel model) {
        this.elementModel = model;
    }

    @Override
    public CollisionDetector getDetector() {
        return this.detector;
    }

    protected void setDetector(CollisionDetector detector) {
        this.detector = detector;
    }

    protected void handlePlayerShipCollision(Ship e, Element o, long ms, PlayerShipCollisionActor actor) throws Exception {
        double playerSpeedX = 0.0;
        double playerSpeedY = 0.0;
        MoveActor playerShipMoveActor = e.getMoveActor();
        if (playerShipMoveActor != null) {
            playerShipMoveActor.getSpeed(this.tempSpeed);
            playerSpeedX = this.tempSpeed.getSpeedX();
            playerSpeedY = this.tempSpeed.getSpeedY();
        }
        if (o instanceof Ship) {
            Ship enemyShip = (Ship)o;
            double enemySpeedX = 0.0;
            double enemySpeedY = 0.0;
            MoveActor enemyShipMoveActor = enemyShip.getMoveActor();
            if (enemyShipMoveActor != null) {
                enemyShipMoveActor.getSpeed(this.tempSpeed);
                enemySpeedX = this.tempSpeed.getSpeedX();
                enemySpeedY = this.tempSpeed.getSpeedY();
            }
            double newSpeedX = -playerSpeedX * 3.0 + enemySpeedX * 3.0;
            double newSpeedY = -playerSpeedY * 3.0 + enemySpeedY * 3.0;
            double factor = 0.1;
            double en = factor * (double)ms + actor.energyDelta;
            int energy = (int)en;
            actor.energyDelta = en - (double)energy;
            int enemyHitEnergy = energy * 40;
            if (!enemyShip.isExploding()) {
                enemyShip.incrementShield(-enemyHitEnergy);
                if (enemyShip.getShield() <= 0.0) {
                    int killScore;
                    Commander player;
                    enemyShip.setExploding(true);
                    this.performShipExplosion(enemyShip);
                    this.handleEnemyShipDestroyed(enemyShip);
                    if (e != null && (player = e.getCommander()) != null && (killScore = enemyShip.getKillScore()) > 0) {
                        player.incrementScore(killScore);
                    }
                }
            }
            if (!e.isExploding()) {
                SpeedBehavior playerSpeed = e.getSpeedBehavior();
                if (playerSpeed != null) {
                    playerSpeed.setSpeedX(newSpeedX);
                    playerSpeed.setSpeedY(newSpeedY);
                }
                e.incrementShield(-energy);
                if (e.getShield() <= 0.0) {
                    e.setExploding(true);
                    this.performShipExplosion(e);
                    this.handlePlayerShipDestroyed(e);
                }
            }
            this.rumble(0.5f, 100);
            return;
        }
        if (o instanceof Gadget) {
            Gadget gadget = (Gadget)o;
            this.elementModel.remove((Element)gadget);
            this.handlePlayerShipPickupGadget(e, gadget);
            return;
        }
        if (o instanceof Asteroid) {
            Asteroid aster = (Asteroid)o;
            double power = Math.max(aster.getPower(), 0.0);
            e.incrementShield(-power);
            if (e.getShield() <= 0.0) {
                e.setExploding(true);
                this.performShipExplosion(e);
                this.handlePlayerShipDestroyed(e);
            }
            this.elementModel.remove((Element)aster);
            this.rumble(0.8f, 100);
            return;
        }
        double newSpeedX = -playerSpeedX * 2.0;
        double newSpeedY = -playerSpeedY * 2.0;
        SpeedBehavior playerSpeed = e.getSpeedBehavior();
        if (playerSpeed != null) {
            playerSpeed.setSpeedX(newSpeedX);
            playerSpeed.setSpeedY(newSpeedY);
        }
    }

    protected void handlePlayerBulletCollision(Bullet e, Element o) throws Exception {
        Ship ship;
        Weapon weapon = e.getWeapon();
        this.performBulletHitAnimation(e, o);
        if (weapon != null) {
            weapon.handleBulletCollision(e, o);
        }
        this.elementModel.remove((Element)e);
        if (o instanceof Ship && !(ship = (Ship)o).isExploding()) {
            if (weapon != null) {
                ship.incrementShield(-weapon.getPower());
            }
            if (ship.getShield() <= 0.0) {
                ship.setExploding(true);
                this.handlePlayerKilledEnemyShip(weapon, ship);
            }
        }
    }

    protected void handlePlayerLaserCollision(Laser e, Element o, double cx, double cy, long ms) throws Exception {
        Ship ship;
        this.performLaserHitAnimation(e, o, cx, cy);
        Weapon weapon = e.getWeapon();
        if (o instanceof Ship && !(ship = (Ship)o).isExploding()) {
            if (weapon != null) {
                ship.incrementShield(-weapon.getPower() * (double)ms);
            }
            if (ship.getShield() <= 0.0) {
                ship.setExploding(true);
                this.handlePlayerKilledEnemyShip(weapon, ship);
            }
        }
    }

    protected void handlePlayerEmpCollision(Emp e, Element o) throws Exception {
        Ship ship;
        Weapon weapon = e.getWeapon();
        if (o instanceof Ship && !(ship = (Ship)o).isExploding()) {
            if (weapon != null) {
                ship.incrementShield(-weapon.getPower());
            }
            if (ship.getShield() <= 0.0) {
                ship.setExploding(true);
                this.handlePlayerKilledEnemyShip(weapon, ship);
            }
        }
    }

    protected void handlePlayerKilledEnemyShip(Weapon weapon, Ship ship) throws Exception {
        int killScore;
        Commander player;
        this.performShipExplosion(ship);
        this.handleEnemyShipDestroyed(ship);
        Ship playerShip = weapon.getShip();
        if (playerShip != null && (player = playerShip.getCommander()) != null && (killScore = ship.getKillScore()) > 0) {
            player.incrementScore(killScore);
        }
    }

    protected void handlePlayerShipDestroyed(Ship ship) throws Exception {
        System.out.println("> handlePlayerShipDestroyed: " + (Object)((Object)ship));
        Commander commander = ship.getCommander();
        if (commander != null) {
            System.out.println(" - Destroyed-Ship: " + (Object)((Object)ship));
            System.out.println(" - Commander-Ship: " + (Object)((Object)commander.getShip()));
            if (ship == commander.getShip()) {
                Cockpit cp = this.getCockpit();
                if (cp != null) {
                    cp.setActive(false);
                }
                int numSets = ship.getWeaponSetCount();
                for (int i = 0; i < numSets; ++i) {
                    WeaponSet ws = ship.getWeaponSetAt(i);
                    ws.deactivateWeapons();
                }
                this.surfaceRumbler.setIntensity(20);
                this.surfaceRumbler.setDuration(800);
                this.addActor((Actor)this.surfaceRumbler);
                this.rumble(1.0f, 1000);
                int newLives = commander.getLives() - 1;
                commander.setLives(newLives);
                System.out.println(" -> New lives: " + newLives);
                if (newLives < 1) {
                    int gameOverDelay = 2000;
                    this.getTimer().addActor((long)gameOverDelay, (Actor)new GameOverActor());
                } else {
                    int reincDelay = 2000;
                    this.getTimer().addActor((long)reincDelay, (Actor)new ReincarnationActor(ship));
                }
            }
        }
    }

    protected void handlePlayerShipPickupGadget(Ship ship, Gadget gadget) throws Exception {
        GadgetManager gman;
        GadgetType type = (GadgetType)gadget.getType();
        if (type != null && (gman = type.getGadgetManager()) != null) {
            gman.installGadget(gadget, this, ship);
            Clip clip = type.getAudioClip();
            if (clip != null) {
                this.playAudioClip(clip, ship);
            }
        }
    }

    protected void handleEnemyShipCollision(Ship e, Element o) throws Exception {
    }

    protected void handleEnemyBulletCollision(Bullet e, Element o) throws Exception {
        Ship ship;
        Weapon weapon = e.getWeapon();
        this.performBulletHitAnimation(e, o);
        if (weapon != null) {
            weapon.handleBulletCollision(e, o);
        }
        this.elementModel.remove((Element)e);
        if (o instanceof Ship && !(ship = (Ship)o).isExploding()) {
            double shield;
            Commander player = ship.getCommander();
            boolean extension = ship.getOwner() != null;
            double oldShield = ship.getShield();
            if (weapon != null) {
                ship.incrementShield(-weapon.getPower());
            }
            if ((shield = ship.getShield()) <= 0.0) {
                ship.setExploding(true);
                this.performShipExplosion(ship);
                this.handlePlayerShipDestroyed(ship);
            } else if (player != null && !extension) {
                Clip clip;
                ShipType type;
                this.rumble(0.7f, 250);
                double alertShieldMin = 40.0;
                if (shield < alertShieldMin && oldShield >= alertShieldMin && (type = ship.getShipType()) != null && (clip = type.getAlertClip()) != null) {
                    this.playAudioClip(clip, ship);
                }
            }
        }
    }

    protected void handleEnemyShipDestroyed(Ship ship) throws Exception {
        int gadgets = ship.getGadgetCount();
        if (gadgets > 0) {
            ElementModel model = this.getElementModel();
            for (int c = 0; c < gadgets; ++c) {
                Gadget g = ship.getGadgetAt(c);
                if (g == null) continue;
                g.setCollisionGroup(this.getEnemyCollisionGroup());
                model.add((Element)g);
                double x = ship.getX() + ship.getWidth() / 2.0;
                double y = ship.getY() + ship.getHeight() / 2.0;
                if (c > 0) {
                    x += ship.getWidth() * (Math.random() - 0.5);
                    y += ship.getHeight() * (Math.random() - 0.5);
                }
                model.moveTo((Element)g, x, y);
            }
        }
        if (ship == this.lastBoss) {
            LevelCompletedActor lca = new LevelCompletedActor();
            this.getTimer().addActor(3000L, (Actor)lca);
        }
    }

    void performBulletHitAnimation(Bullet bullet, Element target) throws Exception {
        AnimationElementType bulletHitType = bullet.getBulletHitAnimationType();
        if (bulletHitType != null) {
            double aniY;
            Animation ani = bulletHitType.getAnimation();
            double aniX = bullet.getX() + bullet.getWidth() / 2.0 - (double)(ani.getWidth() / 2);
            Element aniElement = bulletHitType.createElement((Object)"bulletHit", aniX, aniY = bullet.getY() + bullet.getHeight() / 2.0 - (double)(ani.getHeight() / 2), 1.0, 1.0);
            if (aniElement != null) {
                this.elementModel.add(aniElement);
                this.addActor((Actor)((AnimationRenderer)aniElement.getRenderer()));
            }
        }
    }

    protected void performBulletHitAnimation(Bullet bullet, Element target, double cx, double cy) throws Exception {
        int h;
        Animation ani;
        int w;
        Element aniElement;
        AnimationElementType bulletHitType = bullet.getBulletHitAnimationType();
        if (bulletHitType != null && (aniElement = bulletHitType.createElement((Object)"bulletHit", cx - (double)((w = (ani = bulletHitType.getAnimation()).getWidth()) / 2), cy - (double)((h = ani.getHeight()) / 2), 1.0, 1.0)) != null) {
            this.elementModel.add(aniElement);
            this.addActor((Actor)((AnimationRenderer)aniElement.getRenderer()));
        }
    }

    protected void performLaserHitAnimation(Laser laser, Element target, double cx, double cy) throws Exception {
        LaserGun laserGun = (LaserGun)laser.getWeapon();
        Animation ani = laserGun.getLaserHitType().getAnimation();
        Element aniElement = laserGun.getLaserHitElement();
        if (aniElement != null) {
            if (aniElement.getModel() == null) {
                this.elementModel.add(aniElement);
                this.addActor((Actor)((AnimationRenderer)aniElement.getRenderer()));
            }
            this.elementModel.moveTo(aniElement, cx - (double)(ani.getWidth() / 2), cy - (double)(ani.getHeight() / 2));
        }
    }

    protected void performShipExplosion(Ship ship) throws Exception {
        ExplosionType type = ship.getShipType().getExplosionType();
        if (type != null) {
            type.performExplosion(this, ship, new ShipRemoveActor(ship));
        } else {
            System.out.println("OOPS: ship-type is null: " + (Object)((Object)ship) + " => " + type);
        }
    }

    protected void performShipReincarnation(Ship ship) throws Exception {
        Cockpit cp;
        ship.setShield(ship.getMaxShield());
        ship.setPower(ship.getMaxPower());
        ship.setExploding(false);
        ElementModel model = this.getElementModel();
        ElementView view = this.getElementView();
        Rect viewRect = view.getViewRect();
        model.add((Element)ship);
        model.moveTo((Element)ship, viewRect.getX() + viewRect.getWidth() / 4.0, viewRect.getY() + viewRect.getHeight() / 2.0);
        MoveActor actor = ship.getMoveActor();
        System.err.println(" -> Reinc: Ship-Actor = " + actor);
        if (actor != null) {
            this.addActor((Actor)actor);
        }
        if ((cp = this.getCockpit()) != null) {
            cp.setActive(true);
        }
    }

    protected void performGameOver() throws Exception {
        View gameoverView = this.getGameOverView();
        if (gameoverView != null) {
            this.surface.addView(gameoverView);
        }
        long gameExitDelay = 5000L;
        this.getTimer().addActor(gameExitDelay, (Actor)new GameExitActor());
    }

    protected void performGameExit() throws Exception {
        ((DefaultEngine)this.engine).stop();
    }

    @Override
    public ElementView getElementView() {
        return this.elementView;
    }

    protected void setElementView(ElementView view) {
        this.elementView = view;
    }

    @Override
    public double getScrollSpeedX() {
        return this.scrollSpeedX;
    }

    @Override
    public double getScrollSpeedY() {
        return this.scrollSpeedY;
    }

    @Override
    public void getScrollSpeed(Speed2D s) {
        s.setSpeed(this.scrollSpeedX, this.scrollSpeedY);
    }

    @Override
    public void setScrollSpeedX(double d) {
        if (this.scrollSpeedX == d) {
            return;
        }
        this.scrollSpeedX = d;
        this.fireScrollSpeedChanged(this.scrollSpeedX, this.scrollSpeedY);
    }

    @Override
    public void setScrollSpeedY(double d) {
        if (this.scrollSpeedY == d) {
            return;
        }
        this.scrollSpeedY = d;
        this.fireScrollSpeedChanged(this.scrollSpeedX, this.scrollSpeedY);
    }

    @Override
    public void setScrollSpeed(Speed2D s) {
        double sx = s.getSpeedX();
        double sy = s.getSpeedY();
        if (this.scrollSpeedX == sx && this.scrollSpeedY == sy) {
            return;
        }
        this.scrollSpeedX = sx;
        this.scrollSpeedY = sy;
        this.fireScrollSpeedChanged(this.scrollSpeedX, this.scrollSpeedY);
    }

    @Override
    public CollisionGroup getEnemyCollisionGroup() {
        return this.enemyCollisionGroup;
    }

    @Override
    public CollisionGroup getPlayerBulletCollisionGroup() {
        return this.playerBulletCollisionGroup;
    }

    @Override
    public CollisionGroup getPlayerShipCollisionGroup() {
        return this.playerShipCollisionGroup;
    }

    protected void setEnemyCollisionGroup(CollisionGroup group) {
        this.enemyCollisionGroup = group;
    }

    protected void setPlayerBulletCollisionGroup(CollisionGroup group) {
        this.playerBulletCollisionGroup = group;
    }

    protected void setPlayerShipCollisionGroup(CollisionGroup group) {
        this.playerShipCollisionGroup = group;
    }

    @Override
    public int getBulletCount() {
        return this.bullets.size();
    }

    @Override
    public Iterator getBullets() {
        return this.bullets.iterator();
    }

    protected DefaultSurfaceRumbler getSurfaceRumbler() {
        return this.surfaceRumbler;
    }

    protected void setSurfaceRumbler(DefaultSurfaceRumbler surfaceRumbler) {
        this.surfaceRumbler = surfaceRumbler;
    }

    public View getGameOverView() {
        return this.gameOverView;
    }

    public void setGameOverView(View gameOverView) {
        this.gameOverView = gameOverView;
    }

    @Override
    public void fireLaser(LaserGun laserGun, long ms) {
        int direction = laserGun.getDirection();
        switch (direction) {
            case 1: {
                this.fireLaser_Right(laserGun, ms);
                return;
            }
            case 2: {
                this.fireLaser_Up(laserGun, ms);
                return;
            }
        }
    }

    private void fireLaser_Right(LaserGun laserGun, long ms) {
        Element best = null;
        double bestX = 0.0;
        CollisionGroup group = laserGun.getCollisionGroup();
        Laser laser = laserGun.getLaser();
        Iterator i = laser.getCollisions();
        while (i.hasNext()) {
            Element el;
            Rect r = (Rect)i.next();
            if (!(r instanceof Element) || !group.isCollision((Element)laser, el = (Element)r)) continue;
            CollisionBounds cb = el.getCollisionBounds();
            if (best != null && !(el.getX() < bestX)) continue;
            if (cb != null) {
                double elX = el.getX();
                Rectangle rect = new Rectangle((int)(laser.getX() - elX), (int)(laser.getY() - el.getY()), (int)laser.getWidth(), (int)laser.getHeight());
                Rectangle dest = new Rectangle();
                cb.intersect(rect, dest);
                if (dest.isEmpty()) continue;
                best = el;
                bestX = elX + (double)dest.x;
                continue;
            }
            best = el;
            bestX = el.getX();
        }
        if (best == null) {
            laser.setEndXY((int)(laser.getX() + laser.getWidth()), (int)laser.getY());
        } else {
            laser.setEndXY((int)bestX, (int)laser.getY());
            try {
                this.handlePlayerLaserCollision(laser, best, bestX, laser.getY(), ms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireLaser_Up(LaserGun laserGun, long ms) {
        Element best = null;
        double bestY = 0.0;
        CollisionGroup group = laserGun.getCollisionGroup();
        Laser laser = laserGun.getLaser();
        Iterator i = laser.getCollisions();
        while (i.hasNext()) {
            Element el;
            Rect r = (Rect)i.next();
            if (!(r instanceof Element) || !group.isCollision((Element)laser, el = (Element)r)) continue;
            CollisionBounds cb = el.getCollisionBounds();
            if (best != null && !(el.getY() > bestY)) continue;
            if (cb != null) {
                double elY = el.getY();
                Rectangle rect = new Rectangle((int)(laser.getX() - el.getX()), (int)(laser.getY() - elY), (int)laser.getWidth(), (int)laser.getHeight());
                Rectangle dest = new Rectangle();
                cb.intersect(rect, dest);
                if (dest.isEmpty()) continue;
                best = el;
                bestY = elY + (double)dest.y + (double)dest.height;
                continue;
            }
            best = el;
            bestY = el.getY() + el.getHeight();
        }
        if (best == null) {
            laser.setEndXY((int)laser.getX(), (int)laser.getY());
        } else {
            laser.setEndXY((int)laser.getX(), (int)bestY);
            try {
                this.handlePlayerLaserCollision(laser, best, laser.getX(), bestY, ms);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void handleEnemyShipEntered(Ship s) {
        MoveActor actor = s.getMoveActor();
        if (actor != null) {
            this.addActor((Actor)actor);
        }
        if (s == this.lastBoss) {
            this.setScrollSpeedX(0.0);
            this.setScrollSpeedY(0.0);
        }
    }

    protected void handleEnemyShipExited(Ship s) {
        MoveActor actor = s.getMoveActor();
        if (actor != null) {
            this.removeActor((Actor)actor);
        }
    }

    protected void handleGadgetEntered(Gadget g) {
        AnimationRenderer renderer = (AnimationRenderer)g.getRenderer();
        renderer.setElement((Element)g);
        this.addActor((Actor)renderer);
        MoveActor mover = new MoveActor((Element)g);
        this.addActor((Actor)mover);
        SpeedBehavior speed = new SpeedBehavior(mover);
        double s = 0.05 + Math.random() * 0.2;
        switch (this.orientation) {
            case 0: {
                speed.setSpeedX(s);
                break;
            }
            case 1: {
                speed.setSpeedX(-s);
                break;
            }
            case 2: {
                speed.setSpeedY(s);
                break;
            }
            case 3: {
                speed.setSpeedY(-s);
            }
        }
        mover.addAction((Action)speed);
    }

    protected void handleGadgetExited(Gadget g) {
        this.elementModel.remove((Element)g);
        AnimationRenderer renderer = (AnimationRenderer)g.getRenderer();
        renderer.setLoops(0);
        renderer.setAutoDispose(true);
    }

    protected void handleAsteroidEntered(Asteroid aster) {
        MoveActor actor = aster.getMoveActor();
        if (actor != null) {
            this.addActor((Actor)actor);
        }
    }

    protected void handleAsteroidExited(Asteroid aster) {
        MoveActor actor = aster.getMoveActor();
        if (actor != null) {
            this.removeActor((Actor)actor);
        }
        this.elementModel.remove((Element)aster);
    }

    public void dumpView(PrintStream out) {
        ArrayList elements = new ArrayList();
        this.elementView.getElements(elements);
        out.println("----------------- View-Elements: " + elements.size() + " ------------------");
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            out.println(" - " + i.next());
        }
        out.println("-------------------------------------------------");
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    protected void setTimer(Timer timer) {
        this.timer = timer;
    }

    protected void handleSensorEntered(Sensor s) {
    }

    protected void handleSensorExited(Sensor s) {
        if (s instanceof EndSensor) {
            this.handleEndReached();
        }
    }

    protected void handleEndReached() {
        this.setCompleted(true);
        throw new EndOfSceneException("End of level: " + this);
    }

    protected void handleAnimationEntered(AnimationElement el) {
        AnimationRenderer r = (AnimationRenderer)el.getRenderer();
        if (r != null) {
            this.addActor((Actor)r);
        }
    }

    protected void handleAnimationExited(AnimationElement el) {
        AnimationRenderer r = (AnimationRenderer)el.getRenderer();
        if (r != null) {
            this.removeActor((Actor)r);
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public Cockpit getCockpit() {
        return this.cockpit;
    }

    public void setCockpit(Cockpit cockpit) {
        this.cockpit = cockpit;
    }

    @Override
    public CollisionGroup getEnemyBulletCollisionGroup() {
        return this.enemyBulletCollisionGroup;
    }

    protected void setEnemyBulletCollisionGroup(CollisionGroup enemyBulletCollisionGroup) {
        this.enemyBulletCollisionGroup = enemyBulletCollisionGroup;
    }

    public void rumble(float intensity, int duration) {
        if (this.cockpit == null) {
            return;
        }
        Rumbler rumbler = this.cockpit.getRumbler();
        if (rumbler == null) {
            return;
        }
        Timer timer = this.getTimer();
        RumbleStopAction rumbleStopAction = new RumbleStopAction(rumbler);
        timer.put((long)duration, (Timer.TimeAction)rumbleStopAction);
        rumbler.rumble(intensity);
    }

    protected Ship getLastBoss() {
        return this.lastBoss;
    }

    protected void setLastBoss(Ship lastBoss) {
        this.lastBoss = lastBoss;
    }

    @Override
    public void addScrollSpeedListener(SpeedListener l) {
        if (l != null) {
            this.scrollListeners.add(l);
        }
    }

    @Override
    public void removeScrollSpeedListener(SpeedListener l) {
        this.scrollListeners.remove(l);
    }

    protected void fireScrollSpeedChanged(double sx, double sy) {
        int num = this.scrollListeners.size();
        for (int c = 0; c < num; ++c) {
            ((SpeedListener)this.scrollListeners.get(c)).speedChanged(sx, sy);
        }
    }

    public double getScaleFactorX() {
        return this.scaleFactorX;
    }

    protected void setScaleFactorX(double scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
    }

    protected double getScaleFactorY() {
        return this.scaleFactorY;
    }

    public void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = scaleFactorY;
    }

    protected void computeScaleFactor() {
        double scaleX = 1.0;
        double scaleY = 1.0;
        DisplayMode srcMode = this.getSourceDisplayMode();
        DisplayMode dstMode = this.getTargetDisplayMode();
        if (srcMode != null && dstMode != null) {
            double srcWidth = srcMode.getWidth();
            double srcHeight = srcMode.getHeight();
            double dstWidth = dstMode.getWidth();
            double dstHeight = dstMode.getHeight();
            scaleX = dstWidth / srcWidth;
            scaleY = dstHeight / srcHeight;
        }
        this.setScaleFactorX(scaleX);
        this.setScaleFactorY(scaleY);
    }

    public DisplayMode getSourceDisplayMode() {
        return this.sourceDisplayMode;
    }

    protected void setSourceDisplayMode(DisplayMode sourceDisplayMode) {
        this.sourceDisplayMode = sourceDisplayMode;
        this.computeScaleFactor();
    }

    @Override
    public DisplayMode getTargetDisplayMode() {
        return this.targetDisplayMode;
    }

    @Override
    public void setTargetDisplayMode(DisplayMode targetDisplayMode) {
        this.targetDisplayMode = targetDisplayMode;
        this.computeScaleFactor();
    }

    @Override
    public Ship getPlayerShipAt(int i) {
        return (Ship)((Object)this.playerShips.get(i));
    }

    @Override
    public int getPlayerShipCount() {
        return this.playerShips.size();
    }

    public void addPlayerShip(Ship s) {
        if (s != null) {
            this.playerShips.add(s);
        }
    }

    public void removePlayerShip(Ship s) {
        this.playerShips.remove((Object)s);
    }

    protected class ShipRemoveActor
    extends Actor {
        private Ship ship;

        public ShipRemoveActor(Ship ship) {
            this.ship = ship;
        }

        public void invoke(long ms) {
            AbstractLevel.this.elementModel.remove((Element)this.ship);
            this.dispose();
        }

        public String toString() {
            return super.toString() + "[ship=" + (Object)((Object)this.ship) + "]";
        }
    }

    protected class GameExitActor
    extends Actor {
        public void invoke(long ms) {
            try {
                this.dispose();
                AbstractLevel.this.performGameExit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class GameOverActor
    extends Actor {
        public void invoke(long ms) {
            try {
                this.dispose();
                AbstractLevel.this.performGameOver();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected class LevelCompletedActor
    extends Actor {
        public void invoke(long ms) {
            this.dispose();
            AbstractLevel.this.handleEndReached();
        }
    }

    protected class ReincarnationActor
    extends Actor {
        private Ship ship;

        public ReincarnationActor(Ship ship) {
            this.ship = ship;
        }

        public void invoke(long ms) {
            try {
                this.dispose();
                AbstractLevel.this.performShipReincarnation(this.ship);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class ElementViewHandler
    implements ElementListener,
    SensorListener {
        public void elementAdded(Element e) {
            if (e instanceof Ship) {
                Ship s = (Ship)e;
                Commander commander = s.getCommander();
                if (commander == null) {
                    AbstractLevel.this.handleEnemyShipEntered(s);
                }
                return;
            }
            if (e instanceof Gadget) {
                AbstractLevel.this.handleGadgetEntered((Gadget)e);
                return;
            }
            if (e instanceof Asteroid) {
                AbstractLevel.this.handleAsteroidEntered((Asteroid)e);
                return;
            }
            if (e instanceof AnimationElement) {
                AbstractLevel.this.handleAnimationEntered((AnimationElement)e);
                return;
            }
        }

        public void elementRemoved(Element e) {
            if (e instanceof Bullet) {
                if (!(e instanceof Laser)) {
                    AbstractLevel.this.elementModel.remove(e);
                }
                return;
            }
            if (e instanceof Ship) {
                Ship s = (Ship)e;
                Commander commander = s.getCommander();
                if (commander == null) {
                    AbstractLevel.this.handleEnemyShipExited(s);
                } else {
                    System.out.println("TODO: handle PLAYER-SHIP exited: " + e);
                }
                return;
            }
            if (e instanceof Gadget) {
                AbstractLevel.this.handleGadgetExited((Gadget)e);
                return;
            }
            if (e instanceof Asteroid) {
                AbstractLevel.this.handleAsteroidExited((Asteroid)e);
                return;
            }
            if (e instanceof AnimationElement) {
                AbstractLevel.this.handleAnimationExited((AnimationElement)e);
                return;
            }
        }

        public void sensorAdded(Sensor s) {
            AbstractLevel.this.handleSensorEntered(s);
        }

        public void sensorRemoved(Sensor s) {
            AbstractLevel.this.handleSensorExited(s);
        }
    }

    public class PlayerShipCollisionActor
    extends CollisionActor {
        protected double energyDelta;

        public PlayerShipCollisionActor(Ship e, Element o, CollisionDetector cd) {
            super((Element)e, o, cd);
            this.energyDelta = 0.0;
        }

        protected void handleCollision(long ms) {
            try {
                AbstractLevel.this.handlePlayerShipCollision((Ship)this.e, this.o, ms, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dispose();
            }
        }

        protected void handleIntersection(long ms) {
        }
    }

    public class PlayerShipCollisionGroup
    extends AbstractCollisionGroup {
        public PlayerShipCollisionGroup(Scene scene, CollisionDetector cd, Set enemyGroups) {
            super(scene, cd, enemyGroups);
        }

        protected Actor createCollisionActor(Element e, Element o) {
            if (e instanceof Ship) {
                return new PlayerShipCollisionActor((Ship)e, o, super.getDetector());
            }
            if (e instanceof Gadget) {
                return new PlayerShipCollisionActor((Ship)e, o, super.getDetector());
            }
            return null;
        }
    }

    public class EnemyCollisionActor
    extends CollisionActor {
        public EnemyCollisionActor(Ship e, Element o, CollisionDetector cd) {
            super((Element)e, o, cd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleCollision(long ms) {
            try {
                AbstractLevel.this.handleEnemyShipCollision((Ship)this.e, this.o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.dispose();
            }
        }

        protected void handleIntersection(long ms) {
        }
    }

    public class EnemyCollisionGroup
    extends AbstractCollisionGroup {
        public EnemyCollisionGroup(Scene scene, CollisionDetector cd, Set enemyGroups) {
            super(scene, cd, enemyGroups);
        }

        protected Actor createCollisionActor(Element e, Element o) {
            if (e instanceof Ship) {
                return new EnemyCollisionActor((Ship)e, o, super.getDetector());
            }
            return null;
        }
    }

    public class EnemyBulletCollisionActor
    extends CollisionActor {
        public EnemyBulletCollisionActor(Bullet e, Element o, CollisionDetector cd) {
            super((Element)e, o, cd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleCollision(long ms) {
            try {
                AbstractLevel.this.handleEnemyBulletCollision((Bullet)this.e, this.o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.dispose();
            }
        }

        protected void handleIntersection(long ms) {
        }
    }

    public class EnemyBulletCollisionGroup
    extends AbstractCollisionGroup {
        public EnemyBulletCollisionGroup(Scene scene, CollisionDetector cd, Set enemyGroups) {
            super(scene, cd, enemyGroups);
        }

        protected Actor createCollisionActor(Element e, Element o) {
            if (e instanceof Bullet) {
                return new EnemyBulletCollisionActor((Bullet)e, o, super.getDetector());
            }
            return null;
        }
    }

    public class PlayerBulletCollisionActor
    extends CollisionActor {
        public PlayerBulletCollisionActor(Bullet e, Element o, CollisionDetector cd) {
            super((Element)e, o, cd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleCollision(long ms) {
            try {
                AbstractLevel.this.handlePlayerBulletCollision((Bullet)this.e, this.o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.dispose();
            }
        }

        protected void handleIntersection(long ms) {
        }
    }

    public class PlayerBulletCollisionGroup
    extends AbstractCollisionGroup {
        public PlayerBulletCollisionGroup(Scene scene, CollisionDetector cd, Set enemyGroups) {
            super(scene, cd, enemyGroups);
        }

        protected Actor createCollisionActor(Element e, Element o) {
            if (e instanceof Emp) {
                try {
                    AbstractLevel.this.handlePlayerEmpCollision((Emp)e, o);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }
            if (e instanceof Bullet) {
                return new PlayerBulletCollisionActor((Bullet)e, o, super.getDetector());
            }
            return null;
        }
    }
}

