/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.DefaultGun;

public abstract class AbstractWeaponType
implements WeaponType {
    protected static final int WEAPON_ID_BASE = 100000;
    private int id;
    private String title;
    private int preferredWeaponSlotIndex = 0;
    private int preferredWeaponSetIndex = 0;
    private boolean enemyWeaponType;

    public AbstractWeaponType(int id) {
        this.id = id;
        this.title = this.getClass().getName();
        int x = this.title.lastIndexOf(".");
        if (x >= 0) {
            this.title = this.title.substring(x + 1);
        }
        if ((x = this.title.lastIndexOf("$")) >= 0) {
            this.title = this.title.substring(x + 1);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean installWeapon(Ship ship, Weapon weapon) {
        WeaponSlot slot = this.chooseWeaponSlot(ship);
        if (slot == null) {
            throw new RuntimeException("OOPS: weaponSlot==null");
        }
        WeaponSet wset = this.chooseWeaponSet(ship);
        if (wset == null) {
            throw new RuntimeException("OOPS: weaponSet==null");
        }
        this.setupWeaponSlot(slot, weapon);
        this.setupWeaponSet(wset, weapon);
        return true;
    }

    protected WeaponSlot chooseWeaponSlot(Ship ship) {
        int slots = ship.getWeaponSlotCount();
        if (slots > 0) {
            int i;
            int n = i = this.preferredWeaponSlotIndex < slots ? this.preferredWeaponSlotIndex : 0;
            if (i < 0) {
                i = 0;
            }
            return ship.getWeaponSlotAt(i);
        }
        return null;
    }

    protected WeaponSet chooseWeaponSet(Ship ship) {
        int sets = ship.getWeaponSetCount();
        if (sets > 0) {
            int i;
            int n = i = this.preferredWeaponSetIndex < sets ? this.preferredWeaponSetIndex : 0;
            if (i < 0) {
                i = 0;
            }
            return ship.getWeaponSetAt(i);
        }
        return null;
    }

    protected void setupWeaponSlot(WeaponSlot slot, Weapon weapon) {
        weapon.setSlot(slot);
    }

    protected void setupWeaponSet(WeaponSet wset, Weapon weapon) {
        wset.addWeapon(weapon);
        wset.setDefaultWeapon(weapon);
    }

    public int getPreferredWeaponSetIndex() {
        return this.preferredWeaponSetIndex;
    }

    public void setPreferredWeaponSetIndex(int preferredWeaponSetIndex) {
        this.preferredWeaponSetIndex = preferredWeaponSetIndex;
    }

    public int getPreferredWeaponSlotIndex() {
        return this.preferredWeaponSlotIndex;
    }

    public void setPreferredWeaponSlotIndex(int preferredWeaponSlotIndex) {
        this.preferredWeaponSlotIndex = preferredWeaponSlotIndex;
    }

    @Override
    public boolean isEnemyWeaponType() {
        return this.enemyWeaponType;
    }

    protected void setEnemyWeaponType(boolean enemyWeaponType) {
        this.enemyWeaponType = enemyWeaponType;
    }

    protected void setupDefaultGunOrientation(Ship ship, DefaultGun gun, double speed) {
        double speedRight = 0.0;
        this.setupDefaultGunOrientation(ship, gun, speed, speedRight);
    }

    protected void setupDefaultGunOrientation(Ship ship, DefaultGun gun, double speed, double speedSide) {
        BulletType bulletType = (BulletType)gun.getBulletElementType();
        switch (ship.getOrientation()) {
            case 0: {
                gun.setBulletSpeedX(-speed);
                gun.setBulletSpeedY(speedSide);
                gun.setBulletStartX(-bulletType.getElementWidth());
                gun.setBulletStartY(-bulletType.getElementHeight() / 2.0);
                break;
            }
            case 1: {
                gun.setBulletSpeedX(speed);
                gun.setBulletSpeedY(speedSide);
                gun.setBulletStartX(0.0);
                gun.setBulletStartY(-bulletType.getElementHeight() / 2.0);
                break;
            }
            case 2: {
                gun.setBulletSpeedX(speedSide);
                gun.setBulletSpeedY(-speed);
                gun.setBulletStartX(-bulletType.getElementWidth() / 2.0);
                gun.setBulletStartY(-bulletType.getElementHeight());
                break;
            }
            case 3: {
                gun.setBulletSpeedX(speedSide);
                gun.setBulletSpeedY(speed);
                gun.setBulletStartX(-bulletType.getElementWidth() / 2.0);
                gun.setBulletStartY(0.0);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }
}

