/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.Timer;
import com.spacekiller.spacekiller.BossExplosionTask;
import com.spacekiller.spacekiller.DefaultExplosionType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Clip;

public class BossExplosionType
extends DefaultExplosionType {
    private List tasks = new ArrayList();
    private int counter;

    public BossExplosionType(AnimationElementType animationType, Clip audioClip, long shipRemoveDelay) {
        super(animationType, audioClip, shipRemoveDelay);
    }

    @Override
    public void performExplosion(Level level, Ship ship, Actor shipRemoveActor) throws Exception {
        super.performExplosion(level, ship, shipRemoveActor);
        Timer timer = level.getTimer();
        double mx = ship.getX() + ship.getWidth() / 2.0;
        double my = ship.getY() + ship.getHeight() / 2.0;
        for (BossExplosionTask task : this.tasks) {
            Animation ani = task.animationElementType.getAnimation();
            double x = mx + task.x - (double)(ani.getWidth() / 2);
            double y = my + task.y - (double)(ani.getHeight() / 2);
            Element el = task.animationElementType.createElement((Object)("bossExplosion#" + this.counter++), x, y, 1.0, 1.0);
            timer.addActor(task.delay, (Actor)new BossExplosionActor(level, el));
        }
    }

    public void addExplosionTask(AnimationElementType explosionType, double x, double y, long delay) {
        this.tasks.add(new BossExplosionTask(explosionType, x, y, delay));
    }

    public void addExplosionTask(BossExplosionTask task) {
        if (task != null) {
            this.tasks.add(task);
        }
    }

    protected static class BossExplosionActor
    extends Actor {
        public Level level;
        public Element element;

        public BossExplosionActor(Level level, Element element) {
            this.level = level;
            this.element = element;
        }

        public void invoke(long ms) {
            AnimationRenderer renderer = (AnimationRenderer)this.element.getRenderer();
            ElementModel model = this.level.getElementModel();
            if (model != null) {
                model.add(this.element);
                this.level.addActor((Actor)renderer);
            }
            this.dispose();
        }
    }
}

