/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.InputMap;
import com.spacekiller.game2d.MultiRumbler;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.ShipStatusView;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import java.util.HashSet;

public class Cockpit
extends Actor {
    public static final String INPUT_PLAYER1_MOVE_X = "input.player1.moveX";
    public static final String INPUT_PLAYER1_MOVE_Y = "input.player1.moveY";
    public static final String INPUT_PLAYER1_WEAPON1 = "input.player1.weapon1";
    public static final String INPUT_PLAYER1_WEAPON2 = "input.player1.weapon2";
    public static final String INPUT_PLAYER1_WEAPON3 = "input.player1.weapon3";
    public static final String INPUT_PLAYER1_SWITCH_WEAPON = "input.player1.switchWeapon";
    public static final String INPUT_PLAYER1_RUMBLER = "input.player1.rumbler";
    private Level level;
    private ElementModel model;
    private Rect viewRect;
    private Commander commander;
    private Ship ship;
    private SpeedBehavior speedBehavior;
    private long ms = 0L;
    private boolean active = true;
    private WeaponSet[] weaponSets;
    private InputMap inputMap;
    private InputController[] pollers;
    private InputAxis axisX;
    private InputAxis axisY;
    private boolean relativeXY;
    private boolean normalizedXY;
    private InputAxis axisSwitchWeapon;
    private InputButton[] weaponButtons = new InputButton[0];
    private float lastSwitchWeapon = 0.0f;
    private boolean relativeWheel;
    private double maxSpeedX = 2.0;
    private double maxSpeedY = 2.0;
    private Rumbler rumbler;
    private ShipStatusView shipStatusView;

    public Ship getShip() {
        return this.ship;
    }

    public void setShip(Ship ship) {
        this.ship = ship;
        if (ship != null) {
            this.initializeWeapons();
        }
    }

    protected void initializeWeapons() {
        int count = this.ship.getWeaponSetCount();
        System.out.println("Number of weapon-sets: " + count);
        WeaponSet[] ws = new WeaponSet[count];
        int buttonIndex = 0;
        for (int c = 0; c < count; ++c) {
            ws[c] = this.ship.getWeaponSetAt(c);
            ws[c].setButton(this.weaponButtons[buttonIndex]);
            if (++buttonIndex < this.weaponButtons.length) continue;
            buttonIndex = 0;
        }
        this.weaponSets = ws;
    }

    public void invoke(long newMs) {
        if (this.ms > 0L) {
            try {
                if (!this.active) {
                    return;
                }
                for (int c = 0; c < this.pollers.length; ++c) {
                    this.pollers[c].poll();
                }
                if (this.ship.getModel() != null) {
                    double my;
                    double mx;
                    double sx = this.speedBehavior.getSpeedX();
                    double sy = this.speedBehavior.getSpeedY();
                    if (this.normalizedXY) {
                        double factor = 1.0;
                        double mx2 = (double)this.axisX.getValue() * factor + this.level.getScrollSpeedX();
                        double my2 = (double)this.axisY.getValue() * factor + this.level.getScrollSpeedY();
                        sx = (sx * 3.0 + mx2) / 4.0;
                        sy = (sy * 3.0 + my2) / 4.0;
                    } else if (this.relativeXY) {
                        mx = (double)(this.axisX.getValue() / (float)this.ms) + this.level.getScrollSpeedX();
                        my = (double)(this.axisY.getValue() / (float)this.ms) + this.level.getScrollSpeedY();
                        sx = (sx * 3.0 + mx) / 4.0;
                        sy = (sy * 3.0 + my) / 4.0;
                    } else {
                        mx = this.viewRect.getX() + (double)this.axisX.getValue() - this.ship.getX();
                        my = this.viewRect.getY() + (double)this.axisY.getValue() - this.ship.getY();
                        sx = (sx + mx * 0.01) / 2.0;
                        sy = (sy + my * 0.01) / 2.0;
                    }
                    if (sx > this.maxSpeedX) {
                        sx = this.maxSpeedX;
                    }
                    if (sx < -this.maxSpeedX) {
                        sx = -this.maxSpeedX;
                    }
                    if (sy > this.maxSpeedY) {
                        sy = this.maxSpeedY;
                    }
                    if (sy < -this.maxSpeedY) {
                        sy = -this.maxSpeedY;
                    }
                    if (!this.viewRect.contains((Rect)this.ship)) {
                        double shipX = this.ship.getX();
                        double shipY = this.ship.getY();
                        double shipW = this.ship.getWidth();
                        double shipH = this.ship.getHeight();
                        double viewX = this.viewRect.getX();
                        double viewY = this.viewRect.getY();
                        double viewW = this.viewRect.getWidth();
                        double viewH = this.viewRect.getHeight();
                        if (shipX < viewX) {
                            this.model.moveTo((Element)this.ship, viewX, shipY);
                            if (sx < 0.0) {
                                sx = this.level.getScrollSpeedX();
                            }
                        }
                        if (shipX + shipW > viewX + viewW) {
                            this.model.moveTo((Element)this.ship, viewX + viewW - shipW, shipY);
                            if (sx > 0.0) {
                                sx = this.level.getScrollSpeedX();
                            }
                        }
                        if (shipY < viewY) {
                            this.model.moveTo((Element)this.ship, shipX, viewY);
                            if (sy < 0.0) {
                                sy = this.level.getScrollSpeedY();
                            }
                        }
                        if (shipY + shipH > viewY + viewH) {
                            this.model.moveTo((Element)this.ship, shipX, viewY + viewH - shipH);
                            if (sy > 0.0) {
                                sy = this.level.getScrollSpeedY();
                            }
                        }
                    }
                    this.speedBehavior.setSpeedX(sx);
                    this.speedBehavior.setSpeedY(sy);
                    if (this.axisSwitchWeapon != null) {
                        if (this.relativeWheel) {
                            float f = this.axisSwitchWeapon.getValue();
                            if (f != 0.0f) {
                                this.switchWeapon(f);
                            }
                        } else {
                            float f = this.axisSwitchWeapon.getValue();
                            if (f != this.lastSwitchWeapon) {
                                this.switchWeapon(f - this.lastSwitchWeapon);
                                this.lastSwitchWeapon = f;
                            }
                        }
                    }
                    for (int i = 0; i < this.weaponSets.length; ++i) {
                        this.weaponSets[i].poll();
                    }
                }
                this.refreshWeaponInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ms = newMs;
    }

    public Commander getCommander() {
        return this.commander;
    }

    public void setCommander(Commander commander) {
        this.commander = commander;
    }

    public SpeedBehavior getSpeedBehavior() {
        return this.speedBehavior;
    }

    public void setSpeedBehavior(SpeedBehavior behavior) {
        this.speedBehavior = behavior;
    }

    public Rect getViewRect() {
        return this.viewRect;
    }

    public void setViewRect(Rect rect) {
        this.viewRect = rect;
    }

    public int getWeaponButtonCount() {
        return this.weaponButtons.length;
    }

    public InputButton getWeaponButtonAt(int i) {
        return this.weaponButtons[i];
    }

    public InputAxis getAxisX() {
        return this.axisX;
    }

    public InputAxis getAxisY() {
        return this.axisY;
    }

    public void setAxisX(InputAxis axis) {
        this.axisX = axis;
        if (axis != null) {
            this.relativeXY = axis.isRelative();
            this.normalizedXY = axis.isNormalized();
        }
    }

    public void setAxisY(InputAxis axis) {
        this.axisY = axis;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public void setInputMap(InputMap map) {
        this.inputMap = map;
    }

    public void setup() throws Exception {
        if (this.inputMap == null) {
            throw new NullPointerException("inputMap==null");
        }
        HashSet<InputAxis> allAxes = new HashSet<InputAxis>();
        InputAxis[] axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_MOVE_X);
        if (axes == null || axes.length < 1) {
            throw new Exception("Missing InputAxis for key: input.player1.moveX");
        }
        this.setAxisX(axes[0]);
        allAxes.add(axes[0]);
        axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_MOVE_Y);
        if (axes == null || axes.length < 1) {
            throw new Exception("Missing InputAxis for key: input.player1.moveY");
        }
        this.setAxisY(axes[0]);
        allAxes.add(axes[0]);
        axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_SWITCH_WEAPON);
        if (axes != null && axes.length >= 0) {
            this.setAxisSwitchWeapon(axes[0]);
            allAxes.add(axes[0]);
        }
        if ((axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_WEAPON1)) != null && axes.length >= 0 && axes[0] != null) {
            this.addWeaponButton((InputButton)axes[0]);
            allAxes.add(axes[0]);
        }
        if ((axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_WEAPON2)) != null && axes.length >= 0 && axes[0] != null) {
            this.addWeaponButton((InputButton)axes[0]);
            allAxes.add(axes[0]);
        }
        if ((axes = this.inputMap.getAxes((Object)INPUT_PLAYER1_WEAPON3)) != null && axes.length >= 0 && axes[0] != null) {
            this.addWeaponButton((InputButton)axes[0]);
            allAxes.add(axes[0]);
        }
        HashSet<InputController> poll = new HashSet<InputController>();
        for (InputAxis axis : allAxes) {
            if (!axis.isPolling()) continue;
            poll.add(axis.getController());
        }
        int pollCount = poll.size();
        InputController[] pollers = new InputController[pollCount];
        this.setPollers(poll.toArray(pollers));
        Rumbler[] rumblers = this.inputMap.getRumblers((Object)INPUT_PLAYER1_RUMBLER);
        if (rumblers != null && rumblers.length > 0) {
            if (rumblers.length == 1) {
                this.setRumbler(rumblers[0]);
            } else {
                this.setRumbler((Rumbler)new MultiRumbler(rumblers));
            }
        }
    }

    public InputAxis getAxisSwitchWeapon() {
        return this.axisSwitchWeapon;
    }

    public void setAxisSwitchWeapon(InputAxis axis) {
        this.axisSwitchWeapon = axis;
        this.lastSwitchWeapon = axis == null ? 0.0f : axis.getValue();
        this.relativeWheel = axis == null ? false : axis.isRelative();
    }

    protected InputController[] getPollers() {
        return this.pollers;
    }

    protected void setPollers(InputController[] controllers) {
        this.pollers = controllers;
    }

    protected void switchWeapon(float delta) {
        WeaponSet wset = this.weaponSets[0];
        if (delta > 0.0f) {
            wset.switchDefaultWeapon(1);
        } else {
            wset.switchDefaultWeapon(-1);
        }
    }

    protected void refreshWeaponInfo() {
        if (this.shipStatusView == null) {
            return;
        }
        WeaponSet wset = this.weaponSets[0];
        Weapon w = wset.getDefaultWeapon();
        String wInfo = null;
        if (w == null) {
            wInfo = "";
        } else {
            wInfo = String.valueOf(w.getWeaponType().getTitle());
            int num = w.getBulletCount();
            wInfo = wInfo + " [" + num + "]";
        }
        this.shipStatusView.setWeaponInfo(wInfo);
    }

    public void addWeaponButton(InputButton wb) {
        if (wb == null) {
            return;
        }
        System.out.println("add Weapon-Button: " + wb);
        int oldCount = this.weaponButtons.length;
        int newCount = oldCount + 1;
        InputButton[] newButtons = new InputButton[newCount];
        System.arraycopy(this.weaponButtons, 0, newButtons, 0, oldCount);
        newButtons[oldCount] = wb;
        this.weaponButtons = newButtons;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public double getMaxSpeedX() {
        return this.maxSpeedX;
    }

    public void setMaxSpeedX(double maxSpeedX) {
        this.maxSpeedX = maxSpeedX;
    }

    public double getMaxSpeedY() {
        return this.maxSpeedY;
    }

    public void setMaxSpeedY(double maxSpeedY) {
        this.maxSpeedY = maxSpeedY;
    }

    public Rumbler getRumbler() {
        return this.rumbler;
    }

    public void setRumbler(Rumbler rumbler) {
        this.rumbler = rumbler;
    }

    public ElementModel getModel() {
        return this.model;
    }

    public void setModel(ElementModel model) {
        this.model = model;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ShipStatusView getShipStatusView() {
        return this.shipStatusView;
    }

    public void setShipStatusView(ShipStatusView shipStatusView) {
        this.shipStatusView = shipStatusView;
    }
}

