/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.spacekiller.AbstractLevel;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import javax.sound.sampled.Clip;

public class DefaultExplosionType
implements ExplosionType {
    private AnimationElementType animationType;
    private Clip audioClip;
    private long shipRemoveDelay;
    private int counter;

    public DefaultExplosionType(AnimationElementType animationType, Clip audioClip, long shipRemoveDelay) {
        this.setAnimationType(animationType);
        this.setAudioClip(audioClip);
        this.setShipRemoveDelay(shipRemoveDelay);
    }

    @Override
    public void performExplosion(Level level, Ship ship, Actor shipRemoveActor) throws Exception {
        if (this.audioClip != null && level.isEffectEnabled(AbstractLevel.EFFECT_AUDIO_EXPLOSIONS)) {
            this.audioClip.start();
        }
        if (this.animationType != null) {
            ElementModel model;
            Animation ani = this.animationType.getAnimation();
            double aniX = ship.getX() + ship.getWidth() / 2.0 - (double)(ani.getWidth() / 2);
            double aniY = ship.getY() + ship.getHeight() / 2.0 - (double)(ani.getHeight() / 2);
            Element aniElement = this.animationType.createElement((Object)("shipExplosion#" + this.counter++), aniX, aniY, 1.0, 1.0);
            if (aniElement != null && (model = level.getElementModel()) != null) {
                model.add(aniElement);
                level.addActor((Actor)((AnimationRenderer)aniElement.getRenderer()));
            }
        }
        if (this.shipRemoveDelay >= 0L) {
            level.getTimer().addActor(this.shipRemoveDelay, shipRemoveActor);
        }
    }

    public AnimationElementType getAnimationType() {
        return this.animationType;
    }

    public void setAnimationType(AnimationElementType animationType) {
        this.animationType = animationType;
    }

    public Clip getAudioClip() {
        return this.audioClip;
    }

    public void setAudioClip(Clip audioClip) {
        this.audioClip = audioClip;
    }

    public long getShipRemoveDelay() {
        return this.shipRemoveDelay;
    }

    public void setShipRemoveDelay(long shipRemoveDelay) {
        this.shipRemoveDelay = shipRemoveDelay;
    }
}

