/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementListener;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.ElementViewScrollActor;
import com.spacekiller.game2d.ImageView;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.MultiActor;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Sensor;
import com.spacekiller.game2d.SensorListener;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.TileLoop;
import com.spacekiller.game2d.TileModel;
import com.spacekiller.game2d.TileView;
import com.spacekiller.game2d.TileViewScrollActor;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioPlayer;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.spacekiller.AbstractLevel;
import com.spacekiller.spacekiller.Asteroid;
import com.spacekiller.spacekiller.AsteroidType;
import com.spacekiller.spacekiller.EndSensor;
import com.spacekiller.spacekiller.Gadget;
import com.spacekiller.spacekiller.GadgetType;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.SpeedListener;
import com.spacekiller.spacekiller.space.ImageSpaceRenderer;
import com.spacekiller.spacekiller.space.PointSpaceRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultLevel
extends AbstractLevel {
    private String modelResource;

    public DefaultLevel() {
        this.setDesigner("Anonymous");
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        ElementModel elementModel = this.createElementModel();
        if (elementModel == null) {
            throw new NullPointerException("ElementModel");
        }
        this.setElementModel(elementModel);
        ElementView elementView = this.createElementView(elementModel, surface);
        elementView.setX(0);
        elementView.setY(0);
        elementView.setWidth(surfaceW);
        elementView.setHeight(surfaceH);
        this.setElementView(elementView);
        this.initializeElements();
        this.initializeEndSensor();
        Iterator i = this.getElementModel().getElements();
        ArrayList<Element> ships = new ArrayList<Element>();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!(el instanceof Ship)) continue;
            ships.add(el);
        }
        System.out.println("Number of ships: " + ships.size());
        this.initializeShipGadgets(ships);
        this.initializeLastBoss(ships);
        surface.removeAllViews();
        View backView = this.createBackgroundView();
        if (backView != null) {
            surface.addView(backView);
        }
        ArrayList<ElementViewScrollActor> multiActorList = new ArrayList<ElementViewScrollActor>();
        MultiActor staticActor = new MultiActor(multiActorList);
        this.addActor((Actor)staticActor);
        this.initializeSpaceViews(multiActorList);
        AbstractLevel.ElementViewHandler evh = new AbstractLevel.ElementViewHandler();
        elementView.addElementListener((ElementListener)evh);
        elementView.addSensorListener((SensorListener)evh);
        surface.addView((View)elementView);
        ElementViewScrollActor scrollActor = new ElementViewScrollActor(elementModel, elementView, this.getScrollSpeedX(), this.getScrollSpeedY());
        multiActorList.add(0, scrollActor);
        this.addScrollSpeedListener(new ElementViewScrollHandler(scrollActor, 1.0));
        AudioPlayer player = this.getAudioPlayer();
        if (player != null && this.isAudioEnabled() && this.isEffectEnabled(EFFECT_AUDIO_MUSIC)) {
            AudioBufferPool audioBufferPool = this.getAudioBufferPool();
            AudioSequence audioSeq = this.createAudioSequence(audioBufferPool);
            boolean running = player.isRunning();
            player.clear();
            if (audioSeq != null) {
                player.add(audioSeq);
            }
            if (running) {
                player.skip();
            } else {
                player.start();
            }
        }
    }

    protected final Image makeBackgroundImage(Image image, int surfaceW, int surfaceH) throws Exception {
        ColorModel cm = ImageToolkit.getInstance().getColorModel(image);
        System.out.println("ColorModel: " + cm);
        WritableRaster wr = cm.createCompatibleWritableRaster(surfaceW, surfaceH);
        BufferedImage test = new BufferedImage(cm, wr, true, null);
        System.out.println("Buffer=" + test);
        Graphics g = test.getGraphics();
        g.drawImage(image, 0, 0, surfaceW, surfaceH, 0, 0, image.getWidth(null), image.getHeight(null), null);
        for (int col = 1; col < 30; ++col) {
            g.setColor(new Color(1.0f, 1.0f, 1.0f, (float)col / 100.0f));
            for (int c = 0; c < 100; ++c) {
                g.fillRect((int)(Math.random() * (double)surfaceW), (int)(Math.random() * (double)surfaceH), 1, 1);
            }
        }
        Image scaled = this.getScaledImage(test, surfaceW, surfaceH, 2);
        return scaled;
    }

    Image testSpriteImage(Image gifImage) throws Exception {
        int width = gifImage.getWidth(null);
        int height = gifImage.getHeight(null);
        ColorModel cm = ImageToolkit.getInstance().getColorModel(gifImage);
        System.out.println("ColorModel: " + cm);
        IndexColorModel icm = (IndexColorModel)cm;
        int trans = icm.getTransparentPixel();
        System.out.println("Transparent pixel: " + trans);
        WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
        int[] pix = new int[]{trans};
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.setPixel(x, y, pix);
            }
        }
        BufferedImage test = new BufferedImage(cm, wr, false, null);
        Graphics g = test.getGraphics();
        g.drawImage(gifImage, 0, 0, null);
        g.setColor(Color.red);
        g.fillRect(50, 50, 30, 30);
        g.dispose();
        Image scaled = this.getScaledImage(test, width, height, 2);
        System.out.println("Target=" + scaled);
        return scaled;
    }

    protected Image createStarImage3x3(Color col1, Color col2) throws Exception {
        BufferedImage buf = new BufferedImage(3, 3, 2);
        Graphics g = buf.getGraphics();
        g.setColor(col1);
        g.fillRect(1, 1, 1, 1);
        g.setColor(col2);
        g.fillRect(1, 0, 1, 1);
        g.fillRect(1, 2, 1, 1);
        g.fillRect(0, 1, 1, 1);
        g.fillRect(2, 1, 1, 1);
        g.dispose();
        return this.getScaledImage(buf, 3, 3, 2);
    }

    protected Image createStarImage5x5(Color col1, Color col2, Color col3, Color col4) throws Exception {
        BufferedImage buf = new BufferedImage(5, 5, 2);
        Graphics g = buf.getGraphics();
        g.setColor(col1);
        g.fillRect(2, 2, 1, 1);
        g.setColor(col2);
        g.fillRect(2, 1, 1, 1);
        g.fillRect(2, 3, 1, 1);
        g.fillRect(1, 2, 1, 1);
        g.fillRect(3, 2, 1, 1);
        g.setColor(col3);
        g.fillRect(1, 1, 1, 1);
        g.fillRect(3, 1, 1, 1);
        g.fillRect(1, 3, 1, 1);
        g.fillRect(3, 3, 1, 1);
        g.setColor(col4);
        g.fillRect(2, 0, 1, 1);
        g.fillRect(2, 4, 1, 1);
        g.fillRect(0, 2, 1, 1);
        g.fillRect(4, 2, 1, 1);
        g.dispose();
        return this.getScaledImage(buf, 5, 5, 2);
    }

    protected AudioSequence createAudioSequence(AudioBufferPool pool) throws Exception {
        return null;
    }

    protected Image createBackgroundImage() throws Exception {
        return this.getRegistry().getImage("n63a_compcxc_full.jpg");
    }

    protected View createBackgroundView() throws Exception {
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        Image backImage = this.createBackgroundImage();
        System.out.println("BackImage=" + backImage);
        backImage = this.makeBackgroundImage(backImage, surfaceW, surfaceH);
        ImageView backView = new ImageView(surfaceW, surfaceH, backImage);
        return backView;
    }

    protected ElementModel createElementModel() throws Exception {
        URL url = this.getClass().getResource(this.modelResource);
        if (url == null) {
            throw new FileNotFoundException("Model resource not found: " + this.modelResource);
        }
        ElementModel model = this.readModel(url);
        double scaleFactorX = this.getScaleFactorX();
        double scaleFactorY = this.getScaleFactorY();
        System.out.println("Model scale factor: x=" + scaleFactorX + ", y=" + scaleFactorY);
        if (scaleFactorX > 1.0 || scaleFactorY > 1.0) {
            int newCols = model.getMapColumns();
            int newRows = model.getMapRows();
            double cellWidth = model.getMapCellWidth() * scaleFactorX;
            double cellHeight = model.getMapCellHeight() * scaleFactorY;
            model.resizeMap(newCols, newRows, cellWidth, cellHeight);
        }
        if (scaleFactorX != 1.0 || scaleFactorY != 1.0) {
            model.scaleElementPositions(scaleFactorX, scaleFactorY);
        }
        return model;
    }

    protected ElementView createElementView(ElementModel model, Surface surface) throws Exception {
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        double maxX = 0.0;
        double maxY = 0.0;
        Iterator i = model.getElements();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (el.getX() + el.getWidth() > maxX) {
                maxX = el.getX() + el.getWidth();
            }
            if (!(el.getY() + el.getHeight() > maxY)) continue;
            maxY = el.getY() + el.getHeight();
        }
        double x = 0.0;
        double y = 0.0;
        switch (this.orientation) {
            case 0: {
                x = maxX + (double)surfaceW;
                break;
            }
            case 2: {
                y = maxY + (double)surfaceH;
            }
        }
        ElementView elementView = (ElementView)this.elementModel.createView(x, y, (double)surfaceW, (double)surfaceH);
        return elementView;
    }

    protected void initializeElements() {
        System.gc();
        ElementModel model = this.getElementModel();
        Iterator i = model.getElements();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (el == null || this.initializeElement(el)) continue;
            System.out.println("Warning: Unsupported element: level=" + this + ", element=" + el);
        }
    }

    protected boolean initializeElement(Element el) {
        el.setCollisionGroup(this.getEnemyCollisionGroup());
        if (el instanceof Ship) {
            this.initializeShip((Ship)el);
            return true;
        }
        if (el instanceof Gadget) {
            this.initializeGadget((Gadget)el);
            return true;
        }
        if (el instanceof Asteroid) {
            this.initializeAsteroid((Asteroid)el);
            return true;
        }
        return el.getClass() == Element.class;
    }

    protected int getShipOrientation(Ship ship) {
        switch (this.getOrientation()) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    protected void initializeShip(Ship ship) {
        ship.setPower(ship.getMaxPower());
        ship.setShield(ship.getMaxShield());
        MoveActor moveActor = new MoveActor((Element)ship);
        ship.setMoveActor(moveActor);
        ElementType elType = ship.getType();
        if (elType != null && elType instanceof ShipType) {
            ShipType shipType = (ShipType)elType;
            shipType.setupBehavior(this, this.elementModel, ship, moveActor);
        }
    }

    protected void initializeGadget(Gadget gadget) {
    }

    protected void initializeAsteroid(Asteroid aster) {
        MoveActor moveActor = new MoveActor((Element)aster);
        aster.setMoveActor(moveActor);
        ElementType elType = aster.getType();
        if (elType == null) {
            return;
        }
        if (elType instanceof AsteroidType) {
            AsteroidType asterType = (AsteroidType)elType;
            asterType.setupBehavior(this, this.elementModel, aster, moveActor);
            return;
        }
    }

    protected void initializeEndSensor() {
        ElementModel model = this.getElementModel();
        double minX = 0.0;
        double maxX = -1.0;
        double minY = 0.0;
        double maxY = -1.0;
        Iterator i = model.getElements();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (el == null) continue;
            boolean include = false;
            if (el instanceof Ship) {
                include = true;
            }
            if (el instanceof Gadget) {
                include = true;
            }
            if (!include) continue;
            if (maxX < minX) {
                minX = el.getX();
                maxX = el.getX() + el.getWidth();
                minY = el.getY();
                maxY = el.getY() + el.getHeight();
                continue;
            }
            if (minX > el.getX()) {
                minX = el.getX();
            }
            if (minY > el.getY()) {
                minY = el.getY();
            }
            if (maxX < el.getX() + el.getWidth()) {
                maxX = el.getX() + el.getWidth();
            }
            if (!(maxY < el.getY() + el.getHeight())) continue;
            maxY = el.getY() + el.getHeight();
        }
        Rectangle2D bounds = model.getBounds();
        if (maxX < 0.0) {
            maxX = 0.0;
        }
        if (maxX + 1000.0 >= bounds.getMaxX()) {
            maxX = bounds.getMaxX() - 1000.0;
        }
        EndSensor endSensor = new EndSensor(maxX, 0.0, 1000.0, 1000.0);
        model.add((Sensor)endSensor);
    }

    protected void initializeLastBoss(List ships) throws Exception {
        Ship boss = null;
        int num = ships.size();
        for (int c = 0; c < num; ++c) {
            ShipType shipType;
            Ship ship = (Ship)((Object)ships.get(c));
            if (boss != null && ship.getX() < boss.getX() || !(shipType = ship.getShipType()).isBoss()) continue;
            boss = ship;
        }
        System.out.println("Last Boss: " + boss);
        this.setLastBoss(boss);
    }

    protected void initializeSpaceViews(List actorList) throws Exception {
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        int spaceLevels = 4;
        int starLevels = 5;
        double speedFactor = 0.0;
        double speedIncrement = 0.25 / (double)(spaceLevels + starLevels);
        for (int c = 0; c < spaceLevels; ++c) {
            int col = (c + 1) * 255 / (spaceLevels + 1);
            speedFactor += speedIncrement;
            Color starColor = new Color(col, col, col);
            int spaceTileWidth = 256;
            int spaceTileHeight = 256;
            int spaceCols = surfaceW / spaceTileWidth + 1;
            int spaceRows = surfaceW / spaceTileHeight + 1;
            TileLoop spaceModel = new TileLoop((double)spaceTileWidth, (double)spaceTileHeight, spaceCols, spaceRows);
            for (int sr = 0; sr < spaceRows; ++sr) {
                for (int sc = 0; sc < spaceCols; ++sc) {
                    int pc = 8;
                    int[] px = new int[pc];
                    int[] py = new int[pc];
                    for (int p = 0; p < pc; ++p) {
                        px[p] = (int)(Math.random() * 100000.0 % spaceModel.getTileWidth());
                        py[p] = (int)(Math.random() * 100000.0 % spaceModel.getTileHeight());
                    }
                    PointSpaceRenderer tile = new PointSpaceRenderer(px, py, starColor);
                    spaceModel.setTile(sc, sr, (Renderer)tile);
                }
            }
            TileView spaceView = (TileView)spaceModel.createView(0.0, 0.0, (double)surfaceW, (double)surfaceH);
            spaceView.setWidth(surfaceW);
            spaceView.setHeight(surfaceH);
            surface.addView((View)spaceView);
            double scrollX = 0.0;
            double scrollY = 0.0;
            TileViewScrollActor scrollActor = new TileViewScrollActor((TileModel)spaceModel, spaceView, scrollX, scrollY);
            actorList.add(scrollActor);
            TileViewScrollHandler handler = new TileViewScrollHandler(scrollActor, speedFactor);
            this.addScrollSpeedListener(handler);
            handler.speedChanged(this.getScrollSpeedX(), this.getScrollSpeedY());
        }
        speedIncrement = 0.003;
        TileModel[] starModels = new TileModel[starLevels];
        TileView[] starViews = new TileView[starLevels];
        for (int c = 0; c < starLevels; ++c) {
            TileView starView;
            int color = 150 + 100 * (c + 1) / starLevels;
            Image starImage3x3 = this.createStarImage3x3(new Color(color, color, color), new Color(color / 2, color / 2, color / 2));
            int spaceTileWidth = 256;
            int spaceTileHeight = 256;
            int spaceCols = surfaceW / spaceTileWidth + 1;
            int spaceRows = surfaceW / spaceTileHeight + 1;
            TileLoop starModel = new TileLoop((double)spaceTileWidth, (double)spaceTileHeight, spaceCols, spaceRows);
            starModels[c] = starModel;
            speedFactor += speedIncrement;
            for (int sr = 0; sr < spaceRows; ++sr) {
                for (int sc = 0; sc < spaceCols; ++sc) {
                    int pc = 1;
                    int[] px = new int[pc];
                    int[] py = new int[pc];
                    for (int p = 0; p < pc; ++p) {
                        px[p] = (int)(Math.random() * 100000.0 % starModel.getTileWidth());
                        py[p] = (int)(Math.random() * 100000.0 % starModel.getTileHeight());
                    }
                    ImageSpaceRenderer tile = new ImageSpaceRenderer(px, py, starImage3x3);
                    starModel.setTile(sc, sr, (Renderer)tile);
                }
            }
            starViews[c] = starView = (TileView)starModel.createView(0.0, 0.0, (double)surfaceW, (double)surfaceH);
            starView.setWidth(surfaceW);
            starView.setHeight(surfaceH);
            surface.addView((View)starView);
            double scrollX = 0.0;
            double scrollY = 0.0;
            TileViewScrollActor scrollActor = new TileViewScrollActor((TileModel)starModel, starView, scrollX, scrollY);
            actorList.add(scrollActor);
            TileViewScrollHandler handler = new TileViewScrollHandler(scrollActor, speedFactor);
            this.addScrollSpeedListener(handler);
            handler.speedChanged(this.getScrollSpeedX(), this.getScrollSpeedY());
        }
    }

    protected void initializeShipGadgets(List ships) throws Exception {
    }

    protected void installShipGadget(String gadgetTypeId, int count, List ships) throws Exception {
        GadgetType gadgetType = (GadgetType)this.getRegistry().getElementType(gadgetTypeId);
        if (gadgetType == null) {
            System.out.println("Warning: GadgetType not found: " + gadgetTypeId);
            return;
        }
        this.installShipGadget(gadgetType, count, ships);
    }

    protected void installShipGadget(GadgetType gadgetType, int count, List ships) throws Exception {
        int shipCount = ships.size();
        if (shipCount < 1) {
            return;
        }
        for (int c = 0; c < count; ++c) {
            int x = (int)(Math.random() * (double)shipCount);
            Ship ship = (Ship)((Object)ships.get(x));
            Gadget gadget = (Gadget)gadgetType.createElement("" + ship.getId() + "#gadget" + c, 0.0, 0.0, 1.0, 1.0);
            ship.addGadget(gadget);
        }
    }

    protected String getModelResource() {
        return this.modelResource;
    }

    protected void setModelResource(String modelResource) {
        this.modelResource = modelResource;
    }

    @Override
    public void setupShipOrientation(Ship ship) {
        ship.setOrientation(this.getShipOrientation(ship));
    }

    @Override
    public boolean isIntroLevel() {
        return false;
    }

    protected static class TileViewScrollHandler
    implements SpeedListener {
        private TileViewScrollActor actor;
        private double speedFactor;

        public TileViewScrollHandler(TileViewScrollActor actor, double speedFactor) {
            this.actor = actor;
            this.speedFactor = speedFactor;
        }

        @Override
        public void speedChanged(double speedX, double speedY) {
            double scrollX = speedX * this.speedFactor;
            double scrollY = speedY * this.speedFactor;
            this.actor.setSpeedX(scrollX);
            this.actor.setSpeedY(scrollY);
        }
    }

    protected static class ElementViewScrollHandler
    implements SpeedListener {
        private ElementViewScrollActor actor;
        private double speedFactor;

        public ElementViewScrollHandler(ElementViewScrollActor actor, double speedFactor) {
            this.actor = actor;
            this.speedFactor = speedFactor;
        }

        @Override
        public void speedChanged(double speedX, double speedY) {
            double scrollX = speedX * this.speedFactor;
            double scrollY = speedY * this.speedFactor;
            this.actor.setSpeedX(scrollX);
            this.actor.setSpeedY(scrollY);
        }
    }
}

