/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.Gadget;
import com.spacekiller.spacekiller.GadgetManager;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.resource.ShipElementTypeResource;
import com.spacekiller.spacekiller.resource.WeaponTypeResource;

public class GadgetManagers {
    private GadgetManagers() {
    }

    public static class ShipExtensionGadgetManager
    implements GadgetManager {
        private ShipElementTypeResource shipTypeResource;

        public ShipExtensionGadgetManager(ShipElementTypeResource shipTypeResource) {
            this.shipTypeResource = shipTypeResource;
        }

        @Override
        public void installGadget(Gadget gadget, Level level, Ship ship) throws Exception {
            ShipType shipType = this.shipTypeResource.getShipType();
            if (shipType == null) {
                return;
            }
            double x = gadget.getX();
            double y = gadget.getY();
            double z = -1.0 - Math.random();
            Ship ext = (Ship)shipType.createElement(ship.getId() + "$extension$" + this, x, y, 1.0, 1.0);
            ext.setCollisionGroup(level.getPlayerShipCollisionGroup());
            ext.setOwner(ship);
            ship.addExtension(ext);
            ElementModel model = level.getElementModel();
            model.add((Element)ext, x, y, z);
            MoveActor actor = new MoveActor((Element)ext);
            shipType.setupBehavior(level, model, ext, actor);
            level.addActor((Actor)actor);
        }
    }

    public static class LiveGadgetManager
    implements GadgetManager {
        @Override
        public void installGadget(Gadget gadget, Level level, Ship ship) throws Exception {
            Commander player = ship.getCommander();
            if (player != null) {
                player.incrementLives(1);
            }
        }
    }

    public static class WeaponGadgetManager
    implements GadgetManager {
        private WeaponTypeResource weaponTypeResource;
        private int bulletCount;

        public WeaponGadgetManager(WeaponTypeResource weaponTypeResource, int bulletCount) {
            this.weaponTypeResource = weaponTypeResource;
            this.bulletCount = bulletCount;
        }

        @Override
        public void installGadget(Gadget gadget, Level level, Ship ship) throws Exception {
            WeaponType weaponType = this.weaponTypeResource.getWeaponType();
            if (weaponType == null) {
                return;
            }
            Weapon weapon = weaponType.createWeapon(level, ship);
            if (weapon == null) {
                return;
            }
            weapon.setBulletCount(this.bulletCount);
            ship.installWeapon(weapon);
        }
    }

    public static class ShieldGadgetManager
    implements GadgetManager {
        private double shield;

        public ShieldGadgetManager(double shield) {
            this.shield = shield;
        }

        @Override
        public void installGadget(Gadget gadget, Level level, Ship ship) throws Exception {
            ship.incrementShield(this.shield);
        }
    }

    public static class ScoreGadgetManager
    implements GadgetManager {
        private int score;

        public ScoreGadgetManager(int score) {
            this.score = score;
        }

        @Override
        public void installGadget(Gadget gadget, Level level, Ship ship) throws Exception {
            Commander comm = ship.getCommander();
            if (comm != null) {
                comm.incrementScore(this.score);
            }
        }
    }
}

