/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.AbstractElementType;
import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Scene;
import com.spacekiller.spacekiller.Gadget;
import com.spacekiller.spacekiller.GadgetManager;
import javax.sound.sampled.Clip;

public class GadgetType
extends AbstractElementType {
    protected Animation animation;
    protected int loops = -1;
    protected boolean autoDispose = true;
    protected CollisionBounds collisionBounds;
    protected CollisionGroup collisionGroup;
    protected GadgetManager gadgetManager;
    protected Clip audioClip;

    public GadgetType(String id, Animation ani, int loops, boolean autoDispose, CollisionBounds cb, CollisionGroup cg, GadgetManager gm) {
        super(id);
        this.setAnimation(ani);
        this.setLoops(loops);
        this.setAutoDispose(autoDispose);
        this.setCollisionBounds(cb);
        this.setCollisionGroup(cg);
        this.setGadgetManager(gm);
    }

    public Element createElement(Object id, double x, double y, double w, double h) throws Exception {
        AnimationRenderer renderer = new AnimationRenderer(this.animation, this.loops, this.autoDispose);
        Gadget rc = new Gadget(id, x, y, this.animation.getWidth(), this.animation.getHeight(), (ElementType)this, (Renderer)renderer);
        renderer.setElement((Element)rc);
        rc.setCollisionBounds(this.getCollisionBounds());
        rc.setCollisionGroup(this.getCollisionGroup());
        return rc;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    public int getLoops() {
        return this.loops;
    }

    public void setLoops(int loops) {
        this.loops = loops;
    }

    public CollisionBounds getCollisionBounds() {
        return this.collisionBounds;
    }

    public void setCollisionBounds(CollisionBounds collisionBounds) {
        this.collisionBounds = collisionBounds;
    }

    public CollisionGroup getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(CollisionGroup collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public GadgetManager getGadgetManager() {
        return this.gadgetManager;
    }

    public void setGadgetManager(GadgetManager gadgetManager) {
        this.gadgetManager = gadgetManager;
    }

    public void setupBehavior(Scene scene, ElementModel model, Element element, MoveActor moveActor) {
    }

    public Clip getAudioClip() {
        return this.audioClip;
    }

    public void setAudioClip(Clip audioClip) {
        this.audioClip = audioClip;
    }
}

