/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.spacekiller.HighScore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HighScoreList {
    private static final int FILE_MAGIC = 1176909190;
    private List scores;
    private int capacity;

    protected HighScoreList(int capacity) {
        this.capacity = capacity;
        this.scores = new ArrayList(capacity);
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return this.scores.size();
    }

    public HighScore getHighScoreAt(int i) {
        return (HighScore)this.scores.get(i);
    }

    public Iterator getHighScores() {
        return this.scores.iterator();
    }

    public int indexOf(HighScore score) {
        return this.scores.indexOf(score);
    }

    synchronized boolean add(HighScore score) {
        if (this.scores.contains(score)) {
            return false;
        }
        int newScore = score.getScore();
        int num = this.scores.size();
        int i = -1;
        for (int c = 0; c < num; ++c) {
            HighScore s = (HighScore)this.scores.get(c);
            if (s.getScore() >= newScore) continue;
            i = c;
            break;
        }
        if (i < 0) {
            i = num;
        }
        if (i >= this.capacity) {
            return false;
        }
        this.scores.add(i, score);
        if (num >= this.capacity) {
            for (int j = this.capacity; j <= num; ++j) {
                this.scores.remove(this.capacity);
            }
        }
        return true;
    }

    synchronized boolean remove(HighScore score) {
        return this.scores.remove(score);
    }

    private int computeChecksum(HighScore hs) {
        int rc = (int)((long)(hs.getScore() + hs.getLevel()) + hs.getTime());
        return rc ^= hs.getName().hashCode();
    }

    void write(OutputStream out) throws Exception {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(1176909190);
        int num = this.size();
        dout.writeInt(num);
        for (int c = 0; c < num; ++c) {
            HighScore score = (HighScore)this.scores.get(c);
            dout.writeInt(score.getScore());
            dout.writeInt(score.getLevel());
            dout.writeLong(score.getTime());
            dout.writeUTF(score.getName());
            dout.writeInt(this.computeChecksum(score));
        }
        dout.flush();
        dout.close();
        out.flush();
    }

    void read(InputStream in) throws Exception {
        DataInputStream din = new DataInputStream(in);
        int magic = din.readInt();
        if (magic != 1176909190) {
            throw new StreamCorruptedException("Invalid high-score file");
        }
        int num = din.readInt();
        for (int c = 0; c < num; ++c) {
            HighScore hs;
            int score = din.readInt();
            int level = din.readInt();
            long time = din.readLong();
            String name = din.readUTF();
            int check = din.readInt();
            if (check != this.computeChecksum(hs = new HighScore(name, score, level, time))) {
                throw new StreamCorruptedException("Invalid checksum: " + check);
            }
            this.add(hs);
        }
    }
}

