/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.AbstractView;
import com.spacekiller.game2d.Engine;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.Level;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LevelStatusView
extends AbstractView {
    private Engine engine;
    private Level level;
    private Commander commander;
    private FontMetrics fontMetrics;
    private Font font;
    private int fontHeight;
    private int fontAscent;
    private Color textColor = Color.yellow;
    private int titleX = 0;
    private int valueX = 100;
    private String titleLevel = "Level:";
    private String titleFrames = "Frames:";
    private String titleActors = "Actors:";
    private String titleLives = "Lives:";
    private String titleScore = "Score:";
    private String titleCommander = "Player:";

    public LevelStatusView(Engine engine, Level level, Commander commander) {
        this.setEngine(engine);
        this.setLevel(level);
        this.setCommander(commander);
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.textColor);
        g.drawString(this.titleLevel, this.titleX, this.fontAscent);
        g.drawString(this.titleFrames, this.titleX, this.fontAscent + this.fontHeight);
        g.drawString(this.titleActors, this.titleX, this.fontAscent + this.fontHeight * 2);
        g.drawString(this.titleCommander, this.titleX, this.fontAscent + this.fontHeight * 3);
        g.drawString(this.titleScore, this.titleX, this.fontAscent + this.fontHeight * 4);
        g.drawString(this.titleLives, this.titleX, this.fontAscent + this.fontHeight * 5);
        g.drawString(String.valueOf(this.level.getName()), this.valueX, this.fontAscent);
        g.drawString(String.valueOf((int)this.engine.getFPS()), this.valueX, this.fontAscent + this.fontHeight);
        g.drawString(String.valueOf(this.level.getActorCount()), this.valueX, this.fontAscent + this.fontHeight * 2);
        g.drawString(String.valueOf(this.commander.getName()), this.valueX, this.fontAscent + this.fontHeight * 3);
        g.drawString(String.valueOf(this.commander.getScore()), this.valueX, this.fontAscent + this.fontHeight * 4);
        g.drawString(String.valueOf(this.commander.getLives()), this.valueX, this.fontAscent + this.fontHeight * 5);
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.fontMetrics = metrics;
        this.fontHeight = metrics.getHeight();
        this.fontAscent = metrics.getAscent();
        this.titleX = 0;
        this.valueX = this.fontMetrics.stringWidth(this.titleFrames) + 5;
        this.setFont(this.fontMetrics.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    protected void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Commander getCommander() {
        return this.commander;
    }

    public void setCommander(Commander commander) {
        this.commander = commander;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }
}

