/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.Gadget;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import java.util.ArrayList;
import java.util.List;

public class Ship
extends Element {
    private Commander commander;
    private Ship owner;
    private double power;
    private double shield;
    private MoveActor moveActor;
    private SpeedBehavior speedBehavior;
    private List weaponSlots = new ArrayList();
    private List weaponSets = new ArrayList();
    private CollisionGroup weaponCollisionGroup;
    private boolean exploding;
    private List gadgets;
    private int orientation = 1;
    private List extensions;

    public Ship(Object id, double x, double y, double w, double h, ElementType t, Renderer r) {
        super(id, x, y, w, h, t, r);
    }

    public double getPower() {
        return this.power;
    }

    public double getShield() {
        return this.shield;
    }

    public void setPower(double i) {
        this.power = i;
    }

    public void setShield(double i) {
        this.shield = i;
    }

    public void addWeaponSlot(WeaponSlot w) {
        if (w != null && !this.weaponSlots.contains(w)) {
            this.weaponSlots.add(w);
        }
    }

    public WeaponSlot getWeaponSlotAt(int i) {
        return (WeaponSlot)this.weaponSlots.get(i);
    }

    public int getWeaponSlotCount() {
        return this.weaponSlots.size();
    }

    public void removeWeaponSlot(WeaponSlot w) {
        this.weaponSlots.remove(w);
    }

    public void incrementPower(double i) {
        double newPower = this.power + i;
        if (newPower < 0.0) {
            newPower = 0.0;
        } else if (newPower > this.getMaxPower()) {
            newPower = this.getMaxPower();
        }
        this.setPower(newPower);
    }

    public void incrementShield(double i) {
        double newShield = this.shield + i;
        if (newShield < 0.0) {
            newShield = 0.0;
        } else if (newShield > this.getMaxShield()) {
            newShield = this.getMaxShield();
        }
        this.setShield(newShield);
    }

    public Commander getCommander() {
        return this.commander;
    }

    public void setCommander(Commander commander) {
        this.commander = commander;
    }

    public SpeedBehavior getSpeedBehavior() {
        return this.speedBehavior;
    }

    public void setSpeedBehavior(SpeedBehavior speedBehavior) {
        this.speedBehavior = speedBehavior;
    }

    public String toString() {
        return "Ship[" + this.getId() + "]";
    }

    public ShipType getShipType() {
        return (ShipType)this.type;
    }

    public double getMaxPower() {
        return ((ShipType)this.type).getMaxPower();
    }

    public double getMaxShield() {
        return ((ShipType)this.type).getMaxShield();
    }

    public int getKillScore() {
        return ((ShipType)this.type).getKillScore();
    }

    public MoveActor getMoveActor() {
        return this.moveActor;
    }

    public void setMoveActor(MoveActor movementActor) {
        this.moveActor = movementActor;
    }

    public boolean isExploding() {
        return this.exploding;
    }

    public void setExploding(boolean exploding) {
        this.exploding = exploding;
    }

    public boolean installWeapon(Weapon w) {
        if (w == null) {
            return false;
        }
        WeaponType wtype = w.getWeaponType();
        if (wtype != null) {
            return wtype.installWeapon(this, w);
        }
        return false;
    }

    public void addWeaponSet(WeaponSet w) {
        if (w != null && !this.weaponSets.contains(w)) {
            this.weaponSets.add(w);
        }
    }

    public void removeWeaponSet(WeaponSet w) {
        this.weaponSets.remove(w);
    }

    public int getWeaponSetCount() {
        return this.weaponSets.size();
    }

    public WeaponSet getWeaponSetAt(int i) {
        return (WeaponSet)this.weaponSets.get(i);
    }

    public CollisionGroup getWeaponCollisionGroup() {
        return this.weaponCollisionGroup;
    }

    public void setWeaponCollisionGroup(CollisionGroup weaponCollisionGroup) {
        this.weaponCollisionGroup = weaponCollisionGroup;
    }

    public int getGadgetCount() {
        return this.gadgets == null ? 0 : this.gadgets.size();
    }

    public Gadget getGadgetAt(int i) {
        return (Gadget)((Object)this.gadgets.get(i));
    }

    public void addGadget(Gadget g) {
        if (g == null) {
            return;
        }
        if (this.gadgets == null) {
            this.gadgets = new ArrayList();
        }
        this.gadgets.add(g);
    }

    public void removeGadget(Gadget g) {
        if (g == null) {
            return;
        }
        if (this.gadgets == null) {
            return;
        }
        this.gadgets.remove((Object)g);
    }

    public void uninstallWeapon(Weapon w) {
        int num = this.weaponSets.size();
        for (int c = 0; c < num; ++c) {
            WeaponSet wset = (WeaponSet)this.weaponSets.get(c);
            wset.removeWeapon(w);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getExtensionCount() {
        return this.extensions == null ? 0 : this.extensions.size();
    }

    public Element getExtensionAt(int i) {
        return (Element)this.extensions.get(i);
    }

    public void addExtension(Element e) {
        if (e == null) {
            return;
        }
        if (this.extensions == null) {
            this.extensions = new ArrayList();
        }
        this.extensions.add(e);
    }

    public void removeExtension(Element e) {
        if (this.extensions == null) {
            return;
        }
        this.extensions.remove(e);
    }

    public void removeAllExtensions() {
        if (this.extensions == null) {
            return;
        }
        this.extensions.clear();
    }

    public Ship getOwner() {
        return this.owner;
    }

    public void setOwner(Ship owner) {
        this.owner = owner;
    }
}

