/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.AbstractView;
import com.spacekiller.spacekiller.Ship;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ShipStatusView
extends AbstractView {
    private Ship ship;
    private FontMetrics fontMetrics;
    private Font font;
    private int fontHeight;
    private int fontAscent;
    private Color textColor = Color.yellow;
    private Color valueColor = Color.white;
    private int titleX = 0;
    private int valueX = 100;
    private String titlePower = "Power:";
    private String titleShield = "Shield:";
    private String titleWeapon = "Weapon:";
    private String weaponInfo = "";

    public ShipStatusView(Ship ship) {
        this.setShip(ship);
    }

    public void paint(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.textColor);
        g.drawString(this.titlePower, this.titleX, this.fontAscent);
        g.drawString(this.titleShield, this.titleX, this.fontAscent + this.fontHeight);
        int y3 = this.fontAscent + this.fontHeight * 2;
        g.drawString(this.titleWeapon, this.titleX, y3);
        g.setColor(this.valueColor);
        g.drawString(this.weaponInfo, this.valueX, y3);
        int barWidth = 75;
        int barHeight = this.fontHeight / 2;
        int barY = this.fontHeight / 2 - barHeight / 2;
        this.paintProgress(g, this.valueX, barY, barWidth, barHeight, (int)this.ship.getPower(), (int)this.ship.getMaxPower());
        this.paintProgress(g, this.valueX, barY + this.fontHeight, barWidth, barHeight, (int)this.ship.getShield(), (int)this.ship.getMaxShield());
    }

    protected void paintProgress(Graphics g, int x, int y, int w, int h, int value, int max) {
        int v = value * w / max;
        g.setColor(Color.green);
        g.fillRect(x, y, v, h);
        g.setColor(Color.darkGray);
        g.fillRect(x + v, y, w - v, h);
    }

    public Ship getShip() {
        return this.ship;
    }

    public void setShip(Ship ship) {
        this.ship = ship;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.fontMetrics = metrics;
        this.fontHeight = metrics.getHeight();
        this.fontAscent = metrics.getAscent();
        this.titleX = 0;
        this.valueX = this.fontMetrics.stringWidth(this.titleWeapon) + 5;
        this.setFont(this.fontMetrics.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    protected void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public String getWeaponInfo() {
        return this.weaponInfo;
    }

    public void setWeaponInfo(String weaponInfo) {
        this.weaponInfo = weaponInfo;
    }
}

