/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.DefaultElementType;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.resource.LevelResource;
import javax.sound.sampled.Clip;

public class ShipType
extends DefaultElementType {
    private double maxPower;
    private double maxShield;
    private int killScore = 1;
    private ExplosionType explosionType;
    private WeaponSlot[] weaponSlots;
    private WeaponType[] weaponTypes;
    private LevelResource levelResource;
    private boolean boss;
    private Clip alertClip;

    public ShipType(String id) {
        super(id);
    }

    public ShipType(String id, Renderer renderer, double elementWidth, double elementHeight, CollisionBounds cb, CollisionGroup cg, LevelResource levelResource) {
        super(id, renderer, elementWidth, elementHeight, cb, cg);
        this.levelResource = levelResource;
    }

    public Element createElement(Object id, double x, double y, double w, double h) throws Exception {
        int c;
        Ship ship = new Ship(id, x, y, this.elementWidth, this.elementHeight, (ElementType)this, this.renderer);
        ship.setCollisionBounds(this.collisionBounds);
        ship.setCollisionGroup(this.collisionGroup);
        ship.setPower(this.maxPower);
        ship.setShield(this.maxShield);
        Level level = null;
        if (this.levelResource != null) {
            level = this.levelResource.getLevel();
        }
        if (level == null) {
            throw new RuntimeException("Level is null: " + (Object)((Object)this) + ", levelResource=" + (Object)((Object)this.levelResource));
        }
        if (level != null) {
            level.setupShipOrientation(ship);
        }
        WeaponSet weaponSet1 = new WeaponSet("defaultWeaponSet");
        ship.addWeaponSet(weaponSet1);
        if (this.weaponSlots != null) {
            for (c = 0; c < this.weaponSlots.length; ++c) {
                WeaponSlot slot = this.weaponSlots[c];
                double posX = slot.getPosX();
                double posY = slot.getPosY();
                ship.addWeaponSlot(new WeaponSlot(ship, posX, posY));
            }
        }
        if (this.weaponTypes != null && level != null) {
            for (c = 0; c < this.weaponTypes.length; ++c) {
                Weapon weapon = this.weaponTypes[c].createWeapon(level, ship);
                if (weapon == null || ship.installWeapon(weapon)) continue;
                throw new RuntimeException("Cannot install weapon: ship=" + (Object)((Object)ship) + ", weapon=" + (Object)((Object)weapon));
            }
        }
        return ship;
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public double getMaxShield() {
        return this.maxShield;
    }

    public void setMaxPower(double i) {
        this.maxPower = i;
    }

    public void setMaxShield(double i) {
        this.maxShield = i;
    }

    public int getKillScore() {
        return this.killScore;
    }

    public void setKillScore(int killScore) {
        this.killScore = killScore;
    }

    public ExplosionType getExplosionType() {
        return this.explosionType;
    }

    public void setExplosionType(ExplosionType explosionType) {
        this.explosionType = explosionType;
    }

    public WeaponSlot[] getWeaponSlots() {
        return this.weaponSlots;
    }

    public void setWeaponSlots(WeaponSlot[] weaponSlots) {
        this.weaponSlots = weaponSlots;
    }

    public WeaponType[] getWeaponTypes() {
        return this.weaponTypes;
    }

    public void setWeaponTypes(WeaponType[] weaponTypes) {
        this.weaponTypes = weaponTypes;
    }

    public boolean isBoss() {
        return this.boss;
    }

    public void setBoss(boolean boss) {
        this.boss = boss;
    }

    public Clip getAlertClip() {
        return this.alertClip;
    }

    public void setAlertClip(Clip alertClip) {
        this.alertClip = alertClip;
    }
}

