/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.DefaultEnvironment;
import com.spacekiller.game2d.DefaultGameConfig;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.GameConfig;
import com.spacekiller.game2d.InputBinder;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.config.DefaultPersistenceManager;
import com.spacekiller.game2d.config.PersistenceManager;
import com.spacekiller.game2d.editor.GameEditor;
import com.spacekiller.game2d.resource.AbstractResourceProvider;
import com.spacekiller.game2d.resource.DefaultResourceRegistry;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioPlayer;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.ListAudioSequence;
import com.spacekiller.game2d.sound.LoopAudioSequence;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.HighScore;
import com.spacekiller.spacekiller.HighScoreList;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.LevelDescriptor;
import com.spacekiller.spacekiller.SpaceKillerConstants;
import com.spacekiller.spacekiller.SpaceKillerGame;
import com.spacekiller.spacekiller.input.DefaultSpaceKillerInputBinder;
import com.spacekiller.spacekiller.resource.LevelResource;
import com.spacekiller.spacekiller.resource.LevelResourceType;
import com.spacekiller.spacekiller.resource.SpaceKillerResourceProvider;
import com.spacekiller.spacekiller.resource.SpaceKillerResourceRegistry;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class SpaceKiller
implements SpaceKillerConstants {
    private static String[] providerClassNames = new String[]{"com.spacekiller.spacekiller.level.DefaultSpaceKillerResourceProvider"};
    public static final int DEFAULT_AUDIO_BUFFER_SIZE = 0x800000;
    private static final Logger logger = Logger.getLogger(SpaceKiller.class.getName());
    private boolean debug = false;
    private File optionsFile;
    private File scoreFile;
    private File tempDir;
    private SpaceKillerGame game;
    private Environment environment;
    private DefaultGameConfig gameConfig;
    private SpaceKillerResourceRegistry resourceRegistry;
    private PersistenceManager persistenceManager;
    private AudioBufferPool audioBufferPool;
    private File tempAudioDirectory;
    private AudioPlayer audioPlayer;
    private HighScoreList highScoreList;
    private int maxHighScores = 15;
    private String spaceKillerTitle = "Space Killer";
    private String spaceKillerVersion = "0.7.4";
    private String spaceKillerHomeURL = "spacekiller.com";
    private Rectangle spaceKillerWindowBounds;
    private Image spaceKillerIconImage;

    public SpaceKiller(File optionsFile, File scoreFile, File tempDir) throws Exception {
        this.optionsFile = optionsFile;
        this.scoreFile = scoreFile;
        this.tempDir = tempDir;
        this.initSpaceKiller();
    }

    protected void initSpaceKiller() throws Exception {
        logger.fine("SpaceKiller properties file: " + this.optionsFile.getAbsolutePath());
        this.loadGameConfig();
        try {
            this.loadFonts();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        this.setEnvironment(this.createEnvironment());
        HighScoreList highScores = new HighScoreList(this.maxHighScores);
        this.setHighScoreList(highScores);
        if (this.scoreFile.exists()) {
            this.loadScores();
        }
        try {
            this.initWelcomeSound();
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected static String[] getProviderClassNames() {
        return providerClassNames;
    }

    protected static void setProviderClassNames(String[] newproviderClassNames) {
        providerClassNames = newproviderClassNames;
    }

    private void saveScores() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.highScoreList.write(bout);
        bout.flush();
        byte[] data = bout.toByteArray();
        bout.close();
        ImageToolkit.getInstance().reorder1(data, 0, data.length, "installFonts".getBytes());
        FileOutputStream fout = new FileOutputStream(this.scoreFile);
        fout.write(data);
        fout.close();
    }

    private void loadScores() throws Exception {
        int num;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream fin = new FileInputStream(this.scoreFile);
        byte[] buf = new byte[1024];
        while ((num = fin.read(buf)) >= 0) {
            bout.write(buf, 0, num);
        }
        bout.flush();
        byte[] data = bout.toByteArray();
        ImageToolkit.getInstance().reorder2(data, 0, data.length, "installFonts".getBytes());
        this.highScoreList.read(new ByteArrayInputStream(data));
    }

    protected PersistenceManager createPersistenceManager() throws Exception {
        return new DefaultPersistenceManager((ResourceRegistry)this.getResourceRegistry());
    }

    protected PersistenceManager getPersistenceManager() throws Exception {
        if (this.persistenceManager == null) {
            this.setPersistenceManager(this.createPersistenceManager());
        }
        return this.persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager manager) {
        this.persistenceManager = manager;
    }

    protected SpaceKillerResourceRegistry createResourceRegistry() throws Exception {
        SpaceKillerResourceRegistry reg = new SpaceKillerResourceRegistry(this.getAudioBufferPool(), this.tempDir);
        reg.setMp3DecoderEnabled(true);
        JPanel dummy = new JPanel();
        MediaTracker tracker = new MediaTracker(dummy);
        int num = providerClassNames.length;
        logger.fine("SpaceProvider(s): " + num);
        long ms1 = System.currentTimeMillis();
        for (int c = 0; c < num; ++c) {
            String className = providerClassNames[c];
            try {
                logger.info("Loading provider: " + className);
                Class<?> providerClass = Class.forName(className);
                if (!SpaceKillerResourceProvider.class.isAssignableFrom(providerClass)) {
                    throw new ClassCastException("Invalid SpaceProvider class: " + providerClass);
                }
                Object instance = providerClass.newInstance();
                ResourceProvider spaceProvider = (ResourceProvider)instance;
                this.debug(" -> " + spaceProvider);
                spaceProvider.setRegistry((ResourceRegistry)reg);
                spaceProvider.setMediaTracker(tracker);
                spaceProvider.setAudioBufferPool(this.getAudioBufferPool());
                spaceProvider.setTempAudioDirectory(this.tempDir);
                if (spaceProvider instanceof SpaceKillerResourceProvider) {
                    LevelResource levelResource = new LevelResource("spacekiller.level", (ResourceType)LevelResourceType.getLevelResourceType(), null){

                        @Override
                        public Level getLevel() {
                            return SpaceKiller.this.getCurrentLevel();
                        }
                    };
                    ((SpaceKillerResourceProvider)spaceProvider).setLevelResource(levelResource);
                }
                if (this.debug && spaceProvider instanceof AbstractResourceProvider) {
                    ((AbstractResourceProvider)spaceProvider).setDebug(true);
                }
                spaceProvider.initialize();
                continue;
            }
            catch (Throwable e) {
                logger.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
        }
        long ms2 = System.currentTimeMillis();
        logger.fine("Providers initialized in " + (ms2 - ms1) + " ms.");
        if (this.debug) {
            reg.dump(System.out);
        }
        return reg;
    }

    public SpaceKillerResourceRegistry getResourceRegistry() throws Exception {
        if (this.resourceRegistry == null) {
            this.setResourceRegistry(this.createResourceRegistry());
        }
        return this.resourceRegistry;
    }

    protected void setResourceRegistry(SpaceKillerResourceRegistry registry) {
        this.resourceRegistry = registry;
    }

    protected void loadFonts() throws Exception {
        logger.fine("Loading fonts..");
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/CANCONTR.TTF"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/MatrixCodeFont.ttf"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/TAGSTER.TTF"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/TAGSXTREME.TTF"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/TAGSX___.TTF"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/textapoint.ttf"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/tongueofcolicab.ttf"));
        this.loadFont(this.getClass().getResource("/com/spacekiller/spacekiller/fonts/underattack.ttf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Font loadFont(URL fontURL) throws Exception {
        if (fontURL == null) {
            return null;
        }
        logger.finer("Loading font: " + fontURL);
        InputStream fontInputStream = fontURL.openStream();
        try {
            Font font = Font.createFont(0, fontInputStream);
            if (font != null) {
                Method registerFontMethod = GraphicsEnvironment.class.getMethod("registerFont", Font.class);
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                registerFontMethod.invoke((Object)env, font);
                logger.finer("Font loaded: " + font.getName() + " => " + font);
            }
            Font font2 = font;
            return font2;
        }
        finally {
            fontInputStream.close();
        }
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void debug(String s) {
        if (this.debug) {
            logger.fine(String.valueOf(s));
        }
    }

    protected Level getCurrentLevel() {
        if (this.game == null) {
            return null;
        }
        return this.game.getLevel();
    }

    protected AudioBufferPool createAudioBufferPool() {
        return new AudioBufferPool(0x800000);
    }

    protected AudioBufferPool getAudioBufferPool() {
        if (this.audioBufferPool == null) {
            this.setAudioBufferPool(this.createAudioBufferPool());
        }
        return this.audioBufferPool;
    }

    protected void setAudioBufferPool(AudioBufferPool audioBufferPool) {
        this.audioBufferPool = audioBufferPool;
    }

    public HighScoreList getHighScoreList() {
        return this.highScoreList;
    }

    private void setHighScoreList(HighScoreList highScoreList) {
        this.highScoreList = highScoreList;
    }

    public DefaultGameConfig getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(DefaultGameConfig gameConfig) {
        this.gameConfig = gameConfig;
    }

    protected AudioPlayer createAudioPlayer() {
        return new AudioPlayer();
    }

    protected AudioPlayer getAudioPlayer() {
        if (this.audioPlayer == null) {
            this.setAudioPlayer(this.createAudioPlayer());
        }
        return this.audioPlayer;
    }

    protected void setAudioPlayer(AudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
    }

    public List sortLevels(List levelDescrList) {
        int num = levelDescrList.size();
        ArrayList<LevelDescriptor> levelDescriptors = new ArrayList<LevelDescriptor>();
        for (int c = 0; c < num; ++c) {
            LevelDescriptor descr = (LevelDescriptor)levelDescrList.get(c);
            int diff = descr.getDifficulty();
            int index = -1;
            for (int i = 0; i < c; ++i) {
                LevelDescriptor lev = (LevelDescriptor)levelDescriptors.get(i);
                if (diff >= lev.getDifficulty()) continue;
                index = i;
                break;
            }
            if (index < 0) {
                index = c;
            }
            levelDescriptors.add(index, descr);
        }
        return levelDescriptors;
    }

    protected void initWelcomeSound() throws Exception {
        SpaceKillerResourceRegistry registry = this.getResourceRegistry();
        AudioSequence introSeq1 = registry.getAudioSequence("sk100_gambino01a.wav");
        AudioSequence introSeq2 = registry.getAudioSequence("sk100_gambino01d.wav");
        LoopAudioSequence loop2 = new LoopAudioSequence(introSeq2, 7);
        ListAudioSequence song = new ListAudioSequence();
        song.addAudioSequence((AudioSequence)loop2);
        song.addAudioSequence(introSeq1);
        AudioPlayer player = this.getAudioPlayer();
        player.clear();
        player.add((AudioSequence)song);
    }

    public void startWelcomeSound() {
        try {
            this.initWelcomeSound();
            AudioPlayer player = this.getAudioPlayer();
            if (!player.isRunning()) {
                player.start();
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected void initHighscoreSound(int position) throws Exception {
        SpaceKillerResourceRegistry registry = this.getResourceRegistry();
        AudioSequence seqApplause = registry.getAudioSequence("applause1.wav");
        AudioSequence seqHaha = registry.getAudioSequence("crowdlaughapplause1.wav");
        AudioSequence seqBoo = registry.getAudioSequence("boo.wav");
        AudioSequence introSeq1 = registry.getAudioSequence("sk100_gambino01a.wav");
        AudioSequence introSeq2 = registry.getAudioSequence("sk100_gambino01d.wav");
        LoopAudioSequence loop2 = new LoopAudioSequence(introSeq2, 7);
        ListAudioSequence song = new ListAudioSequence();
        song.addAudioSequence((AudioSequence)loop2);
        song.addAudioSequence(introSeq1);
        LoopAudioSequence loop = new LoopAudioSequence((AudioSequence)song, 1024);
        ListAudioSequence list1 = new ListAudioSequence();
        if (position <= 3) {
            list1.addAudioSequence(seqApplause);
        } else if (position <= 10) {
            list1.addAudioSequence(seqHaha);
        } else {
            list1.addAudioSequence(seqBoo);
        }
        list1.addAudioSequence((AudioSequence)loop);
        AudioPlayer player = this.getAudioPlayer();
        player.clear();
        player.add((AudioSequence)list1);
    }

    public void startHighscoreSound(int position) {
        block5: {
            try {
                this.initHighscoreSound(position);
                AudioPlayer player = this.getAudioPlayer();
                if (player.isRunning()) break block5;
                player.start();
                try {
                    while (!player.isRunning()) {
                        Thread.sleep(50L);
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    protected Environment createEnvironment() throws Exception {
        DefaultEnvironment env = new DefaultEnvironment();
        env.addInputBinder((InputBinder)new DefaultSpaceKillerInputBinder());
        return env;
    }

    public Environment getEnvironment() throws Exception {
        return this.environment;
    }

    private void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOptions() throws Exception {
        FileOutputStream fout = new FileOutputStream(this.optionsFile);
        try {
            this.gameConfig.getProperties().store(fout, "SpaceKiller options");
        }
        finally {
            fout.close();
        }
    }

    public GameEditor createGameEditor() throws Exception {
        GameEditor editor = new GameEditor();
        editor.setRegistry((DefaultResourceRegistry)this.getResourceRegistry());
        editor.setPersistenceManager(this.getPersistenceManager());
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadGameConfig() throws Exception {
        DefaultGameConfig config = new DefaultGameConfig();
        config.setProperty("surface", "fullscreen");
        this.setGameConfig(config);
        File file = this.optionsFile;
        if (!file.exists()) {
            return;
        }
        FileInputStream fin = new FileInputStream(file);
        try {
            Properties props = new Properties();
            props.load(fin);
            config.setProperties(props);
        }
        finally {
            fin.close();
        }
    }

    public SpaceKillerGame createGame() throws Exception {
        return this.createGame(null);
    }

    public SpaceKillerGame createGame(LevelDescriptor practiseLevel) throws Exception {
        String userName = System.getProperty("user.name");
        if (userName == null) {
            userName = "Nuke Skywalker";
        }
        Commander commander = new Commander();
        commander.setName(userName);
        commander.setLives(3);
        commander.setScore(0);
        Commander[] players = new Commander[]{commander};
        SpaceKillerResourceRegistry spaceReg = this.getResourceRegistry();
        ArrayList<LevelDescriptor> levelDescrList = new ArrayList<LevelDescriptor>();
        boolean practise = false;
        if (practiseLevel == null) {
            spaceReg.getLevelDescriptors(levelDescrList);
            int levelCount = levelDescrList.size();
            logger.fine("Level descriptors: " + levelCount);
            if (levelCount < 1) {
                throw new Exception("No SpaceKiller-Levels available!");
            }
        } else {
            practise = true;
            levelDescrList.add(practiseLevel);
        }
        List levelDescriptors = this.sortLevels(levelDescrList);
        Rectangle windowBounds = this.getSpaceKillerWindowBounds();
        if (windowBounds == null) {
            windowBounds = new Rectangle(0, 0, 800, 600);
        }
        this.game = new SpaceKillerGame(windowBounds, this.spaceKillerIconImage, this.getEnvironment(), this.getPersistenceManager(), this.getResourceRegistry(), (GameConfig)this.gameConfig, this.getAudioBufferPool(), this.getAudioPlayer(), levelDescriptors, players, practise);
        this.game.init();
        try {
            this.game.getSurface().setInvisibleCursor();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void runGame(SpaceKillerGame game, List dstNewHighScores) throws Exception {
        AudioPlayer player;
        HighScore[] scores;
        boolean practise;
        if (game == null) {
            throw new NullPointerException("game is null");
        }
        try {
            logger.fine("Stopping audio player...");
            AudioPlayer player2 = this.getAudioPlayer();
            if (player2 != null && player2.isRunning()) {
                player2.stop();
                while (player2.isRunning()) {
                    Thread.sleep(250L);
                }
                logger.fine("AudioPlayer stopped.");
            }
            game.run();
            practise = game.isPractise();
            scores = null;
        }
        catch (Throwable throwable) {
            AudioPlayer player3;
            boolean practise2 = game.isPractise();
            HighScore[] scores2 = null;
            try {
                Commander[] players;
                if (!practise2 && (players = game.getPlayers()) != null) {
                    scores2 = new HighScore[players.length];
                    for (int c = 0; c < players.length; ++c) {
                        scores2[c] = new HighScore(players[c].getName(), players[c].getScore(), players[c].getLevel() + 1, System.currentTimeMillis());
                        this.highScoreList.add(scores2[c]);
                    }
                    this.saveScores();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (game != null) {
                try {
                    game.dispose();
                }
                catch (Throwable e) {
                    logger.fine("Error while closing game: " + new Date());
                    this.handleException(e);
                }
            }
            if ((player3 = this.getAudioPlayer()) != null && player3.isRunning()) {
                try {
                    player3.stop();
                    while (player3.isRunning()) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            ArrayList<HighScore> newHighScoreList2 = new ArrayList<HighScore>();
            try {
                if (scores2 == null) throw throwable;
                if (practise2) throw throwable;
                boolean doSaveScores = false;
                for (int c = 0; c < scores2.length; ++c) {
                    int index;
                    HighScore score = scores2[c];
                    if (score.getScore() < 1 || (index = this.highScoreList.indexOf(score)) < 0) continue;
                    String playerName = score.getName();
                    this.highScoreList.remove(score);
                    HighScore newHighScore = new HighScore(playerName, score.getScore(), score.getLevel(), score.getTime());
                    this.highScoreList.add(newHighScore);
                    newHighScoreList2.add(newHighScore);
                    doSaveScores = true;
                }
                if (doSaveScores) {
                    this.saveScores();
                }
                Iterator i = newHighScoreList2.iterator();
                while (i.hasNext()) {
                    HighScore high = (HighScore)i.next();
                    dstNewHighScores.add(high);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.handleException(e);
            }
            throw throwable;
        }
        try {
            Commander[] players;
            if (!practise && (players = game.getPlayers()) != null) {
                scores = new HighScore[players.length];
                for (int c = 0; c < players.length; ++c) {
                    scores[c] = new HighScore(players[c].getName(), players[c].getScore(), players[c].getLevel() + 1, System.currentTimeMillis());
                    this.highScoreList.add(scores[c]);
                }
                this.saveScores();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (game != null) {
            try {
                game.dispose();
            }
            catch (Throwable e) {
                logger.fine("Error while closing game: " + new Date());
                this.handleException(e);
            }
        }
        if ((player = this.getAudioPlayer()) != null && player.isRunning()) {
            try {
                player.stop();
                while (player.isRunning()) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        ArrayList<HighScore> newHighScoreList = new ArrayList<HighScore>();
        try {
            if (scores == null) return;
            if (practise) return;
            boolean doSaveScores = false;
            for (int c = 0; c < scores.length; ++c) {
                int index;
                HighScore score = scores[c];
                if (score.getScore() < 1 || (index = this.highScoreList.indexOf(score)) < 0) continue;
                String playerName = score.getName();
                this.highScoreList.remove(score);
                HighScore newHighScore = new HighScore(playerName, score.getScore(), score.getLevel(), score.getTime());
                this.highScoreList.add(newHighScore);
                newHighScoreList.add(newHighScore);
                doSaveScores = true;
            }
            if (doSaveScores) {
                this.saveScores();
            }
            Iterator i = newHighScoreList.iterator();
            while (i.hasNext()) {
                HighScore high = (HighScore)i.next();
                dstNewHighScores.add(high);
            }
            return;
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    private void handleException(Throwable e) {
        logger.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
    }

    public String getSpaceKillerHomeURL() {
        return this.spaceKillerHomeURL;
    }

    public String getSpaceKillerTitle() {
        return this.spaceKillerTitle;
    }

    public String getSpaceKillerVersion() {
        return this.spaceKillerVersion;
    }

    public Image getSpaceKillerIconImage() {
        return this.spaceKillerIconImage;
    }

    public void setSpaceKillerIconImage(Image spaceKillerIconImage) {
        this.spaceKillerIconImage = spaceKillerIconImage;
    }

    public Rectangle getSpaceKillerWindowBounds() {
        return this.spaceKillerWindowBounds;
    }

    public void setSpaceKillerWindowBounds(Rectangle spaceKillerWindowBounds) {
        this.spaceKillerWindowBounds = spaceKillerWindowBounds;
    }
}

