/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.AbstractGame;
import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.DefaultEngine;
import com.spacekiller.game2d.DefaultScene;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.FillView;
import com.spacekiller.game2d.GameConfig;
import com.spacekiller.game2d.ImageView;
import com.spacekiller.game2d.InputMap;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.game2d.config.PersistenceManager;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioPlayer;
import com.spacekiller.spacekiller.AbstractLevel;
import com.spacekiller.spacekiller.Cockpit;
import com.spacekiller.spacekiller.Commander;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.LevelDescriptor;
import com.spacekiller.spacekiller.LevelStatusView;
import com.spacekiller.spacekiller.PowerGenerator;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.ShipStatusView;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.SpaceKillerConstants;
import com.spacekiller.spacekiller.SpeedListener;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.behavior.SpeedReduceBehavior;
import com.spacekiller.spacekiller.resource.SpaceKillerResourceRegistry;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SpaceKillerGame
extends AbstractGame
implements SpaceKillerConstants {
    private List levelDescriptors;
    private int levelIndex;
    private Level level;
    private Commander[] players;
    private boolean practise;
    private static final Logger logger = Logger.getLogger(SpaceKillerGame.class.getName());

    public SpaceKillerGame(Rectangle windowBounds, Image iconImage, Environment env, PersistenceManager pm, SpaceKillerResourceRegistry reg, GameConfig config, AudioBufferPool audioBufferPool, AudioPlayer audioPlayer, List levelDescriptors, Commander[] players, boolean practise) throws Exception {
        super.setTitle("Space Killer");
        super.setIconImage(iconImage);
        super.setWindowBounds(windowBounds);
        super.setEnvironment(env);
        super.setPersistenceManager(pm);
        super.setRegistry((ResourceRegistry)reg);
        super.setConfig(config);
        super.setAudioBufferPool(audioBufferPool);
        super.setAudioPlayer(audioPlayer);
        this.levelDescriptors = levelDescriptors;
        this.levelIndex = -1;
        this.players = players;
        this.practise = practise;
    }

    protected void loadLevel(int lvlIndex) throws Exception {
        Engine engine = this.getEngine();
        if (engine == null) {
            throw new NullPointerException("engine==null");
        }
        PersistenceManager persistenceManager = this.getPersistenceManager();
        if (persistenceManager == null) {
            throw new NullPointerException("persistenceManager==null");
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        logger.fine("Loading level: index=" + lvlIndex);
        if (lvlIndex < 0 || lvlIndex >= this.getLevelCount()) {
            throw new Exception("Level not found: index=" + lvlIndex);
        }
        LevelDescriptor descr = this.getLevelDescriptor(lvlIndex);
        logger.fine("Loading level: " + descr);
        String levelClassName = descr.getClassName();
        logger.fine("Level class: " + levelClassName);
        Class<?> levelClass = Class.forName(levelClassName);
        AbstractLevel level = (AbstractLevel)levelClass.newInstance();
        this.setLevelIndex(lvlIndex);
        this.setLevel(level);
        SpaceKillerResourceRegistry reg = (SpaceKillerResourceRegistry)this.getRegistry();
        reg.setMp3DecoderEnabled(true);
        level.setRegistry((ResourceRegistry)reg);
        level.setPersistenceManager(persistenceManager);
        level.setEngine(engine);
        level.setSurface(surface);
        level.setAudioBufferPool(this.getAudioBufferPool());
        level.setAudioPlayer(this.getAudioPlayer());
        DisplayMode targetMode = new DisplayMode(surface.getWidth(), surface.getHeight(), 24, 75);
        level.setTargetDisplayMode(targetMode);
        level.setAudioEnabled(true);
        level.setEffectEnabled(AbstractLevel.EFFECT_AUDIO_MUSIC, true);
        level.setEffectEnabled(AbstractLevel.EFFECT_AUDIO_BULLETS, true);
        level.setEffectEnabled(AbstractLevel.EFFECT_AUDIO_EXPLOSIONS, true);
        DefaultEngine defEngine = (DefaultEngine)engine;
        defEngine.addScene((DefaultScene)level);
        level.initialize();
        reg.setMp3DecoderEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        int c;
        Engine engine = this.getEngine();
        if (engine == null) {
            throw new NullPointerException("engine==null");
        }
        logger.fine("Engine: " + engine);
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        logger.fine("Surface: " + surface);
        SpaceKillerResourceRegistry registry = (SpaceKillerResourceRegistry)this.getRegistry();
        if (registry == null) {
            throw new NullPointerException("registry==null");
        }
        logger.fine("SpaceRegistry: " + (Object)((Object)registry));
        InputMap inputMap = this.getInputMap();
        if (inputMap == null) {
            throw new NullPointerException("inputMap==null");
        }
        logger.fine("InputMap: " + inputMap);
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        Image gameOverImage = registry.getImage("image.game.over");
        logger.fine("GameOver-Image: " + gameOverImage);
        ImageView gameOverView = new ImageView(gameOverImage.getWidth(null), gameOverImage.getHeight(null), gameOverImage);
        gameOverView.setX(surfaceW / 2 - gameOverView.getWidth() / 2);
        gameOverView.setY(surfaceH / 2 - gameOverView.getHeight() / 2);
        FillView fill = new FillView((Paint)Color.black);
        fill.setX(0);
        fill.setY(0);
        fill.setWidth(surfaceW);
        fill.setHeight(surfaceH);
        Image gameLoadingImage = registry.getImage("image.game.loading");
        logger.fine("GameLoading-Image: " + gameLoadingImage);
        ImageView gameLoadingView = null;
        if (gameLoadingImage != null) {
            gameLoadingView = new ImageView(gameLoadingImage.getWidth(null), gameLoadingImage.getHeight(null), gameLoadingImage);
            gameLoadingView.setX(surfaceW / 2 - gameLoadingView.getWidth() / 2);
            gameLoadingView.setY(surfaceH / 2 - gameLoadingView.getHeight() / 2);
        }
        if (this.levelIndex < 0) {
            this.levelIndex = 0;
        }
        Cockpit cockpit = null;
        Ship playerShip = null;
        ArrayList<Weapon> weapons = new ArrayList<Weapon>();
        Runtime runtime = Runtime.getRuntime();
        for (c = 0; c < this.players.length; ++c) {
            this.players[c].setLevel(0);
        }
        do {
            WeaponSet ws;
            surface.removeAllViews();
            surface.addView((View)fill);
            if (gameLoadingView != null) {
                surface.addView((View)gameLoadingView);
            }
            surface.render();
            surface.render();
            ((DefaultEngine)engine).clearScenes();
            this.dumpMemory();
            this.level = null;
            for (c = 0; c < this.players.length; ++c) {
                this.players[c].setShip(null);
            }
            runtime.gc();
            runtime.runFinalization();
            this.dumpMemory();
            this.loadLevel(this.levelIndex);
            double scrollSpeedX = this.level.getScrollSpeedX();
            double scrollSpeedY = this.level.getScrollSpeedY();
            ElementModel elementModel = this.level.getElementModel();
            ElementView elementView = this.level.getElementView();
            CollisionGroup playerBulletCollisionGroup = this.level.getPlayerBulletCollisionGroup();
            if (this.players.length != 1) {
                throw new Exception("TODO: handle multi-players: " + this.players.length);
            }
            Commander commander = this.players[0];
            commander.setLevel(this.levelIndex);
            AbstractLevel aLevel = (AbstractLevel)this.level;
            aLevel.setGameOverView((View)gameOverView);
            boolean isIntroLevel = aLevel.isIntroLevel();
            try {
                this.setRunning(true);
                if (!isIntroLevel) {
                    playerShip = this.createPlayerShip(this.level, "playerShipType01", "playerShip");
                    playerShip.setId("playerShip");
                    elementModel.add((Element)playerShip);
                    playerShip.setCommander(commander);
                    commander.setShip(playerShip);
                    playerShip.setOrientation(this.level.getOrientation());
                    logger.fine("PlayerShip: " + (Object)((Object)playerShip));
                    PowerGenerator powerGenerator = new PowerGenerator(this.level, playerShip);
                    powerGenerator.setPowerIncrement(0.5);
                    this.level.addActor((Actor)powerGenerator);
                    MoveActor moveActor = new MoveActor((Element)playerShip);
                    SpeedBehavior speedBehavior = new SpeedBehavior(moveActor);
                    speedBehavior.setSpeedX(2.0);
                    speedBehavior.setSpeedY(0.0);
                    moveActor.addAction((Action)speedBehavior);
                    this.level.addActor((Actor)moveActor);
                    playerShip.setMoveActor(moveActor);
                    playerShip.setSpeedBehavior(speedBehavior);
                    SpeedReduceBehavior reduceBehavior = new SpeedReduceBehavior(speedBehavior);
                    reduceBehavior.setNullSpeedX(scrollSpeedX);
                    reduceBehavior.setNullSpeedY(scrollSpeedY);
                    reduceBehavior.setSpeedReduction(0.005);
                    moveActor.addAction((Action)reduceBehavior);
                    aLevel.addScrollSpeedListener(new SpeedReduceHandler(reduceBehavior));
                    aLevel.addPlayerShip(playerShip);
                    WeaponSet weaponSet1 = new WeaponSet("weaponSet1");
                    playerShip.addWeaponSet(weaponSet1);
                    WeaponSet weaponSet2 = new WeaponSet("weaponSet2");
                    playerShip.addWeaponSet(weaponSet2);
                    WeaponSet weaponSet3 = new WeaponSet("weaponSet3");
                    playerShip.addWeaponSet(weaponSet3);
                    playerShip.setWeaponCollisionGroup(playerBulletCollisionGroup);
                    if (weapons.isEmpty()) {
                        WeaponType weaponType = registry.getWeaponType("weaponType07");
                        if (weaponType == null) {
                            throw new Exception("Missing default weapon type!");
                        }
                        Weapon weapon = weaponType.createWeapon(this.level, playerShip);
                        if (weapon == null) {
                            throw new Exception("Missing default weapon!");
                        }
                        weapon.setBulletCount(100000);
                        weapons.add(weapon);
                    }
                    int num = weapons.size();
                    for (int k = 0; k < num; ++k) {
                        Weapon weapon = (Weapon)((Object)weapons.get(k));
                        if (weapon.getLevel() != this.level || weapon.getShip() != playerShip) {
                            WeaponType wtype = weapon.getWeaponType();
                            if (wtype == null) continue;
                            Weapon newWeapon = wtype.createWeapon(this.level, playerShip);
                            newWeapon.setBulletCount(weapon.getBulletCount());
                            weapon = newWeapon;
                        }
                        playerShip.installWeapon(weapon);
                    }
                    ArrayList weaponTypes = new ArrayList();
                    registry.getWeaponTypes(weaponTypes);
                    logger.fine("Weapon types: " + weaponTypes.size());
                    for (int c2 = 0; c2 < weaponTypes.size(); ++c2) {
                        WeaponType weaponType = (WeaponType)weaponTypes.get(c2);
                        Weapon weapon = weaponType.createWeapon(this.level, playerShip);
                        weaponType = weapon.getWeaponType();
                    }
                    if (cockpit == null) {
                        cockpit = new Cockpit();
                    }
                    cockpit.setLevel(this.level);
                    cockpit.setSpeedBehavior(speedBehavior);
                    cockpit.setModel(elementModel);
                    cockpit.setViewRect(elementView.getViewRect());
                    cockpit.setInputMap(inputMap);
                    cockpit.setup();
                    cockpit.setShip(playerShip);
                    cockpit.setActive(true);
                    AbstractLevel alevel = (AbstractLevel)this.level;
                    alevel.setCockpit(cockpit);
                    this.level.addActor(cockpit);
                    Font statusFont = new Font("dialog", 0, 10);
                    FontMetrics statusFM = surface.getWindow().getFontMetrics(statusFont);
                    LevelStatusView levelStatus = new LevelStatusView(engine, this.level, commander);
                    levelStatus.setFontMetrics(statusFM);
                    levelStatus.setX(5);
                    levelStatus.setY(5);
                    levelStatus.setWidth(200);
                    levelStatus.setHeight(100);
                    surface.addView((View)levelStatus);
                    ShipStatusView playerShipStatus = new ShipStatusView(playerShip);
                    playerShipStatus.setFontMetrics(statusFM);
                    playerShipStatus.setX(5);
                    playerShipStatus.setY(surfaceH - 50);
                    playerShipStatus.setWidth(300);
                    playerShipStatus.setHeight(100);
                    surface.addView((View)playerShipStatus);
                    cockpit.setShipStatusView(playerShipStatus);
                }
                this.dumpMemory();
                runtime.gc();
                runtime.runFinalization();
                this.dumpMemory();
                logger.info("Running engine...");
                engine.reset();
                engine.run();
            }
            finally {
                this.setRunning(false);
                logger.info("Engine stopped.");
                this.dumpMemory();
                this.level.dumpActors(System.out);
                this.level.dumpView(System.out);
                try {
                    elementModel.checkRectConsistency(elementView.getViewRect());
                }
                catch (Exception e) {
                    logger.fine("ERROR >> ElementModel Consistency Error:");
                    logger.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                }
                if (cockpit != null) {
                    Rumbler rumbler = cockpit.getRumbler();
                    if (rumbler != null) {
                        rumbler.rumble(0.0f);
                    }
                    cockpit.setActive(false);
                }
                if (playerShip != null) {
                    int numSets = playerShip.getWeaponSetCount();
                    for (int i = 0; i < numSets; ++i) {
                        ws = playerShip.getWeaponSetAt(i);
                        ws.deactivateWeapons();
                    }
                }
            }
            if (!this.level.isCompleted()) break;
            weapons.clear();
            if (playerShip != null) {
                int numSets = playerShip.getWeaponSetCount();
                for (int i = 0; i < numSets; ++i) {
                    ws = playerShip.getWeaponSetAt(i);
                    int numWeapons = ws.getWeaponCount();
                    for (int k = 0; k < numWeapons; ++k) {
                        Weapon weapon = ws.getWeaponAt(k);
                        if (weapon == null) continue;
                        weapons.add(weapon);
                    }
                }
            }
            ++this.levelIndex;
        } while (this.levelIndex < this.getLevelCount());
        logger.fine("End of game.");
        registry.setMp3DecoderEnabled(true);
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public int getLevelCount() {
        return this.levelDescriptors.size();
    }

    public LevelDescriptor getLevelDescriptor(int i) {
        return (LevelDescriptor)this.levelDescriptors.get(i);
    }

    protected void setLevelIndex(int i) {
        this.levelIndex = i;
    }

    public Level getLevel() {
        return this.level;
    }

    protected void setLevel(Level level) {
        this.level = level;
    }

    protected Commander[] getPlayers() {
        return this.players;
    }

    protected void setPlayers(Commander[] commanders) {
        this.players = commanders;
    }

    public int getPlayerCount() {
        return this.players.length;
    }

    public Commander getPlayerAt(int i) {
        return this.players[i];
    }

    public void init() throws Exception {
        super.init();
    }

    public void dispose() throws Exception {
        super.dispose();
    }

    public Ship createPlayerShip(Level level, String shipTypeNamePrefix, String id) throws Exception {
        CollisionGroup playerShipCollisionGroup = level.getPlayerShipCollisionGroup();
        SpaceKillerResourceRegistry reg = (SpaceKillerResourceRegistry)this.getRegistry();
        ShipType type = null;
        String typeId = null;
        Surface surface = this.getSurface();
        int surfaceW = surface.getWidth();
        int surfaceH = surface.getHeight();
        double x = 0.0;
        double y = 0.0;
        switch (level.getOrientation()) {
            case 0: {
                x = surfaceW;
                y = surfaceH / 2;
                typeId = shipTypeNamePrefix + "_Left";
                type = (ShipType)reg.getElementType(typeId);
                break;
            }
            case 1: {
                x = 0.0;
                y = surfaceH / 2;
                typeId = shipTypeNamePrefix + "_Right";
                type = (ShipType)reg.getElementType(typeId);
                break;
            }
            case 2: {
                x = surfaceW / 2;
                y = surfaceH;
                typeId = shipTypeNamePrefix + "_Up";
                type = (ShipType)reg.getElementType(typeId);
                break;
            }
            case 3: {
                x = surfaceW / 2;
                y = 0.0;
                typeId = shipTypeNamePrefix + "_Down";
                type = (ShipType)reg.getElementType(typeId);
            }
        }
        if (type == null) {
            throw new Exception("ShipType not found: " + typeId);
        }
        type.setCollisionGroup(playerShipCollisionGroup);
        Ship ship = (Ship)type.createElement(id, x, y, 1.0, 1.0);
        ship.setPower(type.getMaxPower());
        ship.setShield(type.getMaxShield());
        return ship;
    }

    private void dumpMemory() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long max = runtime.maxMemory();
        long used = total - free;
        logger.fine("Memory: used=" + used + " / free=" + free + " / total=" + total + " / max=" + max);
    }

    public boolean isPractise() {
        return this.practise;
    }

    protected void setPractise(boolean practise) {
        this.practise = practise;
    }

    protected static class SpeedReduceHandler
    implements SpeedListener {
        private SpeedReduceBehavior behavior;

        public SpeedReduceHandler(SpeedReduceBehavior behavior) {
            this.behavior = behavior;
        }

        @Override
        public void speedChanged(double speedX, double speedY) {
            this.behavior.setNullSpeedX(speedX);
            this.behavior.setNullSpeedY(speedY);
        }
    }
}

