/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Element;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.Bullet;

public abstract class Weapon
extends Actor {
    private WeaponType weaponType;
    private int weaponTypeId;
    protected Level level;
    protected Ship ship;
    protected WeaponSlot slot;
    protected double power;
    protected boolean active = false;
    protected int bulletCount = 1;

    public Weapon(WeaponType type, Level level, Ship ship) {
        this.setWeaponType(type);
        this.setLevel(level);
        this.setShip(ship);
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double i) {
        this.power = i;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean b) {
        if (this.active == b) {
            return;
        }
        this.active = b;
        if (this.active) {
            this.weaponActivated();
        } else {
            this.weaponDeactivated();
        }
    }

    protected abstract void weaponActivated();

    protected abstract void weaponDeactivated();

    public Ship getShip() {
        return this.ship;
    }

    protected void setShip(Ship ship) {
        this.ship = ship;
    }

    public Level getLevel() {
        return this.level;
    }

    protected void setLevel(Level level) {
        this.level = level;
    }

    public WeaponSlot getSlot() {
        return this.slot;
    }

    public void setSlot(WeaponSlot slot) {
        this.slot = slot;
    }

    protected void handleBulletCollision(Bullet b, Element e) {
    }

    public WeaponType getWeaponType() {
        return this.weaponType;
    }

    public void setWeaponType(WeaponType weaponType) {
        this.weaponType = weaponType;
        if (weaponType != null) {
            this.setWeaponTypeId(weaponType.getId());
        } else {
            this.setWeaponTypeId(0);
        }
    }

    public int hashCode() {
        return this.weaponTypeId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Weapon) {
            return ((Weapon)((Object)obj)).getWeaponTypeId() == this.weaponTypeId;
        }
        return false;
    }

    public int getWeaponTypeId() {
        return this.weaponTypeId;
    }

    protected void setWeaponTypeId(int weaponTypeId) {
        this.weaponTypeId = weaponTypeId;
    }

    public int getBulletCount() {
        return this.bulletCount;
    }

    public void setBulletCount(int bulletCount) {
        this.bulletCount = bulletCount;
    }

    public void uninstall() {
        if (this.ship == null) {
            return;
        }
        this.ship.uninstallWeapon(this);
    }
}

