/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller;

import com.spacekiller.game2d.InputButton;
import com.spacekiller.spacekiller.Weapon;
import java.util.ArrayList;
import java.util.List;

public class WeaponSet {
    private String id;
    private int count = 0;
    private int defaultIndex = -1;
    private Weapon defaultWeapon = null;
    private List weapons;
    private InputButton button;
    private boolean pressed;

    public WeaponSet(String id) {
        this.id = id;
        this.weapons = new ArrayList();
    }

    public String toString() {
        return super.toString() + "[id=" + this.id + "]";
    }

    public String getId() {
        return this.id;
    }

    public Weapon getDefaultWeapon() {
        return this.defaultWeapon;
    }

    public void setDefaultWeapon(Weapon w) {
        this.setDefaultIndex(this.weapons.indexOf((Object)w));
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(int i) {
        if (i < 0) {
            return;
        }
        Weapon newWeapon = this.getWeaponAt(i);
        if (newWeapon != this.defaultWeapon) {
            boolean active = false;
            if (this.defaultWeapon != null) {
                active = this.defaultWeapon.isActive();
                this.defaultWeapon.setActive(false);
            }
            this.defaultWeapon = newWeapon;
            this.defaultIndex = i;
            if (active && newWeapon != null) {
                newWeapon.setActive(true);
            }
        }
    }

    public void switchDefaultWeapon(int delta) {
        if (this.count > 0 && delta != 0) {
            int i = (this.defaultIndex + delta) % this.count;
            if (delta < 0 && i < 0) {
                i += this.count;
            }
            if (i != this.defaultIndex) {
                this.setDefaultIndex(i);
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getWeaponCount() {
        return this.weapons.size();
    }

    public Weapon getWeaponAt(int i) {
        return (Weapon)((Object)this.weapons.get(i));
    }

    public void addWeapon(Weapon w) {
        int i = this.weapons.indexOf((Object)w);
        if (i >= 0) {
            Weapon weapon = (Weapon)((Object)this.weapons.get(i));
            weapon.setBulletCount(weapon.getBulletCount() + w.getBulletCount());
            return;
        }
        this.addWeapon(w, this.count);
    }

    protected void addWeapon(Weapon w, int i) {
        if (w != null) {
            this.weapons.add(i, w);
            ++this.count;
            if (this.defaultWeapon == null) {
                this.defaultWeapon = w;
                this.defaultIndex = i;
            }
        }
    }

    public void removeWeapon(Weapon w) {
        if (this.weapons.remove((Object)w)) {
            --this.count;
        }
        if (w == this.defaultWeapon) {
            this.setDefaultIndex(Math.min(this.defaultIndex, this.count - 1));
        }
    }

    public void removeWeaponAt(int i) {
        if (this.weapons.remove(i) != null) {
            --this.count;
        }
        if (i == this.defaultIndex) {
            this.setDefaultIndex(Math.min(this.defaultIndex, this.count - 1));
        }
    }

    public InputButton getButton() {
        return this.button;
    }

    public void setButton(InputButton button) {
        this.button = button;
        this.pressed = button == null ? false : button.isPressed();
    }

    public void poll() {
        if (this.button != null && this.pressed != this.button.isPressed()) {
            boolean bl = this.pressed = !this.pressed;
            if (this.defaultWeapon != null) {
                this.defaultWeapon.setActive(this.pressed);
            }
        }
    }

    public void activateWeapons() {
        int num = this.getWeaponCount();
        for (int c = 0; c < num; ++c) {
            Weapon w = this.getWeaponAt(c);
            if (w == null || w.isActive()) continue;
            w.setActive(true);
        }
    }

    public void deactivateWeapons() {
        int num = this.getWeaponCount();
        for (int c = 0; c < num; ++c) {
            Weapon w = this.getWeaponAt(c);
            if (w == null || !w.isActive()) continue;
            w.setActive(false);
        }
    }
}

