/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.behavior.AbstractShipBehaviorType;

public abstract class AbstractBossShipBehaviorType
extends AbstractShipBehaviorType {
    public AbstractBossShipBehaviorType(String id) {
        super(id);
    }

    @Override
    protected void setupLastBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor) {
        super.setupLastBehavior(level, model, ship, moveActor);
        ElementView view = level.getElementView();
        if (view == null) {
            throw new NullPointerException("OOPS, ElementView==null");
        }
        BossBehavior bb = this.createBossBehavior(level, view, ship, moveActor);
        DoNotLeaveViewBehavior dnlvb = new DoNotLeaveViewBehavior(level, view, ship, moveActor, bb);
        moveActor.addAction((Action)bb);
        moveActor.addAction((Action)dnlvb);
    }

    protected abstract BossBehavior createBossBehavior(Level var1, ElementView var2, Ship var3, MoveActor var4);

    protected static class DoNotLeaveViewBehavior
    extends Behavior {
        private Level level;
        private ElementView view;
        private Ship ship;
        private MoveActor moveActor;
        private BossBehavior bossBehavior;

        public DoNotLeaveViewBehavior(Level level, ElementView view, Ship ship, MoveActor moveActor, BossBehavior bossBehavior) {
            this.level = level;
            this.view = view;
            this.ship = ship;
            this.moveActor = moveActor;
            this.bossBehavior = bossBehavior;
        }

        public void invoke(long ms) {
            Rect viewRect = this.view.getViewRect();
            double vx = viewRect.getX();
            double vy = viewRect.getY();
            double vw = viewRect.getWidth();
            double vh = viewRect.getHeight();
            double sx = this.ship.getX() + this.moveActor.getMoveX();
            double sy = this.ship.getY() + this.moveActor.getMoveY();
            double sw = this.ship.getWidth();
            double sh = this.ship.getHeight();
            SpeedBehavior speed = this.ship.getSpeedBehavior();
            if (sx <= vx) {
                this.moveActor.setMoveX(vx - sx + 1.0);
                if (speed.getSpeedX() <= this.level.getScrollSpeedX()) {
                    speed.setSpeedX(this.level.getScrollSpeedX() + 0.1);
                }
                this.bossBehavior.changeBossBehavior();
            } else if (sx + sw >= vx + vw) {
                this.moveActor.setMoveX(vx + vw - sx - sw - 1.0);
                if (speed.getSpeedX() >= this.level.getScrollSpeedX()) {
                    speed.setSpeedX(this.level.getScrollSpeedX() - 0.1);
                }
                this.bossBehavior.changeBossBehavior();
            }
            if (sy <= vy) {
                this.moveActor.setMoveY(vy - sy + 1.0);
                if (speed.getSpeedY() <= this.level.getScrollSpeedY()) {
                    speed.setSpeedY(this.level.getScrollSpeedY() + 0.1);
                }
                this.bossBehavior.changeBossBehavior();
            } else if (sy + sh >= vy + vh) {
                this.moveActor.setMoveY(vy + vh - sy - sh - 1.0);
                if (speed.getSpeedY() >= this.level.getScrollSpeedY()) {
                    speed.setSpeedY(this.level.getScrollSpeedY() - 0.1);
                }
                this.bossBehavior.changeBossBehavior();
            }
        }
    }

    protected static abstract class BossBehavior
    extends Behavior {
        private Level level;
        private ElementView view;
        private Ship ship;
        private MoveActor moveActor;

        public BossBehavior(Level level, ElementView view, Ship ship, MoveActor moveActor) {
            this.level = level;
            this.view = view;
            this.ship = ship;
            this.moveActor = moveActor;
        }

        public abstract void changeBossBehavior();

        public Level getLevel() {
            return this.level;
        }

        protected void setLevel(Level level) {
            this.level = level;
        }

        public MoveActor getMoveActor() {
            return this.moveActor;
        }

        protected void setMoveActor(MoveActor moveActor) {
            this.moveActor = moveActor;
        }

        public Ship getShip() {
            return this.ship;
        }

        protected void setShip(Ship ship) {
            this.ship = ship;
        }

        public ElementView getView() {
            return this.view;
        }

        protected void setView(ElementView view) {
            this.view = view;
        }
    }
}

