/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.AbstractBehaviorType;
import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Scene;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.behavior.EnemyBehavior;

public abstract class AbstractShipBehaviorType
extends AbstractBehaviorType {
    private int minActionInterval = 500;
    private int maxActionInterval = 3000;
    private double minSpeed;
    private double maxSpeed;

    public AbstractShipBehaviorType(String id) {
        super(id);
    }

    public final void setupBehavior(Scene scene, ElementModel model, Element element, MoveActor moveActor) {
        Level level = (Level)scene;
        Ship ship = (Ship)element;
        SpeedBehavior speed = this.createSpeedBehavior(level, model, ship, moveActor);
        if (speed != null) {
            ship.setSpeedBehavior(speed);
            moveActor.addAction((Action)speed);
        }
        this.setupMovementBehavior(level, model, ship, moveActor);
        this.setupEnemyBehavior(level, model, ship, moveActor, speed);
        this.setupLastBehavior(level, model, ship, moveActor);
    }

    protected abstract void setupMovementBehavior(Level var1, ElementModel var2, Ship var3, MoveActor var4);

    protected SpeedBehavior createSpeedBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor) {
        SpeedBehavior speed = new SpeedBehavior(moveActor);
        double s = this.minSpeed + Math.random() * (this.maxSpeed - this.minSpeed);
        double speedX = 0.0;
        double speedY = 0.0;
        switch (level.getOrientation()) {
            case 0: {
                speedX = s;
                break;
            }
            case 1: {
                speedX = -s;
                break;
            }
            case 2: {
                speedY = s;
                break;
            }
            case 3: {
                speedY = -s;
            }
        }
        speed.setSpeedX(speedX);
        speed.setSpeedY(speedY);
        return speed;
    }

    protected void setupEnemyBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor, SpeedBehavior speed) {
        ElementView ev = level.getElementView();
        EnemyBehavior enemy = new EnemyBehavior(level, ev, ship, speed, this.minActionInterval, this.maxActionInterval);
        moveActor.addAction((Action)enemy);
    }

    protected void setupLastBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor) {
    }

    public int getMaxActionInterval() {
        return this.maxActionInterval;
    }

    protected void setMaxActionInterval(int maxActionInterval) {
        this.maxActionInterval = maxActionInterval;
    }

    public int getMinActionInterval() {
        return this.minActionInterval;
    }

    protected void setMinActionInterval(int minActionInterval) {
        this.minActionInterval = minActionInterval;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public double getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(double minSpeed) {
        this.minSpeed = minSpeed;
    }
}

