/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSet;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.weapons.Gun;

public class EnemyBehavior
extends Behavior {
    private Level level;
    private ElementView view;
    private Ship ship;
    private SpeedBehavior speedBehavior;
    private int minActionInterval;
    private int maxActionInterval;
    private long ems;
    private long nms;
    private double randomAngle = 0.39269908169872414;

    public EnemyBehavior(Level level, ElementView view, Ship ship, SpeedBehavior speedBehavior, int minActionInterval, int maxActionInterval) {
        this.level = level;
        this.setView(view);
        this.setShip(ship);
        this.setSpeedBehavior(speedBehavior);
        this.setMinActionInterval(minActionInterval);
        this.setMaxActionInterval(maxActionInterval);
        this.ems = 0L;
        this.nms = this.firstActionMillis();
    }

    public void invoke(long ms) {
        this.ems += ms;
        if (this.ems < this.nms) {
            return;
        }
        this.nms = this.ems + this.nextActionMillis();
        this.ship.setPower(this.ship.getMaxPower());
        Weapon w = this.chooseWeapon();
        if (w != null) {
            int p;
            Ship playerShip;
            int players;
            Gun gun;
            if (w instanceof Gun && (gun = (Gun)((Object)w)).isRotatable() && (players = this.level.getPlayerShipCount()) > 0 && (playerShip = this.level.getPlayerShipAt(p = (int)(Math.random() * (double)players))) != null) {
                double s;
                double a;
                double wx = this.ship.getX();
                double wy = this.ship.getY();
                WeaponSlot slot = w.getSlot();
                if (slot != null) {
                    wx += slot.getPosX();
                    wy += slot.getPosY();
                }
                double px = playerShip.getX() + playerShip.getWidth() / 2.0;
                double py = playerShip.getY() + playerShip.getHeight() / 2.0;
                double bulletSpeed = Math.abs(gun.getBulletSpeedX()) + Math.abs(gun.getBulletSpeedY());
                double sx = px - wx;
                double sy = py - wy;
                double d = a = sy == 0.0 ? 0.0 : Math.atan(sx / sy);
                if (sy < 0.0) {
                    a += Math.PI;
                }
                double t = (s = Math.sin(a) * bulletSpeed) == 0.0 ? 0.0 : Math.abs(sx / s);
                MoveActor ma = playerShip.getMoveActor();
                double psx = ma.getSpeedX();
                double psy = ma.getSpeedY();
                sx = (px += psx * t) - wx;
                sy = (py += psy * t) - wy;
                double d2 = a = sy == 0.0 ? 0.0 : Math.atan(sx / sy);
                if (sy < 0.0) {
                    a += Math.PI;
                }
                a += (Math.random() - 0.5) * this.randomAngle;
                while (a < 0.0) {
                    a += Math.PI * 2;
                }
                while (a >= Math.PI * 2) {
                    a -= Math.PI * 2;
                }
                gun.setAngle(a);
            }
            w.setActive(true);
            w.setActive(false);
        }
    }

    protected long nextActionMillis() {
        int t = (int)((double)(this.maxActionInterval - this.minActionInterval) * Math.random());
        return this.minActionInterval + t;
    }

    protected long firstActionMillis() {
        int t = (int)((double)this.maxActionInterval * Math.random());
        return t;
    }

    protected Weapon chooseWeapon() {
        int num = this.ship.getWeaponSetCount();
        if (num < 1) {
            return null;
        }
        int w = (int)(Math.random() * (double)num);
        WeaponSet ws = this.ship.getWeaponSetAt(w);
        int wc = ws.getWeaponCount();
        if (wc < 1) {
            return null;
        }
        w = (int)(Math.random() * (double)wc);
        return ws.getWeaponAt(w);
    }

    public SpeedBehavior getSpeedBehavior() {
        return this.speedBehavior;
    }

    protected void setSpeedBehavior(SpeedBehavior speedBehavior) {
        this.speedBehavior = speedBehavior;
    }

    public ElementView getView() {
        return this.view;
    }

    protected void setView(ElementView view) {
        this.view = view;
    }

    public Ship getShip() {
        return this.ship;
    }

    protected void setShip(Ship ship) {
        this.ship = ship;
    }

    public int getMaxActionInterval() {
        return this.maxActionInterval;
    }

    protected void setMaxActionInterval(int maxActionInterval) {
        this.maxActionInterval = maxActionInterval;
    }

    public int getMinActionInterval() {
        return this.minActionInterval;
    }

    protected void setMinActionInterval(int minActionInterval) {
        this.minActionInterval = minActionInterval;
    }

    public double getRandomAngle() {
        return this.randomAngle;
    }

    public void setRandomAngle(double randomAngle) {
        this.randomAngle = randomAngle;
    }
}

