/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.behavior.AbstractShipBehaviorType;

public class ExtensionBehaviorType
extends AbstractShipBehaviorType {
    private double posX;
    private double posY;

    public ExtensionBehaviorType(String id) {
        super(id);
    }

    @Override
    protected void setupMovementBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor) {
        ExtensionBehavior eb = new ExtensionBehavior(ship, moveActor, this.posX, this.posY);
        moveActor.addAction((Action)eb);
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    protected static class ExtensionBehavior
    extends Behavior {
        private Ship extension;
        private MoveActor moveActor;
        private double posX;
        private double posY;

        public ExtensionBehavior(Ship extension, MoveActor moveActor, double posX, double posY) {
            this.extension = extension;
            this.moveActor = moveActor;
            this.posX = posX;
            this.posY = posY;
        }

        public void invoke(long ms) {
            Ship ship = this.extension.getOwner();
            if (ship == null) {
                return;
            }
            double mx = ship.getX() + this.posX - this.extension.getX();
            double my = ship.getY() + this.posY - this.extension.getY();
            this.moveActor.move(mx, my);
        }
    }
}

