/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class KamikazeBehavior
extends Behavior {
    private ElementView view;
    private Element element;
    private SpeedBehavior speedBehavior;
    private double maxSpeed;
    private Element target = null;
    private List elements = new LinkedList();

    public KamikazeBehavior(ElementView view, Element element, SpeedBehavior speedBehavior, double maxSpeed) {
        this.setView(view);
        this.setElement(element);
        this.setSpeedBehavior(speedBehavior);
        this.setMaxSpeed(maxSpeed);
    }

    public void invoke(long ms) {
        if (this.target == null || this.target.getModel() == null) {
            this.setTarget(this.chooseTarget());
        } else {
            double ex = this.element.getX() + this.element.getWidth() / 2.0;
            double ey = this.element.getY() + this.element.getHeight() / 2.0;
            double tx = this.target.getX() + this.target.getWidth() / 2.0;
            double ty = this.target.getY() + this.target.getHeight() / 2.0;
            double atan = tx == ex ? Math.atan((ty - ey) / 1.0E-6) : Math.atan((ty - ey) / (tx - ex));
            atan = ex < tx ? 1.5707963267948966 - atan : 4.71238898038469 - atan;
            double spx = Math.sin(atan) * this.maxSpeed - this.speedBehavior.getSpeedX();
            double spy = Math.cos(atan) * this.maxSpeed - this.speedBehavior.getSpeedY();
            this.speedBehavior.incrementSpeedX(spx);
            this.speedBehavior.incrementSpeedY(spy);
        }
    }

    public SpeedBehavior getSpeedBehavior() {
        return this.speedBehavior;
    }

    public void setSpeedBehavior(SpeedBehavior speedBehavior) {
        this.speedBehavior = speedBehavior;
    }

    public Element getTarget() {
        return this.target;
    }

    public void setTarget(Element target) {
        this.target = target;
    }

    protected Element chooseTarget() {
        this.view.getElements((Collection)this.elements);
        CollisionGroup cg = this.element.getCollisionGroup();
        if (cg == null) {
            return null;
        }
        double ex = this.element.getX() + this.element.getWidth() / 2.0;
        double ey = this.element.getY() + this.element.getHeight() / 2.0;
        Element rc = null;
        double bestDist = 0.0;
        for (Element el : this.elements) {
            double dist = Math.abs(el.getX() + el.getWidth() / 2.0 - ex) + Math.abs(el.getY() + el.getHeight() / 2.0 - ey);
            if (rc != null && !(dist < bestDist) || !cg.isCollision(this.element, el)) continue;
            rc = el;
            bestDist = dist;
            if (!(bestDist < 40.0)) continue;
        }
        this.elements.clear();
        return rc;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public ElementView getView() {
        return this.view;
    }

    public void setView(ElementView view) {
        this.view = view;
    }
}

