/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.behavior.SpeedBehavior;

public class SpeedReduceBehavior
extends Behavior {
    private SpeedBehavior speedBehavior;
    private double nullSpeedX = 0.0;
    private double nullSpeedY = 0.0;
    private double speedReduction = 0.003;
    private boolean ignoreXReduction = false;
    private boolean ignoreYReduction = false;

    public SpeedReduceBehavior(SpeedBehavior behavior) {
        this.setSpeedBehavior(behavior);
    }

    public void invoke(long ms) {
        if (this.ignoreXReduction) {
            this.ignoreXReduction = false;
        } else {
            double speedX = this.speedBehavior.getSpeedX();
            if (speedX > this.nullSpeedX) {
                this.speedBehavior.setSpeedX(Math.max(this.nullSpeedX, speedX - this.speedReduction * (double)ms));
            } else {
                this.speedBehavior.setSpeedX(Math.min(this.nullSpeedX, speedX + this.speedReduction * (double)ms));
            }
        }
        if (this.ignoreYReduction) {
            this.ignoreYReduction = false;
        } else {
            double speedY = this.speedBehavior.getSpeedY();
            if (speedY > this.nullSpeedY) {
                this.speedBehavior.setSpeedY(Math.max(this.nullSpeedY, speedY - this.speedReduction * (double)ms));
            } else {
                this.speedBehavior.setSpeedY(Math.min(this.nullSpeedY, speedY + this.speedReduction * (double)ms));
            }
        }
    }

    public SpeedBehavior getSpeedBehavior() {
        return this.speedBehavior;
    }

    public void setSpeedBehavior(SpeedBehavior behavior) {
        this.speedBehavior = behavior;
    }

    public double getNullSpeedX() {
        return this.nullSpeedX;
    }

    public double getNullSpeedY() {
        return this.nullSpeedY;
    }

    public double getSpeedReduction() {
        return this.speedReduction;
    }

    public void setNullSpeedX(double d) {
        this.nullSpeedX = d;
    }

    public void setNullSpeedY(double d) {
        this.nullSpeedY = d;
    }

    public void setSpeedReduction(double d) {
        this.speedReduction = d;
    }
}

