/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.behavior;

import com.spacekiller.game2d.Behavior;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.behavior.PositionRotateBehavior;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.behavior.AbstractBossShipBehaviorType;
import java.util.ArrayList;

public class TestBossBehaviorType
extends AbstractBossShipBehaviorType {
    public TestBossBehaviorType(String id) {
        super(id);
        this.setMinActionInterval(30);
        this.setMaxActionInterval(150);
        this.setMinSpeed(0.1);
        this.setMaxSpeed(0.2);
    }

    @Override
    protected void setupMovementBehavior(Level level, ElementModel model, Ship ship, MoveActor moveActor) {
    }

    @Override
    protected AbstractBossShipBehaviorType.BossBehavior createBossBehavior(Level level, ElementView view, Ship ship, MoveActor moveActor) {
        return new TestBossBehavior(level, view, ship, moveActor);
    }

    protected class TestBossBehavior
    extends AbstractBossShipBehaviorType.BossBehavior {
        private ArrayList behaviors;

        public TestBossBehavior(Level level, ElementView view, Ship ship, MoveActor moveActor) {
            super(level, view, ship, moveActor);
            this.behaviors = new ArrayList();
            this.changeBossBehavior();
        }

        @Override
        public void changeBossBehavior() {
            this.behaviors.clear();
            int num = 1 + (int)(4.0 * Math.random());
            for (int c = 0; c < num; ++c) {
                PositionRotateBehavior action = new PositionRotateBehavior(this.getMoveActor());
                action.setSpeedX(0.02 * (Math.random() - 0.5));
                action.setSpeedY(0.02 * (Math.random() - 0.5));
                action.setRadiusX(200.0 * Math.random());
                action.setRadiusY(200.0 * Math.random());
                action.setAngleX(Math.random() * Math.PI);
                action.setAngleY(Math.random() * Math.PI);
                action.initRotation();
                this.behaviors.add(action);
            }
            Level level = this.getLevel();
            Ship ship = this.getShip();
            SpeedBehavior speed = ship.getSpeedBehavior();
            speed.setSpeedX(level.getScrollSpeedX() + (Math.random() - 0.5) * 0.5);
            speed.setSpeedY(level.getScrollSpeedY() + (Math.random() - 0.5) * 0.5);
        }

        public void invoke(long ms) {
            int num = this.behaviors.size();
            for (int c = 0; c < num; ++c) {
                ((Behavior)this.behaviors.get(c)).invoke(ms);
            }
        }
    }
}

