/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.input;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputBinder;
import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.InputMap;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.ButtonAxis1D;
import com.spacekiller.game2d.input.ButtonWheelAxis;
import com.spacekiller.game2d.input.DefaultInputMap;
import java.util.ArrayList;

public class DefaultSpaceKillerInputBinder
implements InputBinder {
    public InputMap bind(InputManager manager) throws Exception {
        InputAxis axisX;
        int num;
        DefaultInputMap map = new DefaultInputMap();
        InputController[] controllers = manager.getControllers();
        System.out.println("Number of input controllers: " + controllers.length);
        InputController keyboard = null;
        InputController mouse = null;
        InputController joystick = null;
        block5: for (int c = 0; c < controllers.length; ++c) {
            InputController ic = controllers[c];
            int type = ic.getType();
            switch (type) {
                case 1: {
                    keyboard = ic;
                    continue block5;
                }
                case 2: {
                    mouse = ic;
                    continue block5;
                }
                case 3: {
                    joystick = ic;
                }
            }
        }
        if (mouse != null) {
            num = mouse.getAxisCount();
            System.out.println("Mouse axes: " + num);
            axisX = mouse.getAxisAt(0);
            InputAxis axisY = mouse.getAxisAt(1);
            InputAxis wheel = mouse.getAxisAt(2);
            InputAxis button1 = mouse.getAxisAt(3);
            InputAxis button2 = num <= 4 ? null : mouse.getAxisAt(4);
            InputAxis button3 = num <= 5 ? null : mouse.getAxisAt(5);
            map.put((Object)"input.player1.moveX", new InputAxis[]{axisX});
            map.put((Object)"input.player1.moveY", new InputAxis[]{axisY});
            map.put((Object)"input.player1.switchWeapon", new InputAxis[]{wheel});
            map.put((Object)"input.player1.weapon1", new InputAxis[]{button1});
            map.put((Object)"input.player1.weapon2", new InputAxis[]{button3});
            map.put((Object)"input.player1.weapon3", new InputAxis[]{button2});
            return map;
        }
        if (keyboard != null) {
            num = keyboard.getAxisCount();
            System.out.println("Keyboard buttons: " + num);
            InputButton axisMoveRight = (InputButton)keyboard.getAxisForKey(39);
            InputButton axisMoveLeft = (InputButton)keyboard.getAxisForKey(37);
            InputButton axisMoveDown = (InputButton)keyboard.getAxisForKey(40);
            InputButton axisMoveUp = (InputButton)keyboard.getAxisForKey(38);
            float speed = 10.0f;
            ButtonAxis1D axisX2 = new ButtonAxis1D(keyboard, "Keyboard X-Axis", 2000, axisMoveLeft, axisMoveRight, speed);
            ButtonAxis1D axisY = new ButtonAxis1D(keyboard, "Keyboard Y-Axis", 2001, axisMoveUp, axisMoveDown, speed);
            InputButton axisShift = (InputButton)keyboard.getAxisForKey(16);
            InputButton axisMinus = (InputButton)keyboard.getAxisForKey(45);
            ButtonWheelAxis wheel = new ButtonWheelAxis(keyboard, "Keyboard wheel", 2020, axisShift, axisMinus);
            InputAxis button1 = keyboard.getAxisForKey(17);
            InputAxis button2 = keyboard.getAxisForKey(32);
            InputAxis button3 = keyboard.getAxisForKey(10);
            map.put((Object)"input.player1.moveX", new InputAxis[]{axisX2});
            map.put((Object)"input.player1.moveY", new InputAxis[]{axisY});
            map.put((Object)"input.player1.switchWeapon", new InputAxis[]{wheel});
            map.put((Object)"input.player1.weapon1", new InputAxis[]{button1});
            map.put((Object)"input.player1.weapon2", new InputAxis[]{button3});
            map.put((Object)"input.player1.weapon3", new InputAxis[]{button2});
            return map;
        }
        if (joystick != null) {
            num = joystick.getAxisCount();
            System.out.println("Joystick axes: " + num);
            axisX = null;
            InputAxis axisY = null;
            ArrayList<InputAxis> axisButtons = new ArrayList<InputAxis>();
            for (int c = 0; c < num; ++c) {
                InputAxis a = joystick.getAxisAt(c);
                int type = a.getType();
                if (type == 2000) {
                    axisX = a;
                    continue;
                }
                if (type == 2001) {
                    axisY = a;
                    continue;
                }
                if (type != 1000) continue;
                axisButtons.add(a);
            }
            if (axisX == null) {
                throw new Exception("Joystick X-Axis not found!");
            }
            if (axisY == null) {
                throw new Exception("Joystick Y-Axis not found!");
            }
            int numButtons = axisButtons.size();
            System.out.println("Joystick buttons: " + numButtons);
            InputButton button1 = numButtons > 0 ? (InputButton)axisButtons.get(0) : null;
            InputButton button2 = numButtons > 1 ? (InputButton)axisButtons.get(1) : null;
            InputButton button3 = numButtons > 2 ? (InputButton)axisButtons.get(2) : null;
            InputButton button4 = numButtons > 3 ? (InputButton)axisButtons.get(3) : null;
            InputButton button5 = numButtons > 4 ? (InputButton)axisButtons.get(4) : null;
            map.put((Object)"input.player1.moveX", new InputAxis[]{axisX});
            map.put((Object)"input.player1.moveY", new InputAxis[]{axisY});
            ButtonWheelAxis wheel = new ButtonWheelAxis(joystick, "Joystick wheel", 2020, button2, button3);
            map.put((Object)"input.player1.switchWeapon", new InputAxis[]{wheel});
            map.put((Object)"input.player1.weapon1", new InputAxis[]{button1});
            map.put((Object)"input.player1.weapon2", new InputAxis[]{button4});
            map.put((Object)"input.player1.weapon3", new InputAxis[]{button5});
            int numRumblers = joystick.getRumblerCount();
            if (numRumblers > 0) {
                Rumbler[] rumblers = new Rumbler[numRumblers];
                for (int c = 0; c < numRumblers; ++c) {
                    rumblers[c] = joystick.getRumblerAt(c);
                }
                map.put((Object)"input.player1.rumbler", rumblers);
            }
            return map;
        }
        throw new Exception("No input controller available!");
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getName() {
        return "Default SpaceKiller input binding";
    }

    public String toString() {
        return this.getName();
    }
}

