/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ImageRenderer;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.BehaviorTypeResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResource;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.spacekiller.AsteroidType;
import java.awt.Image;
import org.w3c.dom.Node;

public class AsteroidElementTypeResource
extends DefaultElementTypeResource {
    private double power;
    private BehaviorTypeResource behaviorTypeResource;
    private volatile transient AsteroidType asteroidType;

    public AsteroidElementTypeResource(String id, ResourceType type, ResourceRegistry resourceRegistry, Node resourceNode, String imageResourceId, double power, BehaviorTypeResource behaviorTypeResource) {
        super(id, type, resourceRegistry, resourceNode, imageResourceId);
        this.power = power;
        this.behaviorTypeResource = behaviorTypeResource;
    }

    protected ElementType createElementType() throws Exception {
        return this.getAsteroidType();
    }

    public AsteroidType getAsteroidType() throws Exception {
        if (this.asteroidType == null) {
            this.setAsteroidType(this.createAsteroidType());
        }
        return this.asteroidType;
    }

    protected void setAsteroidType(AsteroidType asteroidType) {
        this.asteroidType = asteroidType;
    }

    protected AsteroidType createAsteroidType() throws Exception {
        Resource imgRes;
        ImageResource imageResource = null;
        String imageResourceId = this.getImageResourceId();
        if (imageResourceId != null && (imgRes = this.getResourceRegistry().getResource(imageResourceId)) != null && imgRes instanceof ImageResource) {
            imageResource = (ImageResource)imgRes;
        }
        if (imageResource == null) {
            throw new RuntimeException("Image resource not found: " + imageResourceId);
        }
        Image image = imageResource.getImage();
        ImageRenderer renderer = new ImageRenderer(image);
        BehaviorType behaviorType = this.behaviorTypeResource == null ? null : this.behaviorTypeResource.getBehaviorType();
        CollisionBounds collisionBounds = ImageToolkit.getInstance().createCollisionBounds(image);
        AsteroidType type = this.createAsteroidType(this.getId(), image, collisionBounds, (Renderer)renderer, this.power, behaviorType);
        return type;
    }

    public void flush() throws Exception {
        super.flush();
        this.setAsteroidType(null);
    }

    protected AsteroidType createAsteroidType(String typeId, Image image, CollisionBounds collisionBounds, Renderer renderer, double power, BehaviorType behaviorType) throws Exception {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        return this.createAsteroidType(typeId, width, height, collisionBounds, renderer, power, behaviorType);
    }

    protected AsteroidType createAsteroidType(String typeId, int width, int height, CollisionBounds cb, Renderer renderer, double power, BehaviorType behaviorType) throws Exception {
        CollisionGroup cgroup = null;
        AsteroidType rc = new AsteroidType(typeId, renderer, width, height, cb, cgroup);
        rc.setGroup("Asteroid");
        rc.setBehaviorType(behaviorType);
        rc.setPower(power);
        return rc;
    }
}

