/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.resource.AnimationElementTypeResource;
import com.spacekiller.game2d.resource.AudioClipResource;
import com.spacekiller.spacekiller.BossExplosionTask;
import com.spacekiller.spacekiller.BossExplosionType;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.resource.BossExplosionTaskResource;
import com.spacekiller.spacekiller.resource.ExplosionTypeResource;
import java.util.ArrayList;
import javax.sound.sampled.Clip;

public class BossExplosionTypeResource
extends ExplosionTypeResource {
    private AnimationElementTypeResource animationTypeResource;
    private AudioClipResource audioClipResource;
    private long shipRemoveDelay;
    private ArrayList tasks = new ArrayList();
    private volatile transient BossExplosionType bossExplosionType;

    public BossExplosionTypeResource(String id, AnimationElementTypeResource animationTypeResource, AudioClipResource audioClipResource, long shipRemoveDelay) {
        super(id, animationTypeResource, audioClipResource, shipRemoveDelay);
        this.animationTypeResource = animationTypeResource;
        this.audioClipResource = audioClipResource;
        this.shipRemoveDelay = shipRemoveDelay;
    }

    public void addExplosionTask(BossExplosionTaskResource taskResource) {
        this.tasks.add(taskResource);
    }

    @Override
    public ExplosionType getExplosionType() throws Exception {
        return this.getBossExplosionType();
    }

    public BossExplosionType getBossExplosionType() throws Exception {
        if (this.bossExplosionType == null) {
            this.setBossExplosionType(this.createBossExplosionType());
        }
        return this.bossExplosionType;
    }

    protected void setBossExplosionType(BossExplosionType bossExplosionType) {
        this.bossExplosionType = bossExplosionType;
    }

    protected BossExplosionType createBossExplosionType() throws Exception {
        AnimationElementType aniType = this.animationTypeResource.getAnimationElementType();
        Clip clip = this.audioClipResource == null ? null : this.audioClipResource.getAudioClip();
        BossExplosionType bossExplosionType1 = new BossExplosionType(aniType, clip, this.shipRemoveDelay);
        int num = this.tasks.size();
        for (int c = 0; c < num; ++c) {
            BossExplosionTaskResource taskResource = (BossExplosionTaskResource)((Object)this.tasks.get(c));
            BossExplosionTask task = taskResource.getBossExplosionTask();
            if (task == null) continue;
            bossExplosionType1.addExplosionTask(task);
        }
        return bossExplosionType1;
    }

    @Override
    public void flush() throws Exception {
        super.flush();
        this.setBossExplosionType(null);
    }
}

