/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.AnimationImage;
import com.spacekiller.game2d.AnimationRenderer;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ImageRenderer;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AbstractElementTypeResource;
import com.spacekiller.game2d.resource.AnimationResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResourceType;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.spacekiller.weapons.BulletType;
import java.awt.Image;

public class BulletElementTypeResource
extends AbstractElementTypeResource {
    private Resource theResource;
    private volatile transient BulletType bulletType;
    private volatile transient AnimationElementType bulletHitAnimationType;

    public BulletElementTypeResource(String id, Resource theResource, AnimationElementType bulletHitAnimationType) {
        super(id, (ResourceType)DefaultElementTypeResourceType.getDefaultElementTypeResourceType());
        this.theResource = theResource;
        this.bulletHitAnimationType = bulletHitAnimationType;
    }

    protected ElementType createElementType() throws Exception {
        return this.getBulletType();
    }

    public BulletType getBulletType() throws Exception {
        if (this.bulletType == null) {
            this.setBulletType(this.createBulletType());
        }
        return this.bulletType;
    }

    protected void setBulletType(BulletType bulletType) {
        this.bulletType = bulletType;
    }

    protected BulletType createBulletType() throws Exception {
        BulletType bulletType = null;
        if (this.theResource instanceof ImageResource) {
            ImageResource imageResource = (ImageResource)this.theResource;
            Image image = imageResource.getImage();
            CollisionGroup collisionGroup = null;
            bulletType = this.createBulletType(this.getId(), image, collisionGroup);
        } else if (this.theResource instanceof AnimationResource) {
            AnimationResource animationResource = (AnimationResource)this.theResource;
            Animation ani = animationResource.getAnimation();
            CollisionGroup collisionGroup = null;
            bulletType = this.createBulletType(this.getId(), ani, collisionGroup);
        }
        return bulletType;
    }

    public void flush() throws Exception {
        super.flush();
        this.setBulletType(null);
    }

    protected BulletType createBulletType(String typeId, Image image, CollisionGroup collisionGroup) throws Exception {
        ImageRenderer renderer = new ImageRenderer(image);
        CollisionBounds bounds = ImageToolkit.getInstance().createCollisionBounds(image);
        BulletType rc = new BulletType(typeId, (Renderer)renderer, image.getWidth(null), image.getHeight(null), bounds, collisionGroup);
        rc.setGroup("Bullet");
        rc.setBulletHitAnimationType(this.getBulletHitAnimationType());
        return rc;
    }

    protected BulletType createBulletType(String typeId, Animation animation, CollisionGroup collisionGroup) throws Exception {
        AnimationRenderer renderer = new AnimationRenderer(animation, -1, false);
        double width = animation.getWidth();
        double height = animation.getHeight();
        int num = animation.getAnimationImageCount();
        AnimationImage aniImage = animation.getAnimationImageAt(num / 2);
        Image image = aniImage.getImage();
        CollisionBounds bounds = ImageToolkit.getInstance().createCollisionBounds(image);
        BulletType rc = new BulletType(typeId, (Renderer)renderer, width, height, bounds, collisionGroup);
        rc.setGroup("Bullet");
        rc.setBulletHitAnimationType(this.getBulletHitAnimationType());
        return rc;
    }

    public AnimationElementType getBulletHitAnimationType() {
        return this.bulletHitAnimationType;
    }

    protected void setBulletHitAnimationType(AnimationElementType bulletHitAnimationType) {
        this.bulletHitAnimationType = bulletHitAnimationType;
    }
}

