/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.AbstractResource;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AnimationElementTypeResource;
import com.spacekiller.game2d.resource.AudioClipResource;
import com.spacekiller.spacekiller.DefaultExplosionType;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.resource.ExplosionTypeResourceType;
import javax.sound.sampled.Clip;

public class ExplosionTypeResource
extends AbstractResource {
    private AnimationElementTypeResource animationTypeResource;
    private AudioClipResource audioClipResource;
    private long shipRemoveDelay;
    private volatile transient ExplosionType explosionType;

    public ExplosionTypeResource(String id, AnimationElementTypeResource animationTypeResource, AudioClipResource audioClipResource, long shipRemoveDelay) {
        super(id, (ResourceType)ExplosionTypeResourceType.getExplosionTypeResourceType());
        this.animationTypeResource = animationTypeResource;
        this.audioClipResource = audioClipResource;
        this.shipRemoveDelay = shipRemoveDelay;
    }

    public Object getObject() throws Exception {
        return this.getExplosionType();
    }

    public ExplosionType getExplosionType() throws Exception {
        if (this.explosionType == null) {
            this.setExplosionType(this.createExplosionType());
        }
        return this.explosionType;
    }

    protected void setExplosionType(ExplosionType explosionType) {
        this.explosionType = explosionType;
    }

    protected ExplosionType createExplosionType() throws Exception {
        AnimationElementType aniType = this.animationTypeResource.getAnimationElementType();
        Clip clip = this.audioClipResource == null ? null : this.audioClipResource.getAudioClip();
        DefaultExplosionType exp = new DefaultExplosionType(aniType, clip, this.shipRemoveDelay);
        return exp;
    }

    public void flush() throws Exception {
        this.setExplosionType(null);
    }
}

