/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AbstractElementTypeResource;
import com.spacekiller.game2d.resource.AnimationResource;
import com.spacekiller.game2d.resource.AudioClipResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResourceType;
import com.spacekiller.spacekiller.GadgetManager;
import com.spacekiller.spacekiller.GadgetType;
import java.awt.Rectangle;
import javax.sound.sampled.Clip;

public class GadgetElementTypeResource
extends AbstractElementTypeResource {
    private AnimationResource animationResource;
    private AudioClipResource audioClipResource;
    private GadgetManager gadgetManager;
    private volatile transient GadgetType gadgetType;

    public GadgetElementTypeResource(String id, AnimationResource animationResource, AudioClipResource audioClipResource, GadgetManager gadgetManager) {
        super(id, (ResourceType)DefaultElementTypeResourceType.getDefaultElementTypeResourceType());
        this.animationResource = animationResource;
        this.audioClipResource = audioClipResource;
        this.gadgetManager = gadgetManager;
    }

    protected ElementType createElementType() throws Exception {
        return this.getGadgetType();
    }

    public GadgetType getGadgetType() throws Exception {
        if (this.gadgetType == null) {
            this.setGadgetType(this.createGadgetType());
        }
        return this.gadgetType;
    }

    protected void setGadgetType(GadgetType gadgetType) {
        this.gadgetType = gadgetType;
    }

    protected GadgetType createGadgetType() throws Exception {
        Animation ani = this.animationResource.getAnimation();
        if (ani == null) {
            throw new RuntimeException("FIXME Animation is null: animationResource=" + this.animationResource);
        }
        Clip clip = this.audioClipResource == null ? null : this.audioClipResource.getAudioClip();
        GadgetType type = this.createGadgetType(this.getId(), ani, -1, true, null, this.gadgetManager, clip);
        return type;
    }

    public void flush() throws Exception {
        super.flush();
        this.setGadgetType(null);
    }

    protected GadgetType createGadgetType(String typeId, Animation ani, int loops, boolean autoDispose, CollisionGroup cg, GadgetManager gm, Clip audioClip) throws Exception {
        Rectangle rect = new Rectangle(0, 0, ani.getWidth(), ani.getHeight());
        CollisionBounds cb = new CollisionBounds(rect, new Rectangle[]{rect});
        GadgetType rc = new GadgetType(typeId, ani, loops, autoDispose, cb, cg, gm);
        rc.setAudioClip(audioClip);
        rc.setGroup("Gadget");
        return rc;
    }
}

