/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.spacekiller.resource.BulletElementTypeResource;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.LaserRenderer;
import com.spacekiller.spacekiller.weapons.LaserType;
import java.awt.Color;

public class LaserBulletElementTypeResource
extends BulletElementTypeResource {
    private Color laserColor;
    private volatile transient LaserType laserType;

    public LaserBulletElementTypeResource(String id, Color laserColor, AnimationElementType bulletHitAnimationType) {
        super(id, null, bulletHitAnimationType);
        this.setLaserColor(laserColor);
    }

    @Override
    protected BulletType createBulletType() throws Exception {
        return this.getLaserType();
    }

    public LaserType getLaserType() throws Exception {
        if (this.laserType == null) {
            this.setLaserType(this.createLaserType());
        }
        return this.laserType;
    }

    protected void setLaserType(LaserType laserType) {
        this.laserType = laserType;
    }

    protected LaserType createLaserType() throws Exception {
        CollisionGroup collisionGroup = null;
        LaserType laserType = this.createLaserType(this.getId(), collisionGroup, this.laserColor, this.getBulletHitAnimationType());
        return laserType;
    }

    protected LaserType createLaserType(String typeId, CollisionGroup collisionGroup, Color laserColor, AnimationElementType bulletHitAnimationType) throws Exception {
        CollisionBounds laserCollisionBounds = null;
        LaserRenderer renderer = new LaserRenderer();
        LaserType laserType = new LaserType(typeId, renderer, laserCollisionBounds, collisionGroup);
        laserType.setColor(laserColor);
        laserType.setBulletHitAnimationType(bulletHitAnimationType);
        return laserType;
    }

    public Color getLaserColor() {
        return this.laserColor;
    }

    protected void setLaserColor(Color laserColor) {
        this.laserColor = laserColor;
    }
}

