/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ImageRenderer;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AudioClipResource;
import com.spacekiller.game2d.resource.BehaviorTypeResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResource;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import com.spacekiller.spacekiller.ExplosionType;
import com.spacekiller.spacekiller.ShipType;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.resource.ExplosionTypeResource;
import com.spacekiller.spacekiller.resource.LevelResource;
import com.spacekiller.spacekiller.resource.WeaponTypeResource;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.sound.sampled.Clip;
import org.w3c.dom.Node;

public class ShipElementTypeResource
extends DefaultElementTypeResource
implements Cloneable {
    private int maxPower;
    private int maxShield;
    private int killScore;
    private boolean boss;
    private ExplosionTypeResource explosionTypeResource;
    private BehaviorTypeResource behaviorTypeResource;
    private WeaponSlot[] weaponSlots;
    private WeaponTypeResource[] weaponTypeResources;
    private double rotate = 0.0;
    private AudioClipResource alertClipResource;
    private volatile transient LevelResource levelResource;
    private volatile transient ShipType shipType;

    public ShipElementTypeResource(String id, ResourceType type, ResourceRegistry resourceRegistry, Node resourceNode, String imageResourceId, int maxPower, int maxShield, int killScore, ExplosionTypeResource explosionTypeResource, BehaviorTypeResource behaviorTypeResource, WeaponSlot[] weaponSlots, WeaponTypeResource[] weaponTypeResources, boolean boss, LevelResource levelResource) {
        super(id, type, resourceRegistry, resourceNode, imageResourceId);
        this.maxPower = maxPower;
        this.maxShield = maxShield;
        this.killScore = killScore;
        this.explosionTypeResource = explosionTypeResource;
        this.behaviorTypeResource = behaviorTypeResource;
        this.weaponSlots = weaponSlots;
        this.weaponTypeResources = weaponTypeResources;
        this.boss = boss;
        this.levelResource = levelResource;
    }

    protected ElementType createElementType() throws Exception {
        return this.getShipType();
    }

    public ShipType getShipType() throws Exception {
        if (this.shipType == null) {
            this.setShipType(this.createShipType());
        }
        return this.shipType;
    }

    protected void setShipType(ShipType shipType) {
        this.shipType = shipType;
    }

    protected ShipType createShipType() throws Exception {
        Clip clip;
        Resource imgRes;
        ImageResource imageResource = null;
        String imageResourceId = this.getImageResourceId();
        if (imageResourceId != null && (imgRes = this.getResourceRegistry().getResource(imageResourceId)) != null && imgRes instanceof ImageResource) {
            imageResource = (ImageResource)imgRes;
        }
        if (imageResource == null) {
            throw new RuntimeException("Image resource not found: " + imageResourceId);
        }
        Image image = imageResource.getImage();
        if (this.rotate != 0.0) {
            int srcw = image.getWidth(null);
            int srch = image.getHeight(null);
            image = ImageToolkit.getInstance().createRotatedImage(image, this.rotate);
            AffineTransform matrix = new AffineTransform();
            matrix.rotate(this.rotate);
            int dstw = image.getWidth(null);
            int dsth = image.getHeight(null);
            double[] srcPts = new double[2];
            double[] dstPts = new double[2];
            for (int c = 0; c < this.weaponSlots.length; ++c) {
                srcPts[0] = this.weaponSlots[c].getPosX() - (double)(srcw / 2);
                srcPts[1] = this.weaponSlots[c].getPosY() - (double)(srch / 2);
                matrix.transform(srcPts, 0, dstPts, 0, 1);
                this.weaponSlots[c].setPosX(dstPts[0] + (double)(dstw / 2));
                this.weaponSlots[c].setPosY(dstPts[1] + (double)(dsth / 2));
            }
        }
        ImageRenderer renderer = new ImageRenderer(image);
        ExplosionType explosionType = this.explosionTypeResource == null ? null : this.explosionTypeResource.getExplosionType();
        BehaviorType behaviorType = this.behaviorTypeResource == null ? null : this.behaviorTypeResource.getBehaviorType();
        CollisionBounds collisionBounds = ImageToolkit.getInstance().createCollisionBounds(image);
        CollisionGroup collisionGroup = null;
        ShipType type = this.createShipType(this.getId(), image, collisionBounds, collisionGroup, this.levelResource, (Renderer)renderer, this.maxPower, this.maxShield, this.killScore, explosionType, behaviorType, this.boss);
        type.setWeaponSlots(this.weaponSlots);
        int num = this.weaponTypeResources.length;
        WeaponType[] wTypes = new WeaponType[num];
        for (int c = 0; c < num; ++c) {
            wTypes[c] = this.weaponTypeResources[c].getWeaponType();
        }
        type.setWeaponTypes(wTypes);
        if (this.alertClipResource != null && (clip = this.alertClipResource.getAudioClip()) != null) {
            type.setAlertClip(clip);
        }
        return type;
    }

    public void flush() throws Exception {
        super.flush();
        this.setShipType(null);
    }

    public WeaponSlot[] getWeaponSlots() {
        return this.weaponSlots;
    }

    protected void setWeaponSlots(WeaponSlot[] weaponSlots) {
        this.weaponSlots = weaponSlots;
    }

    public WeaponTypeResource[] getWeaponTypeResources() {
        return this.weaponTypeResources;
    }

    public void setWeaponTypeResources(WeaponTypeResource[] weaponTypeResources) {
        this.weaponTypeResources = weaponTypeResources;
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    public ShipElementTypeResource createRotatedInstance(String id, double theta) throws Exception {
        ShipElementTypeResource clone = (ShipElementTypeResource)this.clone();
        clone.setId(id);
        WeaponSlot[] orig = clone.getWeaponSlots();
        WeaponSlot[] slots = new WeaponSlot[orig.length];
        for (int c = 0; c < orig.length; ++c) {
            WeaponSlot slot = orig[c];
            slots[c] = new WeaponSlot(slot.getShip(), slot.getPosX(), slot.getPosY());
        }
        clone.setWeaponSlots(slots);
        clone.setRotate(clone.getRotate() + theta);
        return clone;
    }

    public AudioClipResource getAlertClipResource() {
        return this.alertClipResource;
    }

    public void setAlertClipResource(AudioClipResource alertClipResource) {
        this.alertClipResource = alertClipResource;
    }

    protected ShipType createShipType(String typeId, Image image, CollisionBounds collisionBounds, CollisionGroup collisionGroup, LevelResource levelResource, Renderer renderer, int maxPower, int maxShield, int killScore, ExplosionType explosionType, BehaviorType behaviorType, boolean boss) throws Exception {
        ShipType rc = new ShipType(typeId, renderer, image.getWidth(null), image.getHeight(null), collisionBounds, collisionGroup, levelResource);
        rc.setGroup("SpaceShip");
        rc.setExplosionType(explosionType);
        rc.setBehaviorType(behaviorType);
        rc.setMaxPower(maxPower);
        rc.setMaxShield(maxShield);
        rc.setKillScore(killScore);
        rc.setBoss(boss);
        return rc;
    }

    public LevelResource getLevelResource() {
        return this.levelResource;
    }

    protected void setLevelResource(LevelResource levelResource) {
        this.levelResource = levelResource;
    }
}

