/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.AbstractResource;
import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.ext.sound.Mp3DecoderAudioSequence;
import com.spacekiller.game2d.ext.sound.Mp3Util;
import com.spacekiller.game2d.resource.BehaviorTypeResource;
import com.spacekiller.game2d.resource.DefaultAudioSequenceResourceType;
import com.spacekiller.game2d.resource.DefaultBehaviorTypeResource;
import com.spacekiller.game2d.resource.DefaultBehaviorTypeResourceType;
import com.spacekiller.game2d.resource.DefaultResourceProvider;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.FileAudioSequence;
import com.spacekiller.game2d.sound.PooledAudioSequence;
import com.spacekiller.spacekiller.LevelDescriptor;
import com.spacekiller.spacekiller.resource.LevelDescriptorResourceType;
import com.spacekiller.spacekiller.resource.LevelResource;
import com.spacekiller.spacekiller.resource.SpaceKillerResourceRegistry;
import java.io.File;
import java.net.URL;

public abstract class SpaceKillerResourceProvider
extends DefaultResourceProvider {
    private SpaceKillerResourceRegistry spaceRegistry;
    private Mp3Util mp3Util = new Mp3Util();
    private LevelResource levelResource;

    public SpaceKillerResourceRegistry getSpaceRegistry() {
        return this.spaceRegistry;
    }

    protected void setSpaceRegistry(SpaceKillerResourceRegistry spaceRegistry) {
        this.spaceRegistry = spaceRegistry;
    }

    public final void initialize() throws Exception {
        super.initialize();
        this.initializeSpaceProvider();
    }

    public void initializeSpaceProvider() throws Exception {
        this.initAudioClips();
        this.initAudioSequences();
        this.initImages();
        this.initElementTypes();
        this.initLevelDescriptors();
    }

    protected void initImages() throws Exception {
    }

    protected void initElementTypes() throws Exception {
    }

    protected void initAudioSequences() throws Exception {
    }

    protected void initAudioClips() throws Exception {
    }

    protected void initLevelDescriptors() throws Exception {
    }

    protected BehaviorTypeResource registerBehaviorType(BehaviorType bt) {
        DefaultBehaviorTypeResource res = new DefaultBehaviorTypeResource(bt.getId(), (ResourceType)DefaultBehaviorTypeResourceType.getDefaultBehaviorTypeResourceType(), bt);
        this.register((Resource)res);
        return res;
    }

    private Resource register(String key, ResourceType type, Object value) {
        DefaultResource resource = new DefaultResource(key, type, value);
        this.register((Resource)resource);
        return resource;
    }

    protected void register(Resource resource) {
        this.addResource(resource);
    }

    protected Resource registerAudioSequence(URL url, String wavFileName) {
        AudioBufferPool pool;
        FileAudioSequence fileSeq;
        File tempDir = this.getTempAudioDirectory();
        File wavFile = new File(tempDir, wavFileName);
        FileAudioSequence audioSeq = fileSeq = new FileAudioSequence(wavFile);
        if (!wavFile.exists()) {
            Mp3DecoderAudioSequence mp3Wrapper = new Mp3DecoderAudioSequence(url, this.mp3Util, wavFile, (AudioSequence)audioSeq);
            this.getSpaceRegistry().registerMp3DecoderAudioSequence(mp3Wrapper);
            audioSeq = mp3Wrapper;
        }
        if ((pool = this.getAudioBufferPool()) != null) {
            PooledAudioSequence pooledSeq = new PooledAudioSequence((AudioSequence)audioSeq, pool);
            audioSeq = pooledSeq;
        }
        this.debug("Registering AudioSequence: " + wavFileName + " = " + audioSeq);
        return this.register(wavFileName, (ResourceType)DefaultAudioSequenceResourceType.getAudioSequenceResourceType(), audioSeq);
    }

    protected Resource registerLevelDescriptor(LevelDescriptor levelDescr) {
        String id = levelDescr.getId();
        return this.register(id, (ResourceType)LevelDescriptorResourceType.getLevelDescriptorResourceType(), levelDescr);
    }

    public void setRegistry(ResourceRegistry registry) {
        super.setRegistry(registry);
        if (registry != null && registry instanceof SpaceKillerResourceRegistry) {
            this.setSpaceRegistry((SpaceKillerResourceRegistry)registry);
        }
    }

    public LevelResource getLevelResource() {
        return this.levelResource;
    }

    public void setLevelResource(LevelResource levelResource) {
        this.levelResource = levelResource;
    }

    protected static final class DefaultResource
    extends AbstractResource {
        private Object object;

        public DefaultResource(String id, ResourceType type, Object obj) {
            super(id, type);
            this.setObject(obj);
        }

        public void initialize() throws Exception {
        }

        public void flush() throws Exception {
        }

        public String toString() {
            try {
                return "Resource[id=" + this.getId() + ", object=" + this.getObject() + "]";
            }
            catch (Exception e) {
                return "Resource[id=" + this.getId() + ", " + e + "]";
            }
        }

        public Object getObject() {
            return this.object;
        }

        protected void setObject(Object object) {
            this.object = object;
        }
    }
}

