/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.resource;

import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.ext.sound.Mp3DecoderAudioSequence;
import com.spacekiller.game2d.resource.DefaultResourceRegistry;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.PooledAudioSequence;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.resource.LevelDescriptorResourceType;
import com.spacekiller.spacekiller.resource.WeaponTypeResourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioInputStream;

public class SpaceKillerResourceRegistry
extends DefaultResourceRegistry {
    private AudioBufferPool audioBufferPool;
    private File tempAudioDirectory;
    private List mp3DecoderAudioSequences;
    private boolean mp3DecoderEnabled;
    private byte[] tempAudioBuffer = null;

    public SpaceKillerResourceRegistry(AudioBufferPool audioBufferPool, File tempAudioDirectory) throws Exception {
        this.setTempAudioDirectory(tempAudioDirectory);
        this.setAudioBufferPool(audioBufferPool);
        this.mp3DecoderAudioSequences = new ArrayList();
        this.mp3DecoderEnabled = true;
    }

    protected AudioBufferPool getAudioBufferPool() {
        return this.audioBufferPool;
    }

    protected void setAudioBufferPool(AudioBufferPool audioBufferPool) {
        this.audioBufferPool = audioBufferPool;
    }

    protected File getTempAudioDirectory() {
        return this.tempAudioDirectory;
    }

    protected void setTempAudioDirectory(File tempAudioDirectory) {
        this.tempAudioDirectory = tempAudioDirectory;
    }

    public boolean isMp3DecoderEnabled() {
        return this.mp3DecoderEnabled;
    }

    public void setMp3DecoderEnabled(boolean mp3DecoderEnabled) {
        this.mp3DecoderEnabled = mp3DecoderEnabled;
        for (Mp3DecoderAudioSequence mp3Seq : this.mp3DecoderAudioSequences) {
            mp3Seq.setDecodeEnabled(mp3DecoderEnabled);
        }
    }

    public AudioSequence getAudioSequence(String key) throws Exception {
        AudioSequence seq;
        block10: {
            seq = super.getAudioSequence(key);
            try {
                AudioBufferPool pool;
                if (!this.mp3DecoderEnabled || seq == null) break block10;
                AudioSequence realSeq = seq;
                PooledAudioSequence pooled = null;
                if (realSeq instanceof PooledAudioSequence) {
                    pooled = (PooledAudioSequence)realSeq;
                    realSeq = pooled.getSequence();
                }
                if (realSeq instanceof Mp3DecoderAudioSequence) {
                    try {
                        Mp3DecoderAudioSequence mp3Seq = (Mp3DecoderAudioSequence)realSeq;
                        mp3Seq.reset();
                        AudioInputStream stream = mp3Seq.nextAudioInputStream();
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        return null;
                    }
                }
                if (pooled != null && (pool = this.getAudioBufferPool()) != null) {
                    if (pooled.buffer(this.getTempAudioBuffer())) {
                        System.out.println("Buffered sequence: " + pooled);
                    } else {
                        System.out.println("Failed to buffer sequence: " + pooled);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return seq;
    }

    protected void registerMp3DecoderAudioSequence(Mp3DecoderAudioSequence seq) {
        if (seq == null) {
            return;
        }
        this.mp3DecoderAudioSequences.add(seq);
    }

    protected byte[] createTempAudioBuffer() {
        return new byte[65536];
    }

    public byte[] getTempAudioBuffer() {
        if (this.tempAudioBuffer == null) {
            this.setTempAudioBuffer(this.createTempAudioBuffer());
        }
        return this.tempAudioBuffer;
    }

    public void setTempAudioBuffer(byte[] tempAudioBuffer) {
        this.tempAudioBuffer = tempAudioBuffer;
    }

    public void getLevelDescriptors(Collection dst) throws Exception {
        this.getObjects((ResourceType)LevelDescriptorResourceType.getLevelDescriptorResourceType(), dst);
    }

    public void getWeaponTypes(Collection dst) throws Exception {
        this.getObjects((ResourceType)WeaponTypeResourceType.getWeaponTypeResourceType(), dst);
    }

    public WeaponType getWeaponType(String key) throws Exception {
        return (WeaponType)this.getObject(key);
    }
}

