/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.ui;

import com.spacekiller.spacekiller.HighScore;
import com.spacekiller.spacekiller.HighScoreList;
import com.spacekiller.util.render.FontLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class HighScorePanel
extends JPanel {
    private static final long serialVersionUID = 1409091460038527098L;
    protected static final Color COLOR_GOLD = new Color(255, 235, 110);
    protected static final Color COLOR_SILVER = new Color(200, 209, 209);
    protected static final Color COLOR_BRONZE = new Color(210, 132, 42);
    protected static final Color COLOR_REST = new Color(180, 180, 180, 180);
    protected static final int COLUMN_POS = 0;
    protected static final int COLUMN_NAME = 1;
    protected static final int COLUMN_TIME = 2;
    protected static final int COLUMN_LEVEL = 3;
    protected static final int COLUMN_SCORE = 4;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private HighScoreList highScoreList;
    private List highlightScores;
    private JPanel jPanel = null;
    private FontLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;

    public HighScorePanel() {
        this.initialize();
        this.initHighScorePanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(645, 354));
        this.setBackground(new Color(84, 150, 238));
        this.add((Component)this.getJPanel(), gridBagConstraints3);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            this.jLabel = new FontLabel();
            this.jLabel.setOutlineWidth(1.5f);
            this.jLabel.setOutlineColor(Color.BLACK);
            this.jLabel.setFont(new Font("Under attack", 1, 36));
            this.jLabel.setText("High Scores:");
            this.jLabel.setForeground(Color.YELLOW);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBackground(new Color(68, 135, 238));
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.jLabel, gridBagConstraints1);
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setOpaque(false);
        }
        return this.jTable;
    }

    public void refreshHighScoreList() {
        ScoreTableModel model = new ScoreTableModel();
        model.addColumn("Pos.");
        model.addColumn("Name");
        model.addColumn("Date");
        model.addColumn("Level");
        model.addColumn("Score");
        int c = 0;
        Iterator i = this.highScoreList.getHighScores();
        while (i.hasNext()) {
            HighScore score = (HighScore)i.next();
            model.addRow(new Object[]{"" + ++c + ".", "" + score.getName(), "" + this.dateFormat.format(new Date(score.getTime())), "" + score.getLevel(), "" + score.getScore()});
        }
        this.getJTable().setModel(model);
    }

    protected HighScoreList getHighScoreList() {
        return this.highScoreList;
    }

    public void setHighScoreList(HighScoreList highScoreList) {
        this.highScoreList = highScoreList;
    }

    protected void initHighScorePanel() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        Font bestFont = new Font("Under attack", 1, 28);
        FontMetrics fm1 = this.getFontMetrics(bestFont);
        int bestFontHeight = fm1.getHeight();
        Font bestDateFont = new Font("Under attack", 1, 24);
        Font normalFont = new Font("Under attack", 1, 20);
        HighScoreTableCellRenderer cellRenderer = new HighScoreTableCellRenderer();
        cellRenderer.setBestFont(bestFont);
        cellRenderer.setBestDateFont(bestDateFont);
        cellRenderer.setNormalFont(normalFont);
        HighScoreTableCellRenderer headerRenderer = new HighScoreTableCellRenderer();
        headerRenderer.setBestFont(normalFont);
        headerRenderer.setBestDateFont(normalFont);
        headerRenderer.setNormalFont(normalFont);
        TableColumn col0 = new TableColumn(0);
        col0.setMinWidth(30);
        col0.setPreferredWidth(40);
        col0.setMaxWidth(50);
        col0.setHeaderValue(" # ");
        col0.setHeaderRenderer(headerRenderer);
        col0.setCellRenderer(cellRenderer);
        columnModel.addColumn(col0);
        TableColumn col1 = new TableColumn(1);
        col1.setHeaderValue("Name");
        col1.setPreferredWidth(190);
        col1.setHeaderRenderer(headerRenderer);
        col1.setCellRenderer(cellRenderer);
        columnModel.addColumn(col1);
        TableColumn col2 = new TableColumn(2);
        col2.setHeaderValue("Date");
        col2.setPreferredWidth(110);
        col2.setHeaderRenderer(headerRenderer);
        col2.setCellRenderer(cellRenderer);
        columnModel.addColumn(col2);
        TableColumn col3 = new TableColumn(3);
        col3.setHeaderValue("Level");
        col3.setPreferredWidth(40);
        col3.setHeaderRenderer(headerRenderer);
        col3.setCellRenderer(cellRenderer);
        columnModel.addColumn(col3);
        TableColumn col4 = new TableColumn(4);
        col4.setHeaderValue(" Score ");
        col4.setPreferredWidth(110);
        col4.setHeaderRenderer(headerRenderer);
        col4.setCellRenderer(cellRenderer);
        columnModel.addColumn(col4);
        this.getJTable().setAutoCreateColumnsFromModel(false);
        this.getJTable().setShowHorizontalLines(false);
        this.getJTable().setShowVerticalLines(false);
        this.getJTable().setColumnModel(columnModel);
        this.getJTable().setRowHeight(bestFontHeight);
    }

    public List getHighlightScores() {
        return this.highlightScores;
    }

    public void setHighlightScores(List highlightScores) {
        this.highlightScores = highlightScores;
    }

    protected class ScoreTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -4159290360853081675L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    protected class HighScoreTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1047426721368367274L;
        private Font bestFont;
        private Font bestDateFont;
        private Font normalFont;
        private Color textColor = COLOR_REST;
        private Color outlineColor = Color.DARK_GRAY;
        private Color bestTextColor = Color.WHITE;
        private Color bestOutlineColor = Color.BLACK;
        private Color highlightTextColor = Color.CYAN;
        private Color highlightOutlineColor = Color.BLACK;
        private FontLabel label = new FontLabel();

        protected HighScoreTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Font font = this.getNormalFont();
            Color fillColor = this.getTextColor();
            Color outlineColor = this.getOutlineColor();
            if (row < 3 && row >= 0) {
                font = column == 2 ? this.getBestDateFont() : this.getBestFont();
                switch (row) {
                    case 0: {
                        fillColor = COLOR_GOLD;
                        break;
                    }
                    case 1: {
                        fillColor = COLOR_SILVER;
                        break;
                    }
                    case 2: {
                        fillColor = COLOR_BRONZE;
                        break;
                    }
                    default: {
                        fillColor = this.getBestTextColor();
                    }
                }
                outlineColor = this.getBestOutlineColor();
            }
            HighScore highScore = null;
            if (row >= 0) {
                highScore = HighScorePanel.this.getHighScoreList().getHighScoreAt(row);
            }
            if (HighScorePanel.this.highlightScores != null && HighScorePanel.this.highlightScores.contains(highScore)) {
                fillColor = this.getHighlightTextColor();
                outlineColor = this.getHighlightOutlineColor();
            }
            String text = String.valueOf(value);
            this.label.setFont(font);
            this.label.setForeground(fillColor);
            this.label.setOutlineColor(outlineColor);
            this.label.setOutlineWidth(1.5f);
            int horizAlign = 2;
            switch (column) {
                case 0: 
                case 3: {
                    horizAlign = 0;
                    break;
                }
                case 4: {
                    horizAlign = 4;
                }
            }
            this.label.setHorizontalAlignment(horizAlign);
            this.label.setOpaque(false);
            this.label.setText(text);
            return this.label;
        }

        public Font getBestFont() {
            return this.bestFont;
        }

        public void setBestFont(Font bestFont) {
            this.bestFont = bestFont;
        }

        public Font getNormalFont() {
            return this.normalFont;
        }

        public void setNormalFont(Font normalFont) {
            this.normalFont = normalFont;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color outlineColor) {
            this.outlineColor = outlineColor;
        }

        public Color getHighlightTextColor() {
            return this.highlightTextColor;
        }

        public void setHighlightTextColor(Color highlightTextColor) {
            this.highlightTextColor = highlightTextColor;
        }

        public Color getHighlightOutlineColor() {
            return this.highlightOutlineColor;
        }

        public void setHighlightOutlineColor(Color highlightOutlineColor) {
            this.highlightOutlineColor = highlightOutlineColor;
        }

        public Color getBestTextColor() {
            return this.bestTextColor;
        }

        public void setBestTextColor(Color bestTextColor) {
            this.bestTextColor = bestTextColor;
        }

        public Color getBestOutlineColor() {
            return this.bestOutlineColor;
        }

        public void setBestOutlineColor(Color bestOutlineColor) {
            this.bestOutlineColor = bestOutlineColor;
        }

        public Font getBestDateFont() {
            return this.bestDateFont;
        }

        public void setBestDateFont(Font bestDateFont) {
            this.bestDateFont = bestDateFont;
        }
    }
}

