/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Clip;
import javax.swing.AbstractButton;

public class RolloverButtonSupport {
    private List buttons;
    private MouseHandler mouseHandler = new MouseHandler();
    private Clip audioClip;
    private Color foreground = Color.white;
    private Color rolloverForeground = Color.yellow;

    public RolloverButtonSupport() {
        this.buttons = new ArrayList();
    }

    public Clip getAudioClip() {
        return this.audioClip;
    }

    public void setAudioClip(Clip audioClip) {
        this.audioClip = audioClip;
    }

    public void addButton(AbstractButton button) {
        if (button != null) {
            this.buttons.add(button);
            button.setForeground(this.foreground);
            button.addMouseListener(this.mouseHandler);
        }
    }

    public void removeButton(AbstractButton button) {
        if (button != null && this.buttons.remove(button)) {
            button.removeMouseListener(this.mouseHandler);
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverForeground(Color rolloverForeground) {
        this.rolloverForeground = rolloverForeground;
    }

    public void refresh() {
        int num = this.buttons.size();
        for (int c = 0; c < num; ++c) {
            AbstractButton button = (AbstractButton)this.buttons.get(c);
            button.setForeground(this.foreground);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            Component comp = e.getComponent();
            if (comp instanceof AbstractButton) {
                AbstractButton button;
                button.setForeground((button = (AbstractButton)comp).isEnabled() ? RolloverButtonSupport.this.rolloverForeground : RolloverButtonSupport.this.foreground);
                Clip clip = RolloverButtonSupport.this.getAudioClip();
                if (clip != null) {
                    clip.start();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            Component comp = e.getComponent();
            if (comp instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)comp;
                button.setForeground(RolloverButtonSupport.this.foreground);
            }
        }
    }
}

