/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.ui;

import com.spacekiller.game2d.Engine;
import com.spacekiller.game2d.EngineListener;
import com.spacekiller.game2d.Game;
import com.spacekiller.game2d.Surface;
import com.spacekiller.spacekiller.ui.RolloverButtonSupport;
import com.spacekiller.util.render.FontButton;
import com.spacekiller.util.render.FontLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SpaceKillerEnginePanel
extends JPanel
implements EngineListener {
    private static final long serialVersionUID = 1605842981040058683L;
    private Game game;
    private Engine engine;
    private StatusRefresher statusRefresher = new StatusRefresher();
    private RolloverButtonSupport rollSupport;
    private FontButton jButtonStop = null;
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private FontButton jButtonPauseResume = null;
    private FontLabel lblEngineStatus;

    public SpaceKillerEnginePanel() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.weighty = 1.0;
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.gridy = 0;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints10.gridy = 0;
        gridBagConstraints10.gridx = 0;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.fill = 0;
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.gridx = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(588, 392));
        this.setBackground(new Color(137, 177, 238));
        this.add((Component)this.getJPanel6(), gridBagConstraints12);
        this.initSpaceKillerEnginePanel();
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            GridBagConstraints gbc_jButtonStop = new GridBagConstraints();
            gbc_jButtonStop.insets = new Insets(4, 4, 4, 4);
            gbc_jButtonStop.gridy = 1;
            gbc_jButtonStop.gridx = 0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 0;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.insets = new Insets(4, 4, 4, 4);
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new GridBagLayout());
            this.jPanel6.setOpaque(false);
            this.jPanel6.add((Component)this.getJPanel7(), gridBagConstraints15);
            this.jPanel6.add((Component)this.getJButtonStop(), gbc_jButtonStop);
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(3);
            gridLayout.setVgap(8);
            this.jPanel7 = new JPanel();
            this.jPanel7.setOpaque(false);
            this.jPanel7.setLayout(gridLayout);
            this.jPanel7.add((Component)this.getLblEngineStatus());
            this.jPanel7.add((Component)this.getJButtonPauseResume(), null);
        }
        return this.jPanel7;
    }

    private FontButton getJButtonPauseResume() {
        if (this.jButtonPauseResume == null) {
            this.jButtonPauseResume = new FontButton();
            this.jButtonPauseResume.setOutlineColor(Color.BLACK);
            this.jButtonPauseResume.setOutlineWidth(1.5f);
            this.jButtonPauseResume.setFont(new Font("Under attack", 1, 36));
            this.jButtonPauseResume.setOpaque(false);
            this.jButtonPauseResume.setText("Pause / Resume");
            this.jButtonPauseResume.setContentAreaFilled(false);
            this.jButtonPauseResume.setForeground(Color.white);
            this.jButtonPauseResume.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerEnginePanel.this.actionPauseResume();
                }
            });
        }
        return this.jButtonPauseResume;
    }

    private FontButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new FontButton();
            this.jButtonStop.setOutlineColor(Color.BLACK);
            this.jButtonStop.setOutlineWidth(1.5f);
            this.jButtonStop.setFont(new Font("Under attack", 1, 24));
            this.jButtonStop.setOpaque(false);
            this.jButtonStop.setText("Stop");
            this.jButtonStop.setContentAreaFilled(false);
            this.jButtonStop.setForeground(new Color(255, 120, 20));
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerEnginePanel.this.actionStop();
                }
            });
        }
        return this.jButtonStop;
    }

    protected void initSpaceKillerEnginePanel() {
        try {
            this.rollSupport = new RolloverButtonSupport();
            this.rollSupport.addButton((AbstractButton)this.getJButtonPauseResume());
            this.rollSupport.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FontLabel getLblEngineStatus() {
        if (this.lblEngineStatus == null) {
            this.lblEngineStatus = new FontLabel("Engine Status");
            this.lblEngineStatus.setOutlineColor(Color.BLACK);
            this.lblEngineStatus.setOutlineWidth(1.5f);
            this.lblEngineStatus.setHorizontalAlignment(0);
            this.lblEngineStatus.setFont(new Font("Under attack", 1, 24));
            this.lblEngineStatus.setForeground(Color.LIGHT_GRAY);
        }
        return this.lblEngineStatus;
    }

    public Game getGame() {
        return this.game;
    }

    public synchronized void setGame(Game game) {
        this.game = game;
        this.setEngine(game == null ? null : game.getEngine());
    }

    public Engine getEngine() {
        return this.engine;
    }

    public synchronized void setEngine(Engine engine) {
        Engine old = this.engine;
        if (engine == old) {
            return;
        }
        if (old != null) {
            old.removeEngineListener((EngineListener)this);
        }
        this.engine = engine;
        if (engine != null) {
            engine.addEngineListener((EngineListener)this);
            SwingUtilities.invokeLater(this.statusRefresher);
        }
    }

    public void engineStateChanged(Engine engine, int newState) {
        SwingUtilities.invokeLater(this.statusRefresher);
    }

    public void refreshStatus() {
        boolean running = false;
        boolean paused = false;
        Engine engine = this.getEngine();
        if (engine != null) {
            running = engine.isRunning();
            paused = engine.isPaused();
        }
        String status = "Stopped";
        if (running) {
            status = paused ? "Paused" : "Running";
        }
        this.getLblEngineStatus().setText(status);
        if (paused) {
            this.getJButtonPauseResume().setText("Resume");
        } else {
            this.getJButtonPauseResume().setText("Pause");
        }
    }

    protected void actionPauseResume() {
        Engine engine = this.getEngine();
        if (engine != null) {
            if (engine.isPaused()) {
                Game game = this.getGame();
                Surface surface = game.getSurface();
                Window window = surface.getWindow();
                if (window != null) {
                    window.setVisible(true);
                    window.toFront();
                    window.requestFocus();
                }
                engine.resume();
            } else {
                engine.pause();
            }
        }
    }

    protected void actionStop() {
        Engine engine = this.getEngine();
        if (engine != null) {
            engine.resume();
            engine.stop();
        }
    }

    protected class StatusRefresher
    implements Runnable {
        protected StatusRefresher() {
        }

        @Override
        public void run() {
            SpaceKillerEnginePanel.this.refreshStatus();
        }
    }
}

