/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.ui;

import com.spacekiller.game2d.DefaultGameConfig;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.Game;
import com.spacekiller.game2d.ui.DefaultGameConfigCustomizer;
import com.spacekiller.spacekiller.HighScore;
import com.spacekiller.spacekiller.HighScoreList;
import com.spacekiller.spacekiller.LevelDescriptor;
import com.spacekiller.spacekiller.SpaceKiller;
import com.spacekiller.spacekiller.SpaceKillerConstants;
import com.spacekiller.spacekiller.SpaceKillerGame;
import com.spacekiller.spacekiller.resource.SpaceKillerResourceRegistry;
import com.spacekiller.spacekiller.ui.BackPanel;
import com.spacekiller.spacekiller.ui.HighScorePanel;
import com.spacekiller.spacekiller.ui.RolloverButtonSupport;
import com.spacekiller.spacekiller.ui.SpaceKillerEnginePanel;
import com.spacekiller.spacekiller.ui.SpaceKillerOptionsPanel;
import com.spacekiller.spacekiller.ui.SpaceKillerPlayMenuPanel;
import com.spacekiller.spacekiller.ui.SpaceKillerPractisePanel;
import com.spacekiller.spacekiller.ui.SpaceKillerScoresPanel;
import com.spacekiller.util.render.FontButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SpaceKillerPanel
implements SpaceKillerConstants {
    private SpaceKiller spaceKiller;
    private RolloverButtonSupport rollSupport;
    private JPanel jContentPane = null;
    private FontButton jButtonPlay = null;
    private JPanel jPanel = null;
    private FontButton jButtonScores = null;
    private FontButton jButtonOptions = null;
    private JLabel jLabel = null;
    private JLabel jLabelHomeURL = null;
    private JPanel jPanel1 = null;
    private JLabel jLabelVersion = null;
    private FontButton jButtonIntro = null;
    private FontButton jButtonHelp = null;
    private JPanel jPanelCenter = null;
    private JPanel jPanelMainMenu = null;
    private FontButton jButtonAbout = null;
    private JPanel jPanelMain = null;
    private SpaceKillerOptionsPanel spaceKillerOptionsPanel = null;
    private SpaceKillerPlayMenuPanel spaceKillerPlayMenuPanel = null;
    private SpaceKillerPractisePanel spaceKillerPractisePanel = null;
    private SpaceKillerEnginePanel spaceKillerEnginePanel = null;
    private SpaceKillerScoresPanel spaceKillerScoresPanel = null;

    public SpaceKillerPanel() throws Exception {
        this.initSpaceKillerPanel();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new BackPanel();
            BackPanel back = (BackPanel)this.jContentPane;
            back.setImage(new ImageIcon(this.getClass().getResource("/com/spacekiller/spacekiller/images/doubleprom_soho_full.jpg")).getImage());
            GridBagConstraints consGridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
            consGridBagConstraints2.gridx = 0;
            consGridBagConstraints2.gridy = 1;
            consGridBagConstraints2.weightx = 1.0;
            consGridBagConstraints2.weighty = 1.0;
            consGridBagConstraints2.insets = new Insets(0, 20, 20, 20);
            consGridBagConstraints2.fill = 1;
            consGridBagConstraints5.gridx = 0;
            consGridBagConstraints5.gridy = 2;
            consGridBagConstraints5.fill = 1;
            consGridBagConstraints5.insets = new Insets(0, 20, 20, 20);
            consGridBagConstraints3.gridx = 0;
            consGridBagConstraints3.gridy = 0;
            consGridBagConstraints3.weightx = 1.0;
            consGridBagConstraints3.insets = new Insets(20, 20, 20, 20);
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJLabel(), consGridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanel1(), consGridBagConstraints5);
            this.jContentPane.add((Component)this.getJPanelCenter(), consGridBagConstraints2);
            this.jContentPane.setBackground(new Color(26, 31, 47));
        }
        return this.jContentPane;
    }

    private FontButton getJButtonPlay() {
        if (this.jButtonPlay == null) {
            this.jButtonPlay = new FontButton();
            this.jButtonPlay.setOutlineColor(Color.BLACK);
            this.jButtonPlay.setOutlineWidth(1.5f);
            this.jButtonPlay.setText("Play");
            this.jButtonPlay.setFont(new Font("Under attack", 1, 34));
            this.jButtonPlay.setOpaque(false);
            this.jButtonPlay.setContentAreaFilled(false);
            this.jButtonPlay.setForeground(Color.white);
            this.jButtonPlay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerPanel.this.actionShowPlayMenu();
                }
            });
        }
        return this.jButtonPlay;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            GridLayout layGridLayout1 = new GridLayout();
            layGridLayout1.setRows(6);
            layGridLayout1.setHgap(4);
            layGridLayout1.setVgap(4);
            layGridLayout1.setColumns(1);
            this.jPanel.setLayout(layGridLayout1);
            this.jPanel.add((Component)this.getJButtonIntro(), null);
            this.jPanel.add((Component)this.getJButtonPlay(), null);
            this.jPanel.add((Component)this.getJButtonScores(), null);
            this.jPanel.add((Component)this.getJButtonOptions(), null);
            this.jPanel.add((Component)this.getJButtonHelp(), null);
            this.jPanel.add((Component)this.getJButtonAbout(), null);
            this.jPanel.setOpaque(false);
        }
        return this.jPanel;
    }

    private FontButton getJButtonScores() {
        if (this.jButtonScores == null) {
            this.jButtonScores = new FontButton();
            this.jButtonScores.setOutlineColor(Color.BLACK);
            this.jButtonScores.setOutlineWidth(1.5f);
            this.jButtonScores.setText("Scores");
            this.jButtonScores.setFont(new Font("Under attack", 1, 34));
            this.jButtonScores.setEnabled(true);
            this.jButtonScores.setOpaque(false);
            this.jButtonScores.setContentAreaFilled(false);
            this.jButtonScores.setForeground(Color.white);
            this.jButtonScores.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerPanel.this.actionShowHighScores(null);
                }
            });
        }
        return this.jButtonScores;
    }

    private FontButton getJButtonOptions() {
        if (this.jButtonOptions == null) {
            this.jButtonOptions = new FontButton();
            this.jButtonOptions.setOutlineColor(Color.BLACK);
            this.jButtonOptions.setOutlineWidth(1.5f);
            this.jButtonOptions.setText("Options");
            this.jButtonOptions.setFont(new Font("Under attack", 1, 34));
            this.jButtonOptions.setOpaque(false);
            this.jButtonOptions.setContentAreaFilled(false);
            this.jButtonOptions.setForeground(Color.white);
            this.jButtonOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerPanel.this.actionShowOptions();
                }
            });
        }
        return this.jButtonOptions;
    }

    protected void actionShowOptions() {
        try {
            SpaceKiller killer = this.getSpaceKiller();
            Environment env = killer.getEnvironment();
            DefaultGameConfig origConfig = killer.getGameConfig();
            DefaultGameConfig cloneConfig = new DefaultGameConfig();
            Properties cloneProps = (Properties)origConfig.getProperties().clone();
            cloneConfig.setProperties(cloneProps);
            if (this.spaceKillerOptionsPanel == null) {
                this.spaceKillerOptionsPanel = new SpaceKillerOptionsPanel();
                this.spaceKillerOptionsPanel.setApplyAction(new ActionOptionsApply());
                this.spaceKillerOptionsPanel.setCancelAction(new ActionOptionsCancel());
            }
            DefaultGameConfigCustomizer customizer = this.spaceKillerOptionsPanel.getDefaultGameConfigCustomizer();
            customizer.setEnvironment(env);
            customizer.setGameConfig(cloneConfig);
            this.spaceKillerOptionsPanel.setOpaque(false);
            this.setCenterComponent(this.spaceKillerOptionsPanel);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void handleException(Throwable e) {
        System.err.println("Error occurred: " + new Date());
        e.printStackTrace(System.err);
        JFrame errorFrame = new JFrame("Error");
        JTextArea area = new JTextArea("" + e);
        area.setEditable(false);
        errorFrame.setContentPane(area);
        errorFrame.pack();
        errorFrame.setVisible(true);
    }

    protected void setCenterComponent(Component comp) {
        this.getJPanelCenter().removeAll();
        if (comp != null) {
            this.getJPanelCenter().add(comp);
        }
        this.getJPanelCenter().validate();
        this.getJPanelCenter().repaint();
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("");
            this.jLabel.setFont(new Font("TagsXtreme", 1, 70));
            this.jLabel.setForeground(new Color(255, 255, 221));
            this.jLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/spacekiller/images/spacekiller_logo04.GIF")));
        }
        return this.jLabel;
    }

    private JLabel getJLabelHomeURL() {
        if (this.jLabelHomeURL == null) {
            this.jLabelHomeURL = new JLabel();
            this.jLabelHomeURL.setText("spacekiller.com");
            this.jLabelHomeURL.setForeground(Color.yellow);
            this.jLabelHomeURL.setFont(new Font("dialog", 0, 12));
        }
        return this.jLabelHomeURL;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            GridBagConstraints consGridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints6 = new GridBagConstraints();
            consGridBagConstraints7.gridx = 0;
            consGridBagConstraints7.gridy = 0;
            consGridBagConstraints7.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints7.weightx = 1.0;
            consGridBagConstraints7.fill = 2;
            consGridBagConstraints6.gridx = 1;
            consGridBagConstraints6.gridy = 0;
            consGridBagConstraints6.ipadx = 0;
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJLabelHomeURL(), consGridBagConstraints6);
            this.jPanel1.add((Component)this.getJLabelVersion(), consGridBagConstraints7);
            this.jPanel1.setOpaque(false);
        }
        return this.jPanel1;
    }

    private JLabel getJLabelVersion() {
        if (this.jLabelVersion == null) {
            this.jLabelVersion = new JLabel();
            this.jLabelVersion.setText("Space Killer 0.0.0");
            this.jLabelVersion.setForeground(Color.yellow);
            this.jLabelVersion.setFont(new Font("dialog", 0, 12));
        }
        return this.jLabelVersion;
    }

    private FontButton getJButtonIntro() {
        if (this.jButtonIntro == null) {
            this.jButtonIntro = new FontButton();
            this.jButtonIntro.setOutlineColor(Color.BLACK);
            this.jButtonIntro.setOutlineWidth(1.5f);
            this.jButtonIntro.setText("Intro");
            this.jButtonIntro.setFont(new Font("Under attack", 1, 34));
            this.jButtonIntro.setEnabled(true);
            this.jButtonIntro.setOpaque(false);
            this.jButtonIntro.setContentAreaFilled(false);
            this.jButtonIntro.setForeground(Color.white);
            this.jButtonIntro.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpaceKillerPanel.this.actionShowIntro();
                }
            });
        }
        return this.jButtonIntro;
    }

    private FontButton getJButtonHelp() {
        if (this.jButtonHelp == null) {
            this.jButtonHelp = new FontButton();
            this.jButtonHelp.setOutlineColor(Color.BLACK);
            this.jButtonHelp.setOutlineWidth(1.5f);
            this.jButtonHelp.setText("Help");
            this.jButtonHelp.setFont(new Font("Under attack", 1, 34));
            this.jButtonHelp.setEnabled(false);
            this.jButtonHelp.setOpaque(false);
            this.jButtonHelp.setContentAreaFilled(false);
            this.jButtonHelp.setForeground(Color.white);
            this.jButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.jButtonHelp;
    }

    private JPanel getJPanelCenter() {
        if (this.jPanelCenter == null) {
            this.jPanelCenter = new JPanel();
            GridLayout layGridLayout11 = new GridLayout();
            layGridLayout11.setRows(1);
            this.jPanelCenter.setLayout(layGridLayout11);
            this.jPanelCenter.add((Component)this.getJPanelMainMenu(), null);
            this.jPanelCenter.setOpaque(false);
        }
        return this.jPanelCenter;
    }

    private JPanel getJPanelMainMenu() {
        if (this.jPanelMainMenu == null) {
            this.jPanelMainMenu = new JPanel();
            GridBagConstraints consGridBagConstraints32 = new GridBagConstraints();
            consGridBagConstraints32.gridx = 0;
            consGridBagConstraints32.gridy = 0;
            consGridBagConstraints32.insets = new Insets(0, 0, 0, 0);
            this.jPanelMainMenu.setLayout(new GridBagLayout());
            this.jPanelMainMenu.add((Component)this.getJPanel(), consGridBagConstraints32);
            this.jPanelMainMenu.setOpaque(false);
        }
        return this.jPanelMainMenu;
    }

    void loadConfig(InputStream in, Collection levelClassNames) throws Exception {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((s = reader.readLine()) != null) {
            int i;
            if (s.startsWith("#") || (s = s.trim()).length() < 1 || (i = s.indexOf("=")) < 0) continue;
            String key = s.substring(0, i).trim();
            String value = s.substring(i + 1).trim();
            if (key.equalsIgnoreCase("level")) {
                if (value.length() <= 0) continue;
                levelClassNames.add(value);
                continue;
            }
            throw new Exception("Invalid config entry: " + s);
        }
    }

    protected void startNewGame() {
        this.startNewGame(null);
    }

    protected void startNewGame(final LevelDescriptor practiseLevel) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SpaceKillerPanel.this.runNewGame(practiseLevel);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNewGame(LevelDescriptor practiseLevel) {
        Window skWindow;
        SpaceKiller killer = this.getSpaceKiller();
        JPanel contentPane = this.getSpaceKillerContentPane();
        if (contentPane != null && (skWindow = SwingUtilities.getWindowAncestor(contentPane)) != null) {
            Image iconImage;
            Rectangle winBounds = skWindow.getBounds();
            if (winBounds != null) {
                killer.setSpaceKillerWindowBounds(winBounds);
            }
            if (skWindow instanceof Frame && (iconImage = ((Frame)skWindow).getIconImage()) != null) {
                killer.setSpaceKillerIconImage(iconImage);
            }
        }
        ArrayList newHighScores = new ArrayList();
        try {
            SpaceKillerGame game = killer.createGame(practiseLevel);
            System.out.println("Game: " + game);
            this.actionShowEngineStatus(game);
            killer.runGame(game, newHighScores);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            if (this.spaceKillerEnginePanel != null) {
                this.spaceKillerEnginePanel.setGame(null);
            }
            if (newHighScores.isEmpty()) {
                this.actionShowPlayMenu();
                killer.startWelcomeSound();
            } else {
                HighScoreList highScoreList = killer.getHighScoreList();
                int bestPosition = -1;
                for (HighScore highScore : newHighScores) {
                    int pos = highScoreList.indexOf(highScore);
                    if (pos >= bestPosition && bestPosition >= 0) continue;
                    bestPosition = pos;
                }
                this.actionShowHighScores(newHighScores);
                int pos = bestPosition + 1;
                if (pos < 1) {
                    pos = 101;
                }
                killer.startHighscoreSound(pos);
            }
        }
    }

    protected Image createImage(String resource) {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        return icon.getImage();
    }

    protected BufferedImage createBufferedImage(Image img) {
        BufferedImage rc = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        rc.getGraphics().drawImage(img, 0, 0, null);
        return rc;
    }

    protected void initSpaceKillerPanel() throws Exception {
        try {
            this.rollSupport = new RolloverButtonSupport();
            this.rollSupport.addButton((AbstractButton)this.getJButtonIntro());
            this.rollSupport.addButton((AbstractButton)this.getJButtonPlay());
            this.rollSupport.addButton((AbstractButton)this.getJButtonScores());
            this.rollSupport.addButton((AbstractButton)this.getJButtonOptions());
            this.rollSupport.addButton((AbstractButton)this.getJButtonHelp());
            this.rollSupport.addButton((AbstractButton)this.getJButtonAbout());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String name = "SpaceKiller Cursor";
            Image cursorImage = new ImageIcon(this.getClass().getResource("/com/spacekiller/spacekiller/images/trident_cursor.gif")).getImage();
            Point hotSpot = new Point(0, 0);
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, hotSpot, name);
            this.getJContentPane().setCursor(cursor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FontButton getJButtonAbout() {
        if (this.jButtonAbout == null) {
            this.jButtonAbout = new FontButton();
            this.jButtonAbout.setOutlineColor(Color.BLACK);
            this.jButtonAbout.setOutlineWidth(1.5f);
            this.jButtonAbout.setText("About");
            this.jButtonAbout.setEnabled(false);
            this.jButtonAbout.setFont(new Font("Under attack", 1, 34));
            this.jButtonAbout.setOpaque(false);
            this.jButtonAbout.setContentAreaFilled(false);
            this.jButtonAbout.setForeground(Color.white);
        }
        return this.jButtonAbout;
    }

    protected void action_Exit() {
        System.exit(0);
    }

    protected void applyOptions() {
        try {
            DefaultGameConfigCustomizer customizer = this.spaceKillerOptionsPanel.getDefaultGameConfigCustomizer();
            DefaultGameConfig newGameConfig = customizer.getGameConfig();
            this.getSpaceKiller().setGameConfig(newGameConfig);
            this.getSpaceKiller().saveOptions();
            this.actionShowMainMenu();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void actionShowHighScores(List highlight) {
        HighScoreList highScoreList = this.getSpaceKiller().getHighScoreList();
        if (this.spaceKillerScoresPanel == null) {
            this.spaceKillerScoresPanel = new SpaceKillerScoresPanel();
            this.spaceKillerScoresPanel.setBackAction(new ActionScoresBack());
        }
        this.spaceKillerScoresPanel.setOpaque(false);
        HighScorePanel panel = this.spaceKillerScoresPanel.getHighScorePanel();
        panel.setHighScoreList(highScoreList);
        panel.refreshHighScoreList();
        panel.setHighlightScores(highlight);
        this.setCenterComponent(this.spaceKillerScoresPanel);
    }

    protected void actionShowMainMenu() {
        this.setCenterComponent(this.getJPanelMainMenu());
        if (this.rollSupport != null) {
            this.rollSupport.refresh();
        }
    }

    protected void actionShowPlayMenu() {
        if (this.spaceKillerPlayMenuPanel == null) {
            this.spaceKillerPlayMenuPanel = new SpaceKillerPlayMenuPanel();
            this.spaceKillerPlayMenuPanel.setStartAction(new ActionPlayMenuStart());
            this.spaceKillerPlayMenuPanel.setPractiseAction(new ActionPlayPractiseMenu());
            this.spaceKillerPlayMenuPanel.setBackAction(new ActionPlayMenuBack());
        }
        this.spaceKillerPlayMenuPanel.setOpaque(false);
        this.setCenterComponent(this.spaceKillerPlayMenuPanel);
    }

    protected void actionShowPractiseMenu() {
        List<LevelDescriptor> levels = new ArrayList<LevelDescriptor>();
        try {
            SpaceKillerResourceRegistry reg = this.getSpaceKiller().getResourceRegistry();
            reg.getLevelDescriptors(levels);
            levels = this.getSpaceKiller().sortLevels(levels);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.spaceKillerPractisePanel == null) {
            this.spaceKillerPractisePanel = new SpaceKillerPractisePanel();
            this.spaceKillerPractisePanel.setPlayAction(new ActionPractisePlay());
            this.spaceKillerPractisePanel.setBackAction(new ActionPractiseBack());
        }
        this.spaceKillerPractisePanel.setLevels(levels);
        this.spaceKillerPractisePanel.setOpaque(false);
        this.setCenterComponent(this.spaceKillerPractisePanel);
    }

    public JPanel getSpaceKillerContentPane() {
        return this.getJPanelMain();
    }

    public SpaceKiller getSpaceKiller() {
        return this.spaceKiller;
    }

    public void setSpaceKiller(SpaceKiller spaceKiller) {
        this.spaceKiller = spaceKiller;
        if (spaceKiller != null) {
            String spaceKillerTitle = spaceKiller.getSpaceKillerTitle();
            String spaceKillerVersion = spaceKiller.getSpaceKillerVersion();
            String spaceKillerHomeURL = spaceKiller.getSpaceKillerHomeURL();
            this.getJLabelVersion().setText(spaceKillerTitle + " " + spaceKillerVersion);
            this.getJLabelHomeURL().setText(spaceKillerHomeURL);
        }
    }

    protected void actionShowIntro() {
        String id = "intro";
        String name = "Space Killer";
        String className = "com.spacekiller.spacekiller.level.intro.IntroLevel";
        LevelDescriptor introLevelDescr = new LevelDescriptor(id, name, className);
        this.startNewGame(introLevelDescr);
    }

    private JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(gridLayout1);
            this.jPanelMain.setSize(new Dimension(746, 586));
            this.jPanelMain.add((Component)this.getJContentPane(), null);
        }
        return this.jPanelMain;
    }

    protected void actionShowEngineStatus(SpaceKillerGame game) {
        if (this.spaceKillerEnginePanel == null) {
            this.spaceKillerEnginePanel = new SpaceKillerEnginePanel();
        }
        this.spaceKillerEnginePanel.setGame((Game)game);
        this.spaceKillerEnginePanel.setOpaque(false);
        this.setCenterComponent(this.spaceKillerEnginePanel);
    }

    protected class ActionPlayMenuBack
    implements Runnable {
        protected ActionPlayMenuBack() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.actionShowMainMenu();
        }
    }

    protected class ActionPlayPractiseMenu
    implements Runnable {
        protected ActionPlayPractiseMenu() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.actionShowPractiseMenu();
        }
    }

    protected class ActionPlayMenuStart
    implements Runnable {
        protected ActionPlayMenuStart() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.startNewGame();
        }
    }

    protected class ActionScoresBack
    implements Runnable {
        protected ActionScoresBack() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.actionShowMainMenu();
        }
    }

    protected class ActionPractiseBack
    implements Runnable {
        protected ActionPractiseBack() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.actionShowPlayMenu();
        }
    }

    protected class ActionPractisePlay
    implements Runnable {
        protected ActionPractisePlay() {
        }

        @Override
        public void run() {
            LevelDescriptor levelDescr = SpaceKillerPanel.this.spaceKillerPractisePanel.getSelectedLevelDescriptor();
            if (levelDescr == null) {
                SpaceKillerPanel.this.actionShowPlayMenu();
            }
            SpaceKillerPanel.this.startNewGame(levelDescr);
        }
    }

    protected class ActionOptionsCancel
    implements Runnable {
        protected ActionOptionsCancel() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.actionShowMainMenu();
        }
    }

    protected class ActionOptionsApply
    implements Runnable {
        protected ActionOptionsApply() {
        }

        @Override
        public void run() {
            SpaceKillerPanel.this.applyOptions();
        }
    }
}

