/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.Gun;
import javax.sound.sampled.Clip;

public abstract class AbstractGun
extends Weapon
implements Gun {
    protected ElementType bulletElementType;
    protected Clip bulletAudioClip;
    protected long repeatDelay = 100L;
    protected double bulletPower = 50.0;
    protected double bulletStartX = 0.0;
    protected double bulletStartY = 0.0;
    protected double bulletSpeedX = 1.5;
    protected double bulletSpeedY = 0.0;
    protected boolean rotatable;
    protected double angle;
    protected double minAngle = 0.0;
    protected double maxAngle = Math.PI * 2;

    public AbstractGun(WeaponType type, Level level, Ship ship) {
        super(type, level, ship);
    }

    @Override
    public double getBulletSpeedX() {
        return this.bulletSpeedX;
    }

    public void setBulletSpeedX(double d) {
        this.bulletSpeedX = d;
    }

    @Override
    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(long l) {
        this.repeatDelay = l;
    }

    @Override
    public Clip getBulletAudioClip() {
        return this.bulletAudioClip;
    }

    public void setBulletAudioClip(Clip clip) {
        this.bulletAudioClip = clip;
    }

    @Override
    public ElementType getBulletElementType() {
        return this.bulletElementType;
    }

    public void setBulletElementType(ElementType type) {
        this.bulletElementType = type;
    }

    @Override
    public double getBulletPower() {
        return this.bulletPower;
    }

    public void setBulletPower(double i) {
        this.bulletPower = i;
    }

    @Override
    public double getBulletSpeedY() {
        return this.bulletSpeedY;
    }

    public void setBulletSpeedY(double bulletSpeedY) {
        this.bulletSpeedY = bulletSpeedY;
    }

    @Override
    public double getBulletStartX() {
        return this.bulletStartX;
    }

    public void setBulletStartX(double bulletStartX) {
        this.bulletStartX = bulletStartX;
    }

    @Override
    public double getBulletStartY() {
        return this.bulletStartY;
    }

    public void setBulletStartY(double bulletStartY) {
        this.bulletStartY = bulletStartY;
    }

    @Override
    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double angle) {
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle < this.minAngle) {
            angle = this.minAngle;
        }
        if (angle > this.maxAngle) {
            angle = this.maxAngle;
        }
        this.angle = angle;
    }

    @Override
    public double getMaxAngle() {
        return this.maxAngle;
    }

    @Override
    public void setMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
    }

    @Override
    public double getMinAngle() {
        return this.minAngle;
    }

    @Override
    public void setMinAngle(double minAngle) {
        this.minAngle = minAngle;
    }
}

