/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.DefaultElementType;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.Bullet;
import com.spacekiller.spacekiller.weapons.DefaultGun;

public class CascadeGun
extends DefaultGun {
    private Weapon childWeapon;
    private int childCount;
    private double angle;
    private double childSpeedX;
    private double childSpeedY;
    private double[] sin;
    private double[] cos;

    public CascadeGun(WeaponType type, Level level, Ship ship, Weapon childWeapon, int childCount, double angle, double speed) {
        super(type, level, ship);
        this.childWeapon = childWeapon;
        this.childCount = childCount;
        this.angle = angle;
        this.childSpeedX = speed;
        this.childSpeedY = speed;
        this.computeSinCos();
    }

    protected void computeSinCos() {
        this.sin = new double[this.childCount];
        this.cos = new double[this.childCount];
        double unit = Math.PI * 2 / (double)this.childCount;
        double v = this.angle;
        for (int c = 0; c < this.childCount; ++c) {
            this.sin[c] = Math.sin(v);
            this.cos[c] = Math.cos(v);
            v += unit;
        }
    }

    @Override
    protected void fire(Bullet bullet) {
        super.fire(bullet);
    }

    protected void cascade(Bullet bullet, Element e) {
        double x = bullet.getX();
        double y = bullet.getY();
        bullet.dispose();
        try {
            DefaultElementType bt = (DefaultElementType)this.getBulletElementType();
            CollisionGroup cg = bt.getCollisionGroup();
            CascadeCollisionGroup ccg = new CascadeCollisionGroup(cg, e);
            for (int c = 0; c < this.childCount; ++c) {
                Bullet b1 = this.createBullet("" + bullet.getId() + ">" + c, x + this.sin[c] * 10.0, y + this.cos[c] * 10.0, 1.0, 1.0);
                b1.setWeapon(this.childWeapon);
                b1.setCollisionGroup(ccg);
                MoveActor moveActor = new MoveActor((Element)b1);
                SpeedBehavior speedBehavior = new SpeedBehavior(moveActor);
                speedBehavior.setSpeedX(this.sin[c] * this.childSpeedX);
                speedBehavior.setSpeedY(this.cos[c] * this.childSpeedY);
                moveActor.addAction((Action)speedBehavior);
                this.level.addBullet(b1);
                this.level.addActor((Actor)moveActor);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void handleBulletCollision(Bullet b, Element e) {
        super.handleBulletCollision(b, e);
        this.cascade(b, e);
    }

    protected class CascadeCollisionGroup
    implements CollisionGroup {
        private CollisionGroup group;
        private Element excluded;

        public CascadeCollisionGroup(CollisionGroup group, Element excluded) {
            this.group = group;
            this.excluded = excluded;
        }

        public boolean isCollision(Element e, Element o) {
            if (o == this.excluded) {
                return false;
            }
            return this.group.isCollision(e, o);
        }

        public void handleCollision(Element e, Element o) {
            if (o != this.excluded) {
                this.group.handleCollision(e, o);
            }
        }
    }
}

