/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.game2d.Action;
import com.spacekiller.game2d.Actor;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.MoveActor;
import com.spacekiller.game2d.Renderer;
import com.spacekiller.game2d.behavior.SpeedBehavior;
import com.spacekiller.spacekiller.AbstractLevel;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.AbstractGun;
import com.spacekiller.spacekiller.weapons.Bullet;
import java.awt.geom.Point2D;

public class DefaultGun
extends AbstractGun {
    private boolean activate = false;
    private boolean gunActive = false;
    private long msRepDelay = 10000L;
    private long activeMs = 0L;
    private long msLastActive = 0L;
    private int relX = 0;
    private Point2D.Double slotPos = new Point2D.Double();

    public DefaultGun(WeaponType type, Level level, Ship ship) {
        super(type, level, ship);
    }

    protected Bullet createBullet(Object id, double x, double y, double w, double h) throws Exception {
        Bullet rc = (Bullet)this.bulletElementType.createElement(id, x, y, w, h);
        rc.setWeapon(this);
        return rc;
    }

    protected void fire() {
        if (this.bulletCount < 1) {
            this.uninstall();
            return;
        }
        if (this.ship.getPower() < this.bulletPower) {
            return;
        }
        this.ship.incrementPower(Math.min(0.0, -this.bulletPower));
        try {
            if (this.bulletAudioClip != null && this.level.isEffectEnabled(AbstractLevel.EFFECT_AUDIO_BULLETS)) {
                this.level.playAudioClip(this.bulletAudioClip, this.ship);
            }
            this.slot.getPosition(this.slotPos);
            double bulletX = this.slotPos.x + this.bulletStartX;
            double bulletY = this.slotPos.y + this.bulletStartY;
            Bullet bullet = this.createBullet("" + this + "-Bullet#" + this.bulletCount, bulletX, bulletY, 1.0, 1.0);
            --this.bulletCount;
            this.fire(bullet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void fire(Bullet bullet) {
        MoveActor moveActor = new MoveActor((Element)bullet);
        SpeedBehavior speedBehavior = new SpeedBehavior(moveActor);
        double sx = this.bulletSpeedX;
        double sy = this.bulletSpeedY;
        if (this.rotatable) {
            double s = Math.abs(sx) + Math.abs(sy);
            sx = Math.sin(this.angle) * s;
            sy = Math.cos(this.angle) * s;
        }
        speedBehavior.setSpeedX(sx);
        speedBehavior.setSpeedY(sy);
        moveActor.addAction((Action)speedBehavior);
        this.level.addBullet(bullet);
        this.level.addActor((Actor)moveActor);
        Renderer renderer = bullet.getRenderer();
        if (renderer instanceof Action) {
            moveActor.addAction((Action)renderer);
        }
    }

    @Override
    public void setActive(boolean b) {
        if (b) {
            this.activate = true;
        }
        super.setActive(b);
    }

    @Override
    protected void weaponActivated() {
        long ms;
        if (this.msLastActive > 0L && (ms = this.level.getMillis() - this.msLastActive) > 0L) {
            this.msRepDelay += ms;
        }
        this.level.addActor(this);
    }

    @Override
    protected void weaponDeactivated() {
        this.msLastActive = this.level.getMillis();
    }

    public void invoke(long ms) {
        if (!this.gunActive) {
            if (this.active || this.activate) {
                this.gunActive = true;
                this.msRepDelay = this.repeatDelay;
                this.activeMs = 0L;
                this.relX = 0;
            } else {
                return;
            }
        }
        if (this.gunActive) {
            if (!this.active && !this.activate) {
                this.activeMs = 0L;
                this.dispose();
                return;
            }
            this.activate = false;
            this.msRepDelay += ms;
            if (this.msRepDelay >= this.repeatDelay) {
                this.fire();
                this.activeMs += this.msRepDelay;
                this.msRepDelay = 0L;
            }
        }
    }
}

