/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Rect;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.BulletType;
import com.spacekiller.spacekiller.weapons.Emp;
import com.spacekiller.spacekiller.weapons.EmpRenderer;
import java.awt.Color;
import java.awt.Rectangle;
import javax.sound.sampled.Clip;

public class EmpGenerator
extends Weapon {
    private Emp emp;
    private BulletType empType;
    private EmpRenderer empRenderer;
    private CollisionGroup collisionGroup;
    private boolean empActive = false;
    private boolean empFire = false;
    private Color[] col = new Color[32];
    private int colIndex = 0;
    private int colDelay = 15;
    private int colMs = 0;
    private int speed = 2;
    private Clip empAudioClip;

    public EmpGenerator(WeaponType type, Level level, Ship ship) throws Exception {
        super(type, level, ship);
    }

    public void initialize() throws Exception {
        int surfaceW = this.level.getSurface().getWidth();
        int surfaceH = this.level.getSurface().getHeight();
        this.empRenderer = new EmpRenderer();
        this.empRenderer.setX(surfaceW / 2);
        this.empRenderer.setY(surfaceH / 2);
        Rectangle empBounds = new Rectangle(0, 0, surfaceW, surfaceH);
        CollisionBounds empCollisionBounds = new CollisionBounds(empBounds, new Rectangle[]{empBounds});
        this.empType = new BulletType("", this.empRenderer, surfaceW, surfaceH, empCollisionBounds, this.collisionGroup);
        this.emp = new Emp("emp@" + (Object)((Object)this), 0.0, 0.0, surfaceW, surfaceH, (ElementType)this.empType, this.empRenderer);
        this.emp.setWeapon(this);
        this.emp.setCollisionBounds(empCollisionBounds);
        this.emp.setCollisionGroup(this.getCollisionGroup());
        this.setColor(new Color(210, 210, 255));
    }

    @Override
    protected void weaponActivated() {
        if (!this.empActive) {
            this.empActive = true;
            this.getLevel().addActor(this);
        }
    }

    @Override
    protected void weaponDeactivated() {
    }

    public void invoke(long ms) {
        if (!this.empFire) {
            if (!this.empActive) {
                return;
            }
            if (this.active) {
                if (this.bulletCount < 1) {
                    this.uninstall();
                    return;
                }
                --this.bulletCount;
                if (this.empAudioClip != null) {
                    this.level.playAudioClip(this.empAudioClip, this.emp);
                }
                this.empFire = true;
                this.colIndex = 0;
                this.speed = 2;
                this.emp.setSize(5);
                this.emp.setColor(this.col[0]);
                this.level.addBullet(this.emp);
                ElementModel model = this.level.getElementModel();
                ElementView view = this.level.getElementView();
                Rect viewRect = view.getViewRect();
                model.update((Element)this.emp, viewRect.getX(), viewRect.getY(), viewRect.getWidth(), viewRect.getHeight());
                this.empRenderer.setX((int)(this.ship.getX() + this.ship.getWidth() / 2.0 - viewRect.getX()));
                this.empRenderer.setY((int)(this.ship.getY() + this.ship.getHeight() / 2.0 - viewRect.getY()));
            }
        }
        double size = (long)(this.emp.getSize() + 1) + (long)this.speed * ms;
        this.colMs = (int)((long)this.colMs + ms);
        if (this.colMs >= this.colDelay) {
            this.colMs = 0;
            ++this.colIndex;
            if (this.colIndex >= this.col.length) {
                this.colIndex = this.col.length - 1;
            }
            this.emp.setColor(this.col[this.colIndex]);
        }
        if (size < 2000.0) {
            this.emp.setSize((int)size);
        } else {
            this.empFire = false;
            if (!this.isActive()) {
                this.colIndex = 0;
                this.level.removeBullet(this.emp);
                this.empActive = false;
                this.dispose();
            }
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int i) {
        this.speed = i;
    }

    public void setColor(Color color) {
        for (int c = 0; c < this.col.length; ++c) {
            this.col[c] = new Color(color.getRed() * (this.col.length - c) / this.col.length, color.getGreen() * (this.col.length - c) / this.col.length, color.getBlue() * (this.col.length - c) / this.col.length);
        }
    }

    public Clip getEmpAudioClip() {
        return this.empAudioClip;
    }

    public void setEmpAudioClip(Clip clip) {
        this.empAudioClip = clip;
    }

    public CollisionGroup getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(CollisionGroup collisionGroup) {
        this.collisionGroup = collisionGroup;
    }
}

