/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.Element;
import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.WeaponType;
import com.spacekiller.spacekiller.weapons.AbstractGun;
import com.spacekiller.spacekiller.weapons.Laser;
import com.spacekiller.spacekiller.weapons.LaserType;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.sound.sampled.Clip;

public class LaserGun
extends AbstractGun {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    private Laser laser;
    private CollisionGroup collisionGroup;
    private int direction = 1;
    private boolean laserActive = false;
    private boolean laserFire = false;
    private Clip laserAudioClip;
    private AnimationElementType laserHitType;
    private Element laserHitElement;
    private Point2D.Double slotPos = new Point2D.Double();

    public LaserGun(WeaponType type, Level level, Ship ship) {
        super(type, level, ship);
    }

    public void initialize() throws Exception {
        int surfaceW = this.level.getSurface().getWidth();
        int surfaceH = this.level.getSurface().getHeight();
        Rectangle laserBounds = null;
        switch (this.direction) {
            case 1: {
                laserBounds = new Rectangle(0, 0, surfaceW, 3);
                break;
            }
            case 0: {
                laserBounds = new Rectangle(0, 0, surfaceW, 3);
                break;
            }
            case 2: {
                laserBounds = new Rectangle(0, 0, 3, surfaceH);
                break;
            }
            case 3: {
                laserBounds = new Rectangle(0, 0, 3, surfaceH);
                break;
            }
            default: {
                throw new Exception("Invalid laser direction: " + this.direction);
            }
        }
        this.laser = (Laser)this.bulletElementType.createElement((Object)("laser@" + this), 0.0, 0.0, laserBounds.getWidth(), laserBounds.getHeight());
        this.laser.setWeapon(this);
        this.laser.setCollisionBounds(null);
        this.laser.setCollisionGroup(null);
    }

    @Override
    protected void weaponActivated() {
        if (!this.laserActive) {
            this.laserActive = true;
            this.getLevel().addActor(this);
        }
    }

    @Override
    protected void weaponDeactivated() {
    }

    public void invoke(long ms) {
        double laserPower = this.bulletPower * (double)ms;
        double shipPower = this.ship.getPower();
        if (!this.laserFire && this.active && shipPower >= laserPower) {
            if (this.laserAudioClip != null && !this.laserAudioClip.isRunning()) {
                this.laserAudioClip.setFramePosition(0);
                this.laserAudioClip.loop(-1);
            }
            this.laserFire = true;
            this.level.addBullet(this.laser);
            ms = 0L;
        }
        if (this.active) {
            if (shipPower < laserPower || this.bulletCount < 1) {
                if (this.laserFire) {
                    if (this.laserAudioClip != null && this.laserAudioClip.isRunning()) {
                        this.laserAudioClip.loop(0);
                    }
                    this.laserFire = false;
                    this.level.removeBullet(this.laser);
                }
                if (this.bulletCount < 1) {
                    this.uninstall();
                }
            } else {
                this.bulletCount = (int)((long)this.bulletCount - ms);
                if (this.bulletCount < 0) {
                    this.bulletCount = 0;
                }
                this.ship.incrementPower(Math.min(0.0, -laserPower));
                this.slot.getPosition(this.slotPos);
                double laserX = this.slotPos.x + this.bulletStartX;
                double laserY = this.slotPos.y + this.bulletStartY;
                switch (this.direction) {
                    case 1: 
                    case 3: {
                        this.level.getElementModel().moveTo((Element)this.laser, laserX, laserY);
                        break;
                    }
                    case 0: {
                        this.level.getElementModel().moveTo((Element)this.laser, laserX - this.laser.getWidth(), laserY);
                        break;
                    }
                    case 2: {
                        this.level.getElementModel().moveTo((Element)this.laser, laserX, laserY - this.laser.getHeight());
                    }
                }
                this.level.fireLaser(this, ms);
            }
        } else {
            if (this.laserAudioClip != null && this.laserAudioClip.isRunning()) {
                this.laserAudioClip.loop(0);
            }
            this.laserActive = false;
            this.laserFire = false;
            this.level.removeBullet(this.laser);
            this.dispose();
        }
    }

    public void validate() {
    }

    public Clip getLaserAudioClip() {
        return this.laserAudioClip;
    }

    public void setLaserAudioClip(Clip clip) {
        this.laserAudioClip = clip;
    }

    public CollisionGroup getCollisionGroup() {
        return this.collisionGroup;
    }

    public void setCollisionGroup(CollisionGroup collisionGroup) {
        this.collisionGroup = collisionGroup;
    }

    public Laser getLaser() {
        return this.laser;
    }

    public void setLaser(Laser laser) {
        this.laser = laser;
    }

    public LaserType getLaserType() {
        return (LaserType)this.bulletElementType;
    }

    public Element getLaserHitElement() {
        return this.laserHitElement;
    }

    protected void setLaserHitElement(Element laserHitElement) {
        this.laserHitElement = laserHitElement;
    }

    public AnimationElementType getLaserHitType() {
        return this.laserHitType;
    }

    public void setLaserHitType(AnimationElementType laserHitType) throws Exception {
        this.laserHitType = laserHitType;
        this.initLaserHitElement();
    }

    protected void initLaserHitElement() throws Exception {
        this.laserHitElement = null;
        if (this.laserHitType != null) {
            this.laserHitElement = this.laserHitType.createElement((Object)("@" + this), 0.0, 0.0, 1.0, 1.0);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

