/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.spacekiller.weapons;

import com.spacekiller.spacekiller.Level;
import com.spacekiller.spacekiller.Ship;
import com.spacekiller.spacekiller.Weapon;
import com.spacekiller.spacekiller.WeaponSlot;
import com.spacekiller.spacekiller.WeaponType;
import java.util.List;

public class Multiplexer
extends Weapon {
    private List weapons;
    private double multiplexPower;
    private int msSinceLastFire;

    public Multiplexer(WeaponType type, Level level, Ship ship, List weapons, double multiplexPower) {
        super(type, level, ship);
        this.weapons = weapons;
        this.setMultiplexPower(multiplexPower);
    }

    @Override
    protected void weaponActivated() {
        this.level.addActor(this);
    }

    @Override
    protected void weaponDeactivated() {
        this.dispose();
    }

    public void invoke(long ms) {
        this.msSinceLastFire = (int)((long)this.msSinceLastFire + ms);
        if (this.bulletCount < 1) {
            this.uninstall();
            return;
        }
        if (this.ship.getPower() >= this.multiplexPower) {
            int count = this.weapons.size();
            for (int c = 0; c < count; ++c) {
                Weapon w = (Weapon)((Object)this.weapons.get(c));
                w.setActive(true);
                w.invoke(this.msSinceLastFire);
                w.setActive(false);
                this.level.removeActor(w);
            }
            this.msSinceLastFire = 0;
            --this.bulletCount;
        }
    }

    public double getMultiplexPower() {
        return this.multiplexPower;
    }

    public void setMultiplexPower(double i) {
        this.multiplexPower = i;
    }

    @Override
    public void setSlot(WeaponSlot slot) {
        super.setSlot(slot);
        int count = this.weapons.size();
        for (int c = 0; c < count; ++c) {
            ((Weapon)((Object)this.weapons.get(c))).setSlot(slot);
        }
    }

    public int getWeaponCount() {
        return this.weapons.size();
    }

    public Weapon getWeaponAt(int i) {
        return (Weapon)((Object)this.weapons.get(i));
    }

    @Override
    public void setBulletCount(int bulletCount) {
        super.setBulletCount(bulletCount);
        int count = this.weapons.size();
        for (int c = 0; c < count; ++c) {
            ((Weapon)((Object)this.weapons.get(c))).setBulletCount(bulletCount);
        }
    }
}

