/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.Data;
import com.spacekiller.util.buffer.Position;
import com.spacekiller.util.buffer.UTFBuffer;
import java.io.DataInput;
import java.io.IOException;

public abstract class AbstractDataInput
implements DataInput,
Position {
    protected byte[] b;
    protected int bo;
    protected int bs;
    protected UTFBuffer utf = new UTFBuffer();

    @Override
    public int position() {
        return this.bo;
    }

    public void close() throws IOException {
        this.b = null;
        this.bo = 0;
        this.bs = 0;
    }

    protected abstract void stream(int var1) throws IOException;

    @Override
    public boolean readBoolean() throws IOException {
        if (this.bo >= this.bs) {
            this.stream(1);
        }
        return Data.getBoolean((byte[])this.b, (int)this.bo++);
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bo >= this.bs) {
            this.stream(1);
        }
        return this.b[this.bo++];
    }

    @Override
    public char readChar() throws IOException {
        if (this.bo + 2 > this.bs) {
            this.stream(2);
        }
        char rc = Data.getChar((byte[])this.b, (int)this.bo);
        this.bo += 2;
        return rc;
    }

    @Override
    public double readDouble() throws IOException {
        if (this.bo + 8 > this.bs) {
            this.stream(8);
        }
        double rc = Data.getDouble((byte[])this.b, (int)this.bo);
        this.bo += 8;
        return rc;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.bo + 4 > this.bs) {
            this.stream(4);
        }
        float rc = Data.getFloat((byte[])this.b, (int)this.bo);
        this.bo += 4;
        return rc;
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        if (this.bo + len > this.bs) {
            this.stream(len);
        }
        System.arraycopy(this.b, this.bo, buf, off, len);
        this.bo += len;
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public int readInt() throws IOException {
        if (this.bo + 4 > this.bs) {
            this.stream(4);
        }
        int rc = Data.getInt((byte[])this.b, (int)this.bo);
        this.bo += 4;
        return rc;
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public long readLong() throws IOException {
        if (this.bo + 8 > this.bs) {
            this.stream(8);
        }
        long rc = Data.getLong((byte[])this.b, (int)this.bo);
        this.bo += 8;
        return rc;
    }

    @Override
    public short readShort() throws IOException {
        if (this.bo + 2 > this.bs) {
            this.stream(2);
        }
        short rc = Data.getShort((byte[])this.b, (int)this.bo);
        this.bo += 2;
        return rc;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.bo >= this.bs) {
            this.stream(1);
        }
        return this.b[this.bo++] & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.bo + 2 > this.bs) {
            this.stream(2);
        }
        char rc = Data.getChar((byte[])this.b, (int)this.bo);
        this.bo += 2;
        return rc;
    }

    @Override
    public String readUTF() throws IOException {
        char utfLen;
        if (this.bo + 2 > this.bs) {
            this.stream(2);
        }
        if (this.bo + (utfLen = this.readChar()) > this.bs) {
            this.stream(utfLen);
        }
        StringBuffer sbuf = new StringBuffer();
        UTFBuffer.readUTF(this.b, this.bo, sbuf, utfLen);
        this.bo += utfLen;
        return sbuf.toString();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.bo + n > this.bs) {
            this.stream(n);
        }
        this.bo += n;
        return n;
    }
}

