/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.buffer;

import com.spacekiller.util.Data;
import com.spacekiller.util.buffer.UTFBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;

public abstract class ObjBuf
implements ObjectInput,
ObjectOutput {
    private byte[] buf;
    private int len = 0;
    private int pos = 0;
    protected UTFBuffer utf;

    public ObjBuf(int initSize) {
        if (initSize > 0) {
            this.buf = new byte[initSize];
            this.len = this.buf.length;
        }
        this.utf = new UTFBuffer();
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void setBuffer(byte[] b, int ofs, int len) {
        this.buf = b;
        this.pos = ofs;
        this.len = ofs + len;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    public int position() {
        return this.pos;
    }

    public void position(int p) {
        this.pos = p;
    }

    public int capacity() {
        return this.len;
    }

    protected void resize(int newSize) {
        byte[] old = this.buf;
        this.buf = new byte[Math.max(this.len * 2, newSize)];
        System.arraycopy(old, 0, this.buf, 0, this.pos);
        this.len = this.buf.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.pos + len > this.len) {
            this.resize(this.pos + len);
        }
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= this.len) {
            this.resize(this.pos + 1);
        }
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.pos >= this.len) {
            this.resize(this.pos + 1);
        }
        Data.setBoolean((byte[])this.buf, (int)this.pos++, (boolean)v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.pos >= this.len) {
            this.resize(this.pos + 1);
        }
        this.buf[this.pos++] = (byte)v;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.pos + 2 > this.len) {
            this.resize(this.pos + 2);
        }
        Data.setChar((byte[])this.buf, (int)this.pos, (char)((char)v));
        this.pos += 2;
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.pos + 8 > this.len) {
            this.resize(this.pos + 8);
        }
        Data.setDouble((byte[])this.buf, (int)this.pos, (double)v);
        this.pos += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.pos + 4 > this.len) {
            this.resize(this.pos + 4);
        }
        Data.setFloat((byte[])this.buf, (int)this.pos, (float)v);
        this.pos += 4;
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.pos + 4 > this.len) {
            this.resize(this.pos + 4);
        }
        Data.setInt((byte[])this.buf, (int)this.pos, (int)v);
        this.pos += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.pos + 8 > this.len) {
            this.resize(this.pos + 8);
        }
        Data.setLong((byte[])this.buf, (int)this.pos, (long)v);
        this.pos += 8;
    }

    public void writeId(long v) throws IOException {
        if (this.pos + 8 > this.len) {
            this.resize(this.pos + 8);
        }
        Data.setLong((byte[])this.buf, (int)this.pos, (long)v);
        this.pos += 8;
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.pos + 2 > this.len) {
            this.resize(this.pos + 2);
        }
        Data.setShort((byte[])this.buf, (int)this.pos, (short)((short)v));
        this.pos += 2;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int utflen = (int)this.utf.getUTFLength(s);
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeChar(utflen);
        if (this.pos + utflen > this.len) {
            this.resize(this.pos + utflen);
        }
        this.utf.writeUTF(s, this.buf, this.pos);
        this.pos += utflen;
    }

    @Override
    public int available() throws IOException {
        return this.len - this.pos;
    }

    @Override
    public int read() throws IOException {
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readFully(b, off, len);
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return Data.getBoolean((byte[])this.buf, (int)this.pos++);
    }

    @Override
    public byte readByte() throws IOException {
        return this.buf[this.pos++];
    }

    @Override
    public char readChar() throws IOException {
        char v = Data.getChar((byte[])this.buf, (int)this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public double readDouble() throws IOException {
        double v = Data.getDouble((byte[])this.buf, (int)this.pos);
        this.pos += 8;
        return v;
    }

    @Override
    public float readFloat() throws IOException {
        float v = Data.getFloat((byte[])this.buf, (int)this.pos);
        this.pos += 4;
        return v;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public int readInt() throws IOException {
        int v = Data.getInt((byte[])this.buf, (int)this.pos);
        this.pos += 4;
        return v;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        long v = Data.getLong((byte[])this.buf, (int)this.pos);
        this.pos += 8;
        return v;
    }

    public long readId() throws IOException {
        long v = Data.getLong((byte[])this.buf, (int)this.pos);
        this.pos += 8;
        return v;
    }

    @Override
    public short readShort() throws IOException {
        short v = Data.getShort((byte[])this.buf, (int)this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        char v = Data.getChar((byte[])this.buf, (int)this.pos);
        this.pos += 2;
        return v;
    }

    @Override
    public String readUTF() throws IOException {
        char utflen = this.readChar();
        StringBuffer sbuf = new StringBuffer();
        UTFBuffer.readUTF(this.buf, this.pos, sbuf, utflen);
        this.pos += utflen;
        return sbuf.toString();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }
}

