/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.editor;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Model;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.config.DefaultPersistenceManager;
import com.spacekiller.game2d.config.PersistenceManager;
import com.spacekiller.game2d.editor.DefaultElementClipboard;
import com.spacekiller.game2d.editor.ElementClipboard;
import com.spacekiller.game2d.editor.ModelEditor;
import com.spacekiller.game2d.resource.DefaultResourceRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GameEditor
extends JFrame {
    private DefaultResourceRegistry registry;
    private PersistenceManager persistenceManager;
    private ArrayList elementTypes;
    private ElementClipboard clipboard;
    private File currentDirectory;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenu = null;
    private JScrollPane jScrollPane = null;
    private JTabbedPane jTabbedPane = null;
    private JMenuItem jMenuItem = null;
    private JMenuItem jMenuItem1 = null;
    private JMenuItem jMenuItem2 = null;
    private JMenuItem jMenuItem3 = null;
    private JMenu jMenu1 = null;
    private JMenu jMenu2 = null;
    private JMenuItem jMenuItem4 = null;
    private JMenuItem jMenuItem5 = null;
    private JMenuItem jMenuItem6 = null;
    private JPanel jContentPane1 = null;
    private JDialog jDialogResizeModel = null;
    private JPanel jPanel = null;
    private JTextField jTextFieldModelWidth = null;
    private JTextField jTextFieldModelHeight = null;
    private JTextField jTextFieldGridColumns = null;
    private JTextField jTextFieldGridRows = null;
    private JTextField jTextFieldCellWidth = null;
    private JTextField jTextFieldCellHeight = null;
    private JPanel jPanel1 = null;
    private JButton jButton = null;
    private JButton jButton1 = null;

    private JMenu getJMenu1() {
        if (this.jMenu1 == null) {
            this.jMenu1 = new JMenu();
            this.jMenu1.setText("Edit");
            this.jMenu1.add(this.getJMenuItem4());
        }
        return this.jMenu1;
    }

    private JMenu getJMenu2() {
        if (this.jMenu2 == null) {
            this.jMenu2 = new JMenu();
            this.jMenu2.setText("Help");
            this.jMenu2.add(this.getJMenuItem5());
        }
        return this.jMenu2;
    }

    private JMenuItem getJMenuItem4() {
        if (this.jMenuItem4 == null) {
            this.jMenuItem4 = new JMenuItem();
            this.jMenuItem4.setText("Resize model..");
            this.jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_Edit_ResizeModel();
                }
            });
        }
        return this.jMenuItem4;
    }

    private JMenuItem getJMenuItem5() {
        if (this.jMenuItem5 == null) {
            this.jMenuItem5 = new JMenuItem();
            this.jMenuItem5.setText("About");
            this.jMenuItem5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_Help_About();
                }
            });
        }
        return this.jMenuItem5;
    }

    private JMenuItem getJMenuItem6() {
        if (this.jMenuItem6 == null) {
            this.jMenuItem6 = new JMenuItem();
            this.jMenuItem6.setText("Close");
            this.jMenuItem6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_File_Close();
                }
            });
        }
        return this.jMenuItem6;
    }

    private JPanel getJContentPane1() {
        if (this.jContentPane1 == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            this.jContentPane1 = new JPanel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            this.jContentPane1.setLayout(new GridBagLayout());
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.anchor = 13;
            this.jContentPane1.add((Component)this.getJPanel(), gridBagConstraints1);
            this.jContentPane1.add((Component)this.getJPanel1(), gridBagConstraints14);
        }
        return this.jContentPane1;
    }

    private JDialog getJDialogResizeModel() {
        if (this.jDialogResizeModel == null) {
            this.jDialogResizeModel = new JDialog();
            this.jDialogResizeModel.setContentPane(this.getJContentPane1());
            this.jDialogResizeModel.setSize(345, 229);
            this.jDialogResizeModel.setTitle("Resize Model");
        }
        return this.jDialogResizeModel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            JLabel jLabel5 = new JLabel();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            JLabel jLabel4 = new JLabel();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            JLabel jLabel3 = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel1 = new JLabel();
            JLabel jLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel.setText("Grid columns:");
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            jLabel1.setText("Grid rows:");
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            jLabel2.setText("Cell height:");
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            jLabel3.setText("Cell width:");
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            jLabel4.setText("Model width:");
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            jLabel5.setText("Model height:");
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 3;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 4;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 5;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.insets = new Insets(0, 0, 0, 4);
            this.jPanel.add((Component)jLabel, gridBagConstraints6);
            this.jPanel.add((Component)jLabel1, gridBagConstraints2);
            this.jPanel.add((Component)jLabel2, gridBagConstraints3);
            this.jPanel.add((Component)jLabel3, gridBagConstraints4);
            this.jPanel.add((Component)jLabel4, gridBagConstraints5);
            this.jPanel.add((Component)jLabel5, gridBagConstraints7);
            this.jPanel.add((Component)this.getJTextFieldModelWidth(), gridBagConstraints8);
            this.jPanel.add((Component)this.getJTextFieldModelHeight(), gridBagConstraints9);
            this.jPanel.add((Component)this.getJTextFieldGridColumns(), gridBagConstraints10);
            this.jPanel.add((Component)this.getJTextFieldGridRows(), gridBagConstraints11);
            this.jPanel.add((Component)this.getJTextFieldCellWidth(), gridBagConstraints12);
            this.jPanel.add((Component)this.getJTextFieldCellHeight(), gridBagConstraints13);
        }
        return this.jPanel;
    }

    private JTextField getJTextFieldModelWidth() {
        if (this.jTextFieldModelWidth == null) {
            this.jTextFieldModelWidth = new JTextField();
            this.jTextFieldModelWidth.setColumns(8);
            this.jTextFieldModelWidth.getDocument().addDocumentListener(new DocAdapter(){

                @Override
                protected void handle(DocumentEvent e) {
                    try {
                        int modelWidth = Integer.parseInt(GameEditor.this.jTextFieldModelWidth.getText());
                        int cellWidth = Integer.parseInt(GameEditor.this.jTextFieldCellWidth.getText());
                        int gridCols = (modelWidth - 1) / cellWidth + 1;
                        GameEditor.this.jTextFieldGridColumns.setText("" + gridCols);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jTextFieldModelWidth;
    }

    private JTextField getJTextFieldModelHeight() {
        if (this.jTextFieldModelHeight == null) {
            this.jTextFieldModelHeight = new JTextField();
            this.jTextFieldModelHeight.getDocument().addDocumentListener(new DocAdapter(){

                @Override
                protected void handle(DocumentEvent e) {
                    try {
                        int modelHeight = Integer.parseInt(GameEditor.this.jTextFieldModelHeight.getText());
                        int cellHeight = Integer.parseInt(GameEditor.this.jTextFieldCellHeight.getText());
                        int gridRows = (modelHeight - 1) / cellHeight + 1;
                        GameEditor.this.jTextFieldGridRows.setText("" + gridRows);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jTextFieldModelHeight;
    }

    private JTextField getJTextFieldGridColumns() {
        if (this.jTextFieldGridColumns == null) {
            this.jTextFieldGridColumns = new JTextField();
        }
        return this.jTextFieldGridColumns;
    }

    private JTextField getJTextFieldGridRows() {
        if (this.jTextFieldGridRows == null) {
            this.jTextFieldGridRows = new JTextField();
        }
        return this.jTextFieldGridRows;
    }

    private JTextField getJTextFieldCellWidth() {
        if (this.jTextFieldCellWidth == null) {
            this.jTextFieldCellWidth = new JTextField();
        }
        return this.jTextFieldCellWidth;
    }

    private JTextField getJTextFieldCellHeight() {
        if (this.jTextFieldCellHeight == null) {
            this.jTextFieldCellHeight = new JTextField();
        }
        return this.jTextFieldCellHeight;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            gridBagConstraints15.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.insets = new Insets(4, 0, 4, 4);
            this.jPanel1.add((Component)this.getJButton(), gridBagConstraints15);
            this.jPanel1.add((Component)this.getJButton1(), gridBagConstraints16);
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Apply");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.applyResizeModelDialog();
                    GameEditor.this.jDialogResizeModel.dispose();
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Cancel");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.jDialogResizeModel.dispose();
                }
            });
        }
        return this.jButton1;
    }

    public static void main(String[] args) {
        final GameEditor editor = new GameEditor();
        editor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.out.println("windowClosed()");
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("windowClosing()");
                editor.dispose();
            }
        });
        editor.setVisible(true);
    }

    public GameEditor() {
        this.initialize();
        this.initGameEditor();
    }

    private void initialize() {
        this.setSize(616, 452);
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJJMenuBar());
        this.setTitle("Roomclan 2D-Game Editor");
    }

    protected void initGameEditor() {
        this.refreshElementTypes();
        File currDir = new File(".").getAbsoluteFile();
        this.setCurrentDirectory(currDir);
    }

    protected void refreshElementTypes() {
        try {
            this.elementTypes = new ArrayList();
            this.getRegistry().getElementTypes((Collection)this.elementTypes);
            Component[] comps = this.getJTabbedPane().getComponents();
            for (int c = 0; c < comps.length; ++c) {
                if (!(comps[c] instanceof ModelEditor)) continue;
                ModelEditor editor = (ModelEditor)comps[c];
                editor.setElementTypes(this.elementTypes);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJMenu());
            this.jJMenuBar.add(this.getJMenu1());
            this.jJMenuBar.add(this.getJMenu2());
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
            this.jMenu.add(this.getJMenuItem());
            this.jMenu.add(this.getJMenuItem1());
            this.jMenu.add(this.getJMenuItem2());
            this.jMenu.add(this.getJMenuItem3());
            this.jMenu.setText("File");
            this.jMenu.add(this.getJMenuItem6());
        }
        return this.jMenu;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    System.out.println("stateChanged()");
                }
            });
        }
        return this.jTabbedPane;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItem == null) {
            this.jMenuItem = new JMenuItem();
            this.jMenuItem.setText("New");
            this.jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/newfile_wiz.gif")));
            this.jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_File_New();
                }
            });
        }
        return this.jMenuItem;
    }

    private JMenuItem getJMenuItem1() {
        if (this.jMenuItem1 == null) {
            this.jMenuItem1 = new JMenuItem();
            this.jMenuItem1.setText("Open");
            this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/open.gif")));
            this.jMenuItem1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_File_Open();
                }
            });
        }
        return this.jMenuItem1;
    }

    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText("Save");
            this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/save.gif")));
            this.jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_File_Save();
                }
            });
        }
        return this.jMenuItem2;
    }

    private JMenuItem getJMenuItem3() {
        if (this.jMenuItem3 == null) {
            this.jMenuItem3 = new JMenuItem();
            this.jMenuItem3.setText("Save as..");
            this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/save.gif")));
            this.jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GameEditor.this.action_File_SaveAs();
                }
            });
        }
        return this.jMenuItem3;
    }

    public PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.setPersistenceManager(this.createPersistenceManager());
        }
        return this.persistenceManager;
    }

    protected PersistenceManager createPersistenceManager() {
        return new DefaultPersistenceManager((ResourceRegistry)this.getRegistry());
    }

    public void setPersistenceManager(PersistenceManager manager) {
        this.persistenceManager = manager;
    }

    protected void action_File_Close() {
        int i = this.getJTabbedPane().getSelectedIndex();
        if (i >= 0) {
            this.getJTabbedPane().removeTabAt(i);
        }
    }

    protected void action_Edit_ResizeModel() {
        ModelEditor modelEditor = this.getSelectedModelEditor();
        if (modelEditor == null) {
            return;
        }
        this.refreshModelResizeDialog();
        this.getJDialogResizeModel().pack();
        this.getJDialogResizeModel().setModal(true);
        this.getJDialogResizeModel().setVisible(true);
    }

    protected void refreshModelResizeDialog() {
        ModelEditor modelEditor = this.getSelectedModelEditor();
        if (modelEditor == null) {
            return;
        }
        ElementModel model = modelEditor.getModel();
        if (model == null) {
            return;
        }
        this.getJTextFieldGridColumns().setText("" + model.getMapColumns());
        this.getJTextFieldGridRows().setText("" + model.getMapRows());
        this.getJTextFieldCellWidth().setText("" + (int)model.getMapCellWidth());
        this.getJTextFieldCellHeight().setText("" + (int)model.getMapCellHeight());
        this.getJTextFieldModelWidth().setText("" + (int)model.getMapCellWidth() * model.getMapColumns());
        this.getJTextFieldModelHeight().setText("" + (int)model.getMapCellHeight() * model.getMapRows());
    }

    protected void applyResizeModelDialog() {
        ModelEditor modelEditor = this.getSelectedModelEditor();
        if (modelEditor == null) {
            return;
        }
        ElementModel model = modelEditor.getModel();
        if (model == null) {
            return;
        }
        int newMapColumns = Integer.parseInt(this.getJTextFieldGridColumns().getText());
        int newMapRows = Integer.parseInt(this.getJTextFieldGridRows().getText());
        int newCellWidth = Integer.parseInt(this.getJTextFieldCellWidth().getText());
        int newCellHeight = Integer.parseInt(this.getJTextFieldCellHeight().getText());
        System.out.println("Apply Model size: " + newMapColumns + "*" + newCellWidth + ", " + newMapRows + "*" + newCellHeight);
        int num = model.getViewCount();
        for (int c = 0; c < num; ++c) {
            model.removeView(model.getViewAt(c));
        }
        model.resizeMap(newMapColumns, newMapRows, (double)newCellWidth, (double)newCellHeight);
        try {
            modelEditor.setModel(null);
            modelEditor.setModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ElementView view = (ElementView)model.createView(0.0, 0.0, 800.0, 600.0);
        modelEditor.setView(view);
    }

    protected void action_Help_About() {
    }

    protected void action_File_New() {
        try {
            ElementModel model = this.createDefaultModel();
            System.out.println("Model-Elements: " + model.getElementCount());
            this.addModelEditor(this.createModelEditor(model));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void action_File_Open() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.getCurrentDirectory());
        int rc = fileChooser.showOpenDialog(this);
        if (rc != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.setCurrentDirectory(fileChooser.getCurrentDirectory());
        try {
            ElementModel newModel = this.openModel(file);
            if (newModel != null) {
                ModelEditor modelEditor = this.createModelEditor(newModel);
                this.fixElementModel(newModel, modelEditor);
                modelEditor.setModelFile(file);
                this.addModelEditor(modelEditor);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void action_File_Save() {
        ModelEditor modelEditor = this.getSelectedModelEditor();
        if (modelEditor == null) {
            return;
        }
        ElementModel model = modelEditor.getModel();
        if (model == null) {
            return;
        }
        File modelFile = modelEditor.getModelFile();
        if (modelFile == null) {
            this.action_File_SaveAs();
            return;
        }
        try {
            this.saveModel(model, modelFile);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void action_File_SaveAs() {
        ModelEditor modelEditor = this.getSelectedModelEditor();
        if (modelEditor == null) {
            return;
        }
        ElementModel model = modelEditor.getModel();
        if (model == null) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.getCurrentDirectory());
        int rc = fileChooser.showSaveDialog(this);
        if (rc != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.setCurrentDirectory(fileChooser.getCurrentDirectory());
        try {
            this.saveModel(model, file);
            modelEditor.setModelFile(file);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveModel(ElementModel model, File file) throws Exception {
        if (file.exists()) {
            File bkpFile = new File(file.getPath() + ".bkp");
            if (bkpFile.exists()) {
                bkpFile.delete();
            }
            file.renameTo(bkpFile);
        }
        FileOutputStream fout = new FileOutputStream(file);
        try {
            PersistenceManager pm = this.getPersistenceManager();
            pm.writeModel((Model)model, (OutputStream)fout);
        }
        finally {
            fout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementModel openModel(File file) throws Exception {
        FileInputStream fin = new FileInputStream(file);
        try {
            PersistenceManager pm = this.getPersistenceManager();
            ElementModel elementModel = (ElementModel)pm.readModel((InputStream)fin);
            return elementModel;
        }
        finally {
            fin.close();
        }
    }

    protected ElementModel createDefaultModel() throws Exception {
        double cellWidth = 1000.0;
        double cellHeight = 1000.0;
        int columns = 100;
        int rows = 100;
        ElementModel model = new ElementModel(cellWidth, cellHeight, columns, rows);
        return model;
    }

    protected void handleException(Throwable e) {
        e.printStackTrace();
    }

    protected DefaultResourceRegistry createRegistry() {
        return new DefaultResourceRegistry();
    }

    public DefaultResourceRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    public void setRegistry(DefaultResourceRegistry registry) {
        this.registry = registry;
        this.refreshElementTypes();
    }

    protected ModelEditor createModelEditor(ElementModel model) {
        ModelEditor editor = new ModelEditor();
        editor.setElementTypes(this.elementTypes);
        editor.setModel(model);
        editor.setClipboard(this.getClipboard());
        ElementView view = (ElementView)model.createView(0.0, 0.0, 800.0, 600.0);
        editor.setView(view);
        return editor;
    }

    protected void addModelEditor(ModelEditor editor) {
        this.getJTabbedPane().add("Model-Editor", editor);
    }

    protected ModelEditor getSelectedModelEditor() {
        return (ModelEditor)this.getJTabbedPane().getSelectedComponent();
    }

    protected ElementClipboard createClipboard() {
        return new DefaultElementClipboard();
    }

    public ElementClipboard getClipboard() {
        if (this.clipboard == null) {
            this.setClipboard(this.createClipboard());
        }
        return this.clipboard;
    }

    public void setClipboard(ElementClipboard clipboard) {
        this.clipboard = clipboard;
    }

    protected void fixElementModel(ElementModel model, ModelEditor editor) {
        HashSet<Object> ids = new HashSet<Object>();
        long nextId = 1L;
        Iterator i = model.getElements();
        while (i.hasNext()) {
            String sid;
            Element el = (Element)i.next();
            Object id = el.getId();
            if (id != null && !ids.contains(id)) {
                ids.add(id);
                continue;
            }
            while (true) {
                if (!ids.contains(sid = String.valueOf(nextId))) break;
                ++nextId;
            }
            id = sid;
            el.setId(id);
            ids.add(id);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public static abstract class DocAdapter
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handle(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handle(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handle(e);
        }

        protected abstract void handle(DocumentEvent var1);
    }
}

