/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.editor;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ElementView;
import com.spacekiller.game2d.Rect;
import com.spacekiller.game2d.View;
import com.spacekiller.game2d.editor.ElementClipboard;
import com.spacekiller.game2d.editor.ViewPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;

public class ModelEditor
extends JPanel {
    private static final long serialVersionUID = 267732137852015021L;
    private File modelFile;
    private ElementModel model;
    private ElementView view;
    private List elementTypes = new ArrayList();
    private List createElementMenuItems = new ArrayList();
    private int scrollUnit = 10;
    private JScrollBar scrollBarY = null;
    private JScrollBar scrollBarX = null;
    private ViewPanel viewPanel = null;
    private Point lastDragPoint = new Point();
    private ElementClipboard clipboard;
    private long nextElementId = 1L;
    private boolean selecting = false;
    private boolean selectionVisible = false;
    private double selectionStartX;
    private double selectionStartY;
    private double selectionEndX;
    private double selectionEndY;
    private JPanel jPanelStatus = null;
    private JLabel jLabelStatus = null;
    private JToolBar jToolBar = null;
    private JButton jButtonCopy = null;
    private JButton jButtonPaste = null;
    private JPanel jPanelTools = null;
    private JButton jButtonCut = null;
    private JButton jButtonDelete = null;
    private JPanel jPanelView = null;
    private JButton jButtonAdd = null;
    private JPopupMenu jPopupMenu = null;
    private JMenu jMenuCreate = null;
    private JMenuItem jMenuItemCopy = null;
    private JMenuItem jMenuItemCut = null;
    private JMenuItem jMenuItemPaste = null;
    private JMenuItem jMenuItemDelete = null;
    private JPopupMenu jPopupMenuCreate = null;

    public ModelEditor() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints consGridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints21 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints11 = new GridBagConstraints();
        consGridBagConstraints11.gridy = 1;
        consGridBagConstraints11.gridx = 1;
        consGridBagConstraints11.fill = 1;
        consGridBagConstraints11.weightx = 1.0;
        consGridBagConstraints11.weighty = 1.0;
        consGridBagConstraints21.fill = 1;
        consGridBagConstraints21.gridwidth = 2;
        consGridBagConstraints21.gridx = 0;
        consGridBagConstraints21.gridy = 0;
        consGridBagConstraints4.fill = 1;
        consGridBagConstraints4.gridy = 3;
        consGridBagConstraints4.gridx = 0;
        consGridBagConstraints4.gridwidth = 2;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJPanelStatus(), consGridBagConstraints4);
        this.add((Component)this.getJPanelTools(), consGridBagConstraints21);
        this.add((Component)this.getJPanelView(), consGridBagConstraints11);
        this.setSize(536, 307);
        this.setBackground(new Color(0, 150, 250));
    }

    public ElementModel getModel() {
        return this.model;
    }

    public void setModel(ElementModel model) {
        this.model = model;
        this.refreshScrollSize();
    }

    public ElementView getView() {
        return this.view;
    }

    public void setView(ElementView view) {
        if (this.view == view) {
            return;
        }
        this.view = view;
        this.getViewPanel().removeAllSelectedElements();
        this.getViewPanel().setView(view);
        this.refreshViewSize();
    }

    protected void refreshScrollSize() {
        int modelWidth = 2000;
        int modelHeight = 2000;
        if (this.model != null) {
            Rectangle2D bounds = this.model.getBounds();
            modelWidth = (int)bounds.getWidth();
            modelHeight = (int)bounds.getHeight();
        }
        this.getScrollBarX().setMinimum(0);
        this.getScrollBarX().setMaximum(modelWidth);
        this.getScrollBarY().setMinimum(0);
        this.getScrollBarY().setMaximum(modelHeight);
    }

    protected void refreshViewSize() {
        if (this.view != null && this.model != null) {
            Rect rect = this.view.getViewRect();
            this.model.updateView((View)this.view, rect.getX(), rect.getY(), (double)this.viewPanel.getWidth(), (double)this.viewPanel.getHeight());
            this.viewPanel.repaint();
            this.refreshViewInfo();
        }
    }

    protected void updateViewX(double x) {
        if (this.view != null && this.model != null && this.view.getModel() == this.model) {
            this.model.updateView((View)this.view, x, this.view.getViewRect().getY(), (double)this.viewPanel.getWidth(), (double)this.viewPanel.getHeight());
            this.viewPanel.repaint();
            this.refreshViewInfo();
            if (this.selecting) {
                this.selectionVisible = false;
            }
        }
    }

    protected void updateViewY(double y) {
        if (this.view != null && this.model != null && this.view.getModel() == this.model) {
            this.model.updateView((View)this.view, this.view.getViewRect().getX(), y, (double)this.viewPanel.getWidth(), (double)this.viewPanel.getHeight());
            this.viewPanel.repaint();
            this.refreshViewInfo();
            if (this.selecting) {
                this.selectionVisible = false;
            }
        }
    }

    protected void refreshViewInfo() {
        Rect rect = this.view.getViewRect();
        this.getJLabelStatus().setText("View: " + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight());
    }

    protected void refreshSelectedElementInfo() {
        Iterator i = this.getViewPanel().getSelectedElements();
        if (!i.hasNext()) {
            this.getJLabelStatus().setText("Nothing selected.");
        } else {
            Element el = (Element)i.next();
            this.getJLabelStatus().setText("Selected: " + el + ", Pos: " + (int)el.getX() + ", " + (int)el.getY());
        }
    }

    protected boolean selectElementAt(double x, double y, boolean extendSelection) {
        Element el = this.getElementAt(x, y);
        if (el == null) {
            if (!extendSelection) {
                this.getViewPanel().removeAllSelectedElements();
                this.getViewPanel().repaint();
                this.refreshSelectedElementInfo();
            }
            return false;
        }
        System.out.println("-> select element at " + x + ", " + y + " --> " + el);
        if (this.view == null) {
            return false;
        }
        if (extendSelection) {
            if (this.getViewPanel().isSelectedElement(el)) {
                this.getViewPanel().removeSelectedElement(el);
            } else {
                this.getViewPanel().addSelectedElement(el);
            }
        } else {
            if (this.getViewPanel().isSelectedElement(el)) {
                return true;
            }
            this.getViewPanel().removeAllSelectedElements();
            this.getViewPanel().addSelectedElement(el);
        }
        this.getViewPanel().repaint();
        this.refreshSelectedElementInfo();
        return true;
    }

    protected Element getElementAt(double x, double y) {
        if (this.view == null) {
            return null;
        }
        ArrayList viewElements = new ArrayList();
        this.view.getElements(viewElements);
        int count = viewElements.size();
        for (int c = count - 1; c >= 0; --c) {
            Element el = (Element)viewElements.get(c);
            if (!el.contains(x, y)) continue;
            return el;
        }
        return null;
    }

    protected void selectElementsWithin(double x, double y, double w, double h, boolean extendSelection) {
        if (this.view == null) {
            return;
        }
        if (!extendSelection) {
            this.getViewPanel().removeAllSelectedElements();
        }
        ArrayList elements = new ArrayList();
        this.model.getElements(elements);
        int count = elements.size();
        for (int c = count - 1; c >= 0; --c) {
            Element el = (Element)elements.get(c);
            double elx = el.getX();
            double ely = el.getY();
            double elw = el.getWidth();
            double elh = el.getHeight();
            if (!(elx >= x) || !(ely >= y) || !(elx + elw < x + w) || !(ely + elh < y + h) || this.getViewPanel().isSelectedElement(el)) continue;
            this.getViewPanel().addSelectedElement(el);
        }
        this.getViewPanel().repaint();
        this.refreshSelectedElementInfo();
    }

    private JScrollBar getScrollBarY() {
        if (this.scrollBarY == null) {
            this.scrollBarY = new JScrollBar();
            this.scrollBarY.setUnitIncrement(this.scrollUnit);
            this.scrollBarY.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (ModelEditor.this.view != null) {
                        ModelEditor.this.updateViewY(e.getValue());
                    }
                }
            });
        }
        return this.scrollBarY;
    }

    private JScrollBar getScrollBarX() {
        if (this.scrollBarX == null) {
            this.scrollBarX = new JScrollBar();
            this.scrollBarX.setOrientation(0);
            this.scrollBarX.setUnitIncrement(this.scrollUnit);
            this.scrollBarX.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (ModelEditor.this.view != null) {
                        ModelEditor.this.updateViewX(e.getValue());
                    }
                }
            });
        }
        return this.scrollBarX;
    }

    private ViewPanel getViewPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = new ViewPanel();
            this.viewPanel.setSize(1, 1);
            this.viewPanel.setBackground(new Color(153, 204, 255));
            this.viewPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ModelEditor.this.refreshViewSize();
                }
            });
            this.viewPanel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ModelEditor.this.view != null) {
                        ModelEditor.this.lastDragPoint.setLocation(e.getX(), e.getY());
                        Rect rect = ModelEditor.this.view.getViewRect();
                        boolean rc = ModelEditor.this.selectElementAt(rect.getX() + (double)e.getX(), rect.getY() + (double)e.getY(), (e.getModifiers() & 2) != 0);
                        ModelEditor.this.getViewPanel().requestFocus();
                        if (!rc) {
                            if (!ModelEditor.this.selecting) {
                                ModelEditor.this.selecting = true;
                                ModelEditor.this.selectionStartX = rect.getX() + (double)e.getX();
                                ModelEditor.this.selectionStartY = rect.getY() + (double)e.getY();
                                ModelEditor.this.selectionEndX = ModelEditor.this.selectionStartX;
                                ModelEditor.this.selectionEndY = ModelEditor.this.selectionStartY;
                                ModelEditor.this.paintSelectionRect();
                                ModelEditor.this.selectionVisible = true;
                            } else {
                                double z;
                                ModelEditor.this.selecting = false;
                                ModelEditor.this.selectionEndX = rect.getX() + (double)e.getX();
                                ModelEditor.this.selectionEndY = rect.getY() + (double)e.getY();
                                ModelEditor.this.paintSelectionRect();
                                ModelEditor.this.selectionVisible = false;
                                double x = ModelEditor.this.selectionStartX;
                                double y = ModelEditor.this.selectionStartY;
                                double x2 = ModelEditor.this.selectionEndX;
                                double y2 = ModelEditor.this.selectionEndY;
                                if (x > x2) {
                                    z = x;
                                    x = x2;
                                    x2 = z;
                                }
                                if (y > y2) {
                                    z = y;
                                    y = y2;
                                    y2 = z;
                                }
                                double w = x2 - x;
                                double h = y2 - y;
                                ModelEditor.this.selectElementsWithin(x, y, w, h, (e.getModifiers() & 2) != 0);
                            }
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        int count = ModelEditor.this.createElementMenuItems.size();
                        ModelEditor.this.getJMenuCreate().removeAll();
                        for (int c = 0; c < count; ++c) {
                            ModelEditor.this.getJMenuCreate().add((JMenuItem)ModelEditor.this.createElementMenuItems.get(c));
                        }
                        ModelEditor.this.getJPopupMenu().show(ModelEditor.this.getViewPanel(), e.getX(), e.getY());
                    }
                }
            });
            this.viewPanel.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (ModelEditor.this.selecting) {
                        if (ModelEditor.this.selectionVisible) {
                            ModelEditor.this.paintSelectionRect();
                        }
                        Rect rect = ModelEditor.this.view.getViewRect();
                        ModelEditor.this.selectionEndX = rect.getX() + (double)e.getX();
                        ModelEditor.this.selectionEndY = rect.getY() + (double)e.getY();
                        ModelEditor.this.paintSelectionRect();
                        ModelEditor.this.selectionVisible = true;
                        return;
                    }
                    Iterator i = ModelEditor.this.getViewPanel().getSelectedElements();
                    double moveX = (double)e.getX() - ModelEditor.this.lastDragPoint.getX();
                    double moveY = (double)e.getY() - ModelEditor.this.lastDragPoint.getY();
                    ModelEditor.this.lastDragPoint.setLocation(e.getX(), e.getY());
                    while (i.hasNext()) {
                        Element el = (Element)i.next();
                        ModelEditor.this.model.moveBy(el, moveX, moveY);
                    }
                    ModelEditor.this.getViewPanel().repaint();
                    ModelEditor.this.refreshSelectedElementInfo();
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (ModelEditor.this.selecting) {
                        if (ModelEditor.this.selectionVisible) {
                            ModelEditor.this.paintSelectionRect();
                        }
                        Rect rect = ModelEditor.this.view.getViewRect();
                        ModelEditor.this.selectionEndX = rect.getX() + (double)e.getX();
                        ModelEditor.this.selectionEndY = rect.getY() + (double)e.getY();
                        ModelEditor.this.paintSelectionRect();
                        ModelEditor.this.selectionVisible = true;
                        return;
                    }
                }
            });
            this.viewPanel.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    System.out.println("keyTyped: " + e);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 65: {
                            if ((e.getModifiers() & 2) == 0) break;
                            ModelEditor.this.selectAllElements();
                            return;
                        }
                        case 67: {
                            if ((e.getModifiers() & 2) == 0) break;
                            try {
                                ModelEditor.this.copySelectedElements();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return;
                        }
                        case 88: {
                            if ((e.getModifiers() & 2) == 0) break;
                            try {
                                ModelEditor.this.copySelectedElements();
                                ModelEditor.this.deleteSelectedElements();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return;
                        }
                        case 127: {
                            ModelEditor.this.deleteSelectedElements();
                            return;
                        }
                        case 86: {
                            if ((e.getModifiers() & 2) == 0) break;
                            try {
                                ModelEditor.this.pasteElements();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            return;
                        }
                    }
                    System.out.println("keyPressed: " + e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
        }
        return this.viewPanel;
    }

    private JPanel getJPanelStatus() {
        if (this.jPanelStatus == null) {
            this.jPanelStatus = new JPanel();
            GridBagConstraints consGridBagConstraints6 = new GridBagConstraints();
            consGridBagConstraints6.fill = 2;
            consGridBagConstraints6.weightx = 1.0;
            this.jPanelStatus.setLayout(new GridBagLayout());
            this.jPanelStatus.add((Component)this.getJLabelStatus(), consGridBagConstraints6);
            this.jPanelStatus.setBackground(Color.gray);
        }
        return this.jPanelStatus;
    }

    private JLabel getJLabelStatus() {
        if (this.jLabelStatus == null) {
            this.jLabelStatus = new JLabel();
            this.jLabelStatus.setText("JLabelStatus");
            this.jLabelStatus.setForeground(Color.white);
        }
        return this.jLabelStatus;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.add(this.getJButtonAdd());
            this.jToolBar.add(this.getJButtonCopy());
            this.jToolBar.add(this.getJButtonCut());
            this.jToolBar.add(this.getJButtonPaste());
            this.jToolBar.add(this.getJButtonDelete());
            this.jToolBar.setOpaque(false);
        }
        return this.jToolBar;
    }

    private JButton getJButtonCopy() {
        if (this.jButtonCopy == null) {
            this.jButtonCopy = new JButton();
            this.jButtonCopy.setText("");
            this.jButtonCopy.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/copy_edit.gif")));
            this.jButtonCopy.setToolTipText("Copy selected element(s)");
            this.jButtonCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ModelEditor.this.copySelectedElements();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.jButtonCopy;
    }

    protected void copySelectedElements() throws Exception {
        if (this.getViewPanel().getSelectedElementCount() < 1) {
            return;
        }
        ElementClipboard board = this.getClipboard();
        board.clear();
        Iterator i = this.getViewPanel().getSelectedElements();
        while (i.hasNext()) {
            board.addElement((Element)i.next());
        }
    }

    protected void pasteElements() throws Exception {
        ElementClipboard board = this.getClipboard();
        int count = board.getElementCount();
        if (count < 1) {
            return;
        }
        this.getViewPanel().removeAllSelectedElements();
        for (int c = 0; c < count; ++c) {
            Element el = board.getElementAt(c);
            if (el == null) continue;
            el.setId(this.createElementId());
            this.getModel().add(el);
            this.getViewPanel().addSelectedElement(el);
        }
        try {
            this.getView().checkConsistency();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getViewPanel().validate();
        this.getViewPanel().repaint();
    }

    private JButton getJButtonPaste() {
        if (this.jButtonPaste == null) {
            this.jButtonPaste = new JButton();
            this.jButtonPaste.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/paste_edit.gif")));
            this.jButtonPaste.setToolTipText("Paste element(s)");
            this.jButtonPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ModelEditor.this.pasteElements();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.jButtonPaste;
    }

    private JPanel getJPanelTools() {
        if (this.jPanelTools == null) {
            this.jPanelTools = new JPanel();
            GridLayout layGridLayout3 = new GridLayout();
            layGridLayout3.setRows(1);
            this.jPanelTools.setLayout(layGridLayout3);
            this.jPanelTools.add((Component)this.getJToolBar(), null);
            this.jPanelTools.setBackground(new Color(230, 228, 228));
        }
        return this.jPanelTools;
    }

    private JButton getJButtonCut() {
        if (this.jButtonCut == null) {
            this.jButtonCut = new JButton();
            this.jButtonCut.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/cut_edit.gif")));
            this.jButtonCut.setToolTipText("Cut element(s)");
            this.jButtonCut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ModelEditor.this.copySelectedElements();
                        ModelEditor.this.deleteSelectedElements();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.jButtonCut;
    }

    private JButton getJButtonDelete() {
        if (this.jButtonDelete == null) {
            this.jButtonDelete = new JButton();
            this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/delete_edit.gif")));
            this.jButtonDelete.setToolTipText("Delete element(s)");
            this.jButtonDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModelEditor.this.deleteSelectedElements();
                }
            });
        }
        return this.jButtonDelete;
    }

    protected void selectAllElements() {
        this.getViewPanel().removeAllSelectedElements();
        if (this.model != null) {
            Iterator i = this.model.getElements();
            while (i.hasNext()) {
                this.getViewPanel().addSelectedElement((Element)i.next());
            }
        }
        this.getViewPanel().repaint();
    }

    protected void deleteSelectedElements() {
        Iterator i = this.getViewPanel().getSelectedElements();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            this.getModel().remove(el);
        }
        try {
            this.getView().checkConsistency();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getViewPanel().removeAllSelectedElements();
        this.getViewPanel().repaint();
    }

    private JPanel getJPanelView() {
        if (this.jPanelView == null) {
            this.jPanelView = new JPanel();
            GridBagConstraints consGridBagConstraints22 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints41 = new GridBagConstraints();
            consGridBagConstraints22.gridx = 0;
            consGridBagConstraints22.gridy = 0;
            consGridBagConstraints22.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints22.fill = 1;
            consGridBagConstraints3.gridx = 1;
            consGridBagConstraints3.gridy = 0;
            consGridBagConstraints3.weighty = 1.0;
            consGridBagConstraints3.fill = 3;
            consGridBagConstraints41.gridx = 0;
            consGridBagConstraints41.gridy = 1;
            consGridBagConstraints41.weightx = 1.0;
            consGridBagConstraints41.weighty = 0.0;
            consGridBagConstraints41.fill = 2;
            this.jPanelView.setLayout(new GridBagLayout());
            this.jPanelView.add((Component)this.getViewPanel(), consGridBagConstraints22);
            this.jPanelView.add((Component)this.getScrollBarY(), consGridBagConstraints3);
            this.jPanelView.add((Component)this.getScrollBarX(), consGridBagConstraints41);
            this.jPanelView.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jPanelView;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setContentPane(new ModelEditor());
        frame.pack();
        frame.setVisible(true);
    }

    private JButton getJButtonAdd() {
        if (this.jButtonAdd == null) {
            this.jButtonAdd = new JButton();
            this.jButtonAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/newaccessbean_wiz.gif")));
            this.jButtonAdd.setToolTipText("Create element");
            this.jButtonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int count = ModelEditor.this.createElementMenuItems.size();
                    ModelEditor.this.getJPopupMenuCreate().removeAll();
                    for (int c = 0; c < count; ++c) {
                        ModelEditor.this.getJPopupMenuCreate().add((JMenuItem)ModelEditor.this.createElementMenuItems.get(c));
                    }
                    ModelEditor.this.getJPopupMenuCreate().show(ModelEditor.this.getJButtonAdd(), 0, ModelEditor.this.getJButtonAdd().getHeight());
                }
            });
        }
        return this.jButtonAdd;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.add(this.getJMenuCreate());
            this.jPopupMenu.add(this.getJMenuItemCopy());
            this.jPopupMenu.add(this.getJMenuItemCut());
            this.jPopupMenu.add(this.getJMenuItemPaste());
            this.jPopupMenu.add(this.getJMenuItemDelete());
        }
        return this.jPopupMenu;
    }

    private JMenu getJMenuCreate() {
        if (this.jMenuCreate == null) {
            this.jMenuCreate = new JMenu();
            this.jMenuCreate.setText("Create");
            this.jMenuCreate.setToolTipText("Create new element..");
            this.jMenuCreate.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/newaccessbean_wiz.gif")));
        }
        return this.jMenuCreate;
    }

    private JMenuItem getJMenuItemCopy() {
        if (this.jMenuItemCopy == null) {
            this.jMenuItemCopy = new JMenuItem();
            this.jMenuItemCopy.setText("Copy");
            this.jMenuItemCopy.setToolTipText("Copy element(s)");
            this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/copy_edit.gif")));
            this.jMenuItemCopy.setFont(new Font("Dialog", 0, 12));
            this.jMenuItemCopy.setEnabled(false);
        }
        return this.jMenuItemCopy;
    }

    private JMenuItem getJMenuItemCut() {
        if (this.jMenuItemCut == null) {
            this.jMenuItemCut = new JMenuItem();
            this.jMenuItemCut.setText("Cut");
            this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/cut_edit.gif")));
            this.jMenuItemCut.setFont(new Font("Dialog", 0, 12));
            this.jMenuItemCut.setEnabled(false);
        }
        return this.jMenuItemCut;
    }

    private JMenuItem getJMenuItemPaste() {
        if (this.jMenuItemPaste == null) {
            this.jMenuItemPaste = new JMenuItem();
            this.jMenuItemPaste.setText("Paste");
            this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/paste_edit.gif")));
            this.jMenuItemPaste.setFont(new Font("Dialog", 0, 12));
            this.jMenuItemPaste.setEnabled(false);
        }
        return this.jMenuItemPaste;
    }

    private JMenuItem getJMenuItemDelete() {
        if (this.jMenuItemDelete == null) {
            this.jMenuItemDelete = new JMenuItem();
            this.jMenuItemDelete.setText("Delete");
            this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/game2d/icons/delete_edit.gif")));
            this.jMenuItemDelete.setFont(new Font("Dialog", 0, 12));
            this.jMenuItemDelete.setEnabled(false);
        }
        return this.jMenuItemDelete;
    }

    public List getElementTypes() {
        return this.elementTypes;
    }

    public void setElementTypes(List list) {
        this.elementTypes = list;
        this.refreshCreateElementMenuItems();
    }

    protected void refreshCreateElementMenuItems() {
        int newCount = this.elementTypes.size();
        int oldCount = this.createElementMenuItems.size();
        for (int c = 0; c < oldCount; ++c) {
            this.createElementMenuItems.remove(0);
        }
        HashMap<String, JMenu> menus = new HashMap<String, JMenu>();
        int c = 0;
        while (c < newCount) {
            ElementType type = (ElementType)this.elementTypes.get(c);
            String group = "" + type.getGroup();
            String name = "" + type.getId();
            JMenu menu = (JMenu)menus.get(group);
            if (menu == null) {
                menu = new JMenu();
                menu.setText(group);
                menus.put(group, menu);
                this.createElementMenuItems.add(menu);
            }
            JMenuItem item = new JMenuItem();
            item.setText(name);
            final int itemIndex = c++;
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ModelEditor.this.createElement(itemIndex);
                }
            });
            menu.add(item);
        }
    }

    protected void createElement(int elementTypeIndex) {
        ElementType elementType = (ElementType)this.elementTypes.get(elementTypeIndex);
        if (elementType == null) {
            return;
        }
        System.out.println("Add element of type: " + elementType);
        try {
            Rect viewRect = this.view.getViewRect();
            Element el = elementType.createElement(this.createElementId(), viewRect.getX() + 10.0, viewRect.getY() + 10.0, 1.0, 1.0);
            this.model.add(el);
            try {
                this.getView().checkConsistency();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getViewPanel().repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized Object createElementId() {
        return String.valueOf(this.nextElementId++);
    }

    private JPopupMenu getJPopupMenuCreate() {
        if (this.jPopupMenuCreate == null) {
            this.jPopupMenuCreate = new JPopupMenu();
        }
        return this.jPopupMenuCreate;
    }

    public ElementClipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(ElementClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public File getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(File modelFile) {
        this.modelFile = modelFile;
    }

    protected void handleException(Throwable e) {
        e.printStackTrace();
    }

    protected void paintSelectionRect() {
        int z;
        Rect rect = this.view.getViewRect();
        int x = (int)(this.selectionStartX - rect.getX());
        int y = (int)(this.selectionStartY - rect.getY());
        int x2 = (int)(this.selectionEndX - rect.getX());
        int y2 = (int)(this.selectionEndY - rect.getY());
        if (x > x2) {
            z = x;
            x = x2;
            x2 = z;
        }
        if (y > y2) {
            z = y;
            y = y2;
            y2 = z;
        }
        int w = x2 - x;
        int h = y2 - y;
        Graphics g = this.getViewPanel().getGraphics();
        g.setXORMode(Color.YELLOW);
        g.drawRect(x, y, w, h);
        g.setPaintMode();
    }
}

